/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.PositionReader;
import alluxio.PositionReaderTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DoraPositionReaderIntegrationTest
extends BaseIntegrationTest {
    private static final String UFS_ROOT = AlluxioTestDirectory.createTemporaryDirectory((String)"ufs_root").getAbsolutePath();
    @Parameterized.Parameter
    public int mFileLen;
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.WORKER_NETWORK_NETTY_FILE_TRANSFER_TYPE, "TRANSFER").setProperty(PropertyKey.DORA_CLIENT_UFS_ROOT, UFS_ROOT).setProperty(PropertyKey.MASTER_WORKER_REGISTER_LEASE_ENABLED, false).setProperty(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES, 1024).setProperty(PropertyKey.WORKER_BLOCK_STORE_TYPE, "PAGE").setProperty(PropertyKey.WORKER_PAGE_STORE_PAGE_SIZE, 1024).setProperty(PropertyKey.WORKER_PAGE_STORE_SIZES, "1GB").setProperty(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED, true).build();
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    private FileSystem mFileSystem;
    private String mFilePath;
    private PositionReader mPositionReader;
    private PositionReaderTest mPositionReaderTest;

    @Parameterized.Parameters(name="{index}-{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {1}, {128}, {256}, {666}, {5314}, {1023}, {1024}, {1025}, {65535}, {65536}, {65537});
    }

    @Before
    public void before() throws Exception {
        FileSystemContext context = FileSystemContext.create((AlluxioConfiguration)this.mClusterResource.get().getClient().getConf());
        this.mFileSystem = this.mClusterResource.get().getClient(context);
        this.mFilePath = UFS_ROOT + PathUtils.uniqPath();
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)this.mFileLen);
        this.mPositionReader = this.mFileSystem.openPositionRead(new AlluxioURI(this.mFilePath));
        this.mPositionReaderTest = new PositionReaderTest(this.mPositionReader, this.mFileLen);
    }

    @After
    public void after() throws Exception {
        this.mPositionReader.close();
        this.mFileSystem.close();
        new File(this.mFilePath).delete();
    }

    @Test
    public void testAllCornerCases() throws IOException {
        this.mPositionReaderTest.testAllCornerCases();
    }

    @Test
    public void testReadRandomPart() throws IOException {
        this.mPositionReaderTest.testReadRandomPart();
    }

    @Test
    public void testConcurrentReadRandomPart() throws Exception {
        this.mPositionReaderTest.concurrentReadPart();
    }
}

