/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.security.authorization.Mode;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileBlockInfo;
import alluxio.worker.block.BlockStoreType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix the tests")
public final class FileInStreamIntegrationTest
extends BaseIntegrationTest {
    private static final int BLOCK_SIZE = 0x100000;
    private static final int MIN_LEN = 0x100001;
    private static final int MAX_LEN = 0x400001;
    private static final int DELTA = 524288;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource;
    private FileSystem mFileSystem;
    private CreateFilePOptions mWriteBoth;
    private CreateFilePOptions mWriteAlluxio;
    private CreateFilePOptions mWriteUnderStore;
    private String mTestPath;
    @Rule
    public Timeout mGlobalTimeout = Timeout.seconds((long)60L);
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Parameterized.Parameters(name="{index}_BlockStoreType_{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({BlockStoreType.PAGE}, {BlockStoreType.FILE});
    }

    public FileInStreamIntegrationTest(BlockStoreType blockStoreType) {
        LocalAlluxioClusterResource.Builder builder = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.WORKER_BLOCK_STORE_TYPE, blockStoreType).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 0x100000);
        if (blockStoreType == BlockStoreType.PAGE) {
            builder.setProperty(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES, 1024).setProperty(PropertyKey.WORKER_PAGE_STORE_SIZES, ImmutableList.of((Object)0x6400000)).setProperty(PropertyKey.WORKER_PAGE_STORE_DIRS, ImmutableList.of((Object)AlluxioTestDirectory.createTemporaryDirectory((String)"page_store").getAbsolutePath()));
        }
        this.mLocalAlluxioClusterResource = builder.build();
    }

    @Before
    public void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        this.mWriteBoth = CreateFilePOptions.newBuilder().setMode(Mode.createFullAccess().toProto()).setBlockSizeBytes(0x100000L).setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build();
        this.mWriteAlluxio = CreateFilePOptions.newBuilder().setMode(Mode.createFullAccess().toProto()).setBlockSizeBytes(0x100000L).setWriteType(WritePType.MUST_CACHE).setRecursive(true).build();
        this.mWriteUnderStore = CreateFilePOptions.newBuilder().setMode(Mode.createFullAccess().toProto()).setBlockSizeBytes(0x100000L).setWriteType(WritePType.THROUGH).setRecursive(true).build();
        this.mTestPath = PathUtils.uniqPath();
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(this.mTestPath + "/file_" + k + "_" + op.hashCode());
                FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)path, (CreateFilePOptions)op, (int)k);
            }
        }
    }

    private List<CreateFilePOptions> getOptionSet() {
        ArrayList<CreateFilePOptions> ret = new ArrayList<CreateFilePOptions>(3);
        ret.add(this.mWriteBoth);
        ret.add(this.mWriteAlluxio);
        ret.add(this.mWriteUnderStore);
        return ret;
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.streaming.reader.chunk.size.bytes", "64KB"})
    public void readTest1() throws Exception {
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                byte[] ret = new byte[k];
                int value = is.read();
                int cnt = 0;
                while (value != -1) {
                    Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                    ret[cnt++] = (byte)value;
                    value = is.read();
                }
                Assert.assertEquals((long)cnt, (long)k);
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                ret = new byte[k];
                value = is.read();
                cnt = 0;
                while (value != -1) {
                    Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                    ret[cnt++] = (byte)value;
                    value = is.read();
                }
                Assert.assertEquals((long)cnt, (long)k);
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.streaming.reader.chunk.size.bytes", "64KB"})
    public void readTest2() throws Exception {
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                byte[] ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.streaming.reader.chunk.size.bytes", "64KB"})
    public void readTest3() throws Exception {
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                byte[] ret = new byte[k / 2];
                Assert.assertEquals((long)(k / 2), (long)is.read(ret, 0, k / 2));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(k / 2), (byte[])ret));
                is.close();
                is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret, 0, k));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
            }
        }
    }

    @Test
    public void readEndOfFile() throws Exception {
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                Throwable throwable = null;
                try {
                    byte[] ret = new byte[k / 2];
                    int readBytes = is.read(ret, 0, k / 2);
                    while (readBytes != -1) {
                        readBytes = is.read(ret);
                        Assert.assertTrue((0 != readBytes ? 1 : 0) != 0);
                    }
                    Assert.assertEquals((long)-1L, (long)readBytes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    @Test
    public void seekExceptionTest1() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                Throwable throwable = null;
                try {
                    is.seek(-1L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    @Test
    public void seekExceptionTest2() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                Throwable throwable = null;
                try {
                    is.seek((long)(k + 1));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    @Test
    public void seek() throws Exception {
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                is.seek((long)(k / 3));
                Assert.assertEquals((long)BufferUtils.intAsUnsignedByteValue((int)(k / 3)), (long)is.read());
                is.seek((long)(k / 2));
                Assert.assertEquals((long)BufferUtils.intAsUnsignedByteValue((int)(k / 2)), (long)is.read());
                is.seek((long)(k / 4));
                Assert.assertEquals((long)BufferUtils.intAsUnsignedByteValue((int)(k / 4)), (long)is.read());
                is.close();
            }
        }
    }

    @Test
    public void eofSeek() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        int length = 0x300000;
        for (CreateFilePOptions op : this.getOptionSet()) {
            String filename = uniqPath + "/file_" + op.hashCode();
            AlluxioURI uri = new AlluxioURI(filename);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)filename, (int)length, (CreateFilePOptions)op);
            FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
            byte[] data = new byte[length];
            is.read(data, 0, length);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)length, (byte[])data));
            is.seek(0L);
            is.read(data, 0, length);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)length, (byte[])data));
            is.close();
        }
    }

    @Test
    public void skip() throws Exception {
        for (int k = 0x100001; k <= 0x400001; k += 524288) {
            for (CreateFilePOptions op : this.getOptionSet()) {
                String filename = this.mTestPath + "/file_" + k + "_" + op.hashCode();
                AlluxioURI uri = new AlluxioURI(filename);
                FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                Assert.assertEquals((long)(k / 2), (long)is.skip((long)(k / 2)));
                Assert.assertEquals((long)BufferUtils.intAsUnsignedByteValue((int)(k / 2)), (long)is.read());
                Assert.assertEquals((long)(k / 3), (long)is.skip((long)(k / 3)));
                Assert.assertEquals((long)BufferUtils.intAsUnsignedByteValue((int)(k / 2 + k / 3 + 1)), (long)is.read());
                is.close();
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.block.size.bytes.default", "10240", "alluxio.user.file.buffer.bytes", "128"})
    public void concurrentRemoteRead() throws Exception {
        int blockSize = 10240;
        int bufferSize = 128;
        final int length = blockSize * 2;
        final AlluxioURI path = new AlluxioURI(this.mTestPath + "/largeFile");
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)path, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).build(), (int)length);
        int concurrency = 10;
        final AtomicInteger count = new AtomicInteger(0);
        ExecutorService service = Executors.newFixedThreadPool(20);
        for (int i = 0; i < 10; ++i) {
            service.submit(new Runnable(){

                @Override
                public void run() {
                    int bytesRead;
                    byte[] buffer;
                    int start2;
                    Throwable throwable;
                    FileInStream is;
                    try {
                        is = FileInStreamIntegrationTest.this.mFileSystem.openFile(path, OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE).build());
                        throwable = null;
                        try {
                            start2 = 0;
                            while (start2 < length) {
                                buffer = new byte[128];
                                bytesRead = is.read(buffer, 0, 128);
                                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)start2, (int)bytesRead, (byte[])buffer));
                                start2 = bytesRead + start2;
                            }
                            count.incrementAndGet();
                        }
                        catch (Throwable start2) {
                            throwable = start2;
                            throw start2;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable start2) {
                                        throwable.addSuppressed(start2);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        is = FileInStreamIntegrationTest.this.mFileSystem.openFile(path, OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE).build());
                        throwable = null;
                        try {
                            start2 = 0;
                            while (start2 < length) {
                                buffer = new byte[128];
                                bytesRead = is.read(buffer, 0, 128);
                                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)start2, (int)bytesRead, (byte[])buffer));
                                start2 = bytesRead + start2;
                            }
                            count.incrementAndGet();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        service.shutdown();
        service.awaitTermination(60000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)20L, (long)count.get());
    }

    @Test(timeout=30000L)
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.block.size.bytes.default", "16MB", "alluxio.user.streaming.reader.chunk.size.bytes", "64KB", "alluxio.worker.ramdisk.size", "1GB"})
    public void remoteReadLargeFile() throws Exception {
        AlluxioURI filePath = new AlluxioURI(this.mTestPath + "/test");
        try (FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setBlockSizeBytes(0x1000000L).setWriteType(WritePType.THROUGH).build());){
            byte[] bytes = BufferUtils.getIncreasingByteArray((int)0x3200000);
            for (int i = 0; i < 10; ++i) {
                os.write(bytes);
            }
        }
        OpenFilePOptions options = OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE_PROMOTE).build();
        try (FileInStream in = this.mFileSystem.openFile(filePath, options);){
            byte[] buf = new byte[0x800000];
            while (in.read(buf) != -1) {
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.readtype.default", "NO_CACHE"})
    public void positionedReadWithoutCaching() throws Exception {
        for (CreateFilePOptions op : this.getOptionSet()) {
            String filename = this.mTestPath + "/file_" + 0x100001 + "_" + op.hashCode();
            AlluxioURI uri = new AlluxioURI(filename);
            FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
            byte[] ret = new byte[524287];
            Assert.assertEquals((long)524287L, (long)is.positionedRead(524290L, ret, 0, 524288));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)524290, (int)524287, (byte[])ret));
            is.close();
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.sequential.pread.threshold", "700KB"})
    public void positionedReadWithLargeThreshold() throws Exception {
        ArrayList<CreateFilePOptions> optionSet = new ArrayList<CreateFilePOptions>(2);
        optionSet.add(this.mWriteBoth);
        optionSet.add(this.mWriteUnderStore);
        for (CreateFilePOptions op : optionSet) {
            String filename = this.mTestPath + "/file_" + 0x100001 + "_" + op.hashCode();
            AlluxioURI uri = new AlluxioURI(filename);
            FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
            Throwable throwable = null;
            try {
                byte[] ret = new byte[524287];
                Assert.assertEquals((long)524287L, (long)is.positionedRead(524290L, ret, 0, 524288));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)524290, (int)524287, (byte[])ret));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.sequential.pread.threshold", "200KB"})
    public void positionedReadWithSmallThreshold() throws Exception {
        ArrayList<CreateFilePOptions> optionSet = new ArrayList<CreateFilePOptions>(2);
        optionSet.add(this.mWriteBoth);
        optionSet.add(this.mWriteUnderStore);
        for (CreateFilePOptions op : optionSet) {
            String filename = this.mTestPath + "/file_" + 0x100001 + "_" + op.hashCode();
            AlluxioURI uri = new AlluxioURI(filename);
            FileInStream is = this.mFileSystem.openFile(uri, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
            Throwable throwable = null;
            try {
                byte[] ret = new byte[524287];
                Assert.assertEquals((long)524287L, (long)is.positionedRead(524290L, ret, 0, 524288));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)524290, (int)524287, (byte[])ret));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    @Test(timeout=10000L)
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.worker.block.heartbeat.interval", "2000"})
    public void asyncCacheFirstBlock() throws Exception {
        String filename = this.mTestPath + "/file_" + 0x400001 + "_" + this.mWriteUnderStore.hashCode();
        AlluxioURI uri = new AlluxioURI(filename);
        for (ReadType readType : ReadType.values()) {
            this.mFileSystem.free(uri);
            CommonUtils.waitFor((String)"No in-Alluxio data left from previous iteration.", () -> {
                try {
                    URIStatus st = this.mFileSystem.getStatus(uri);
                    return st.getInAlluxioPercentage() == 0;
                }
                catch (Exception e) {
                    return false;
                }
            });
            FileInStream is = this.mFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(readType.toProto()).build());
            is.read();
            URIStatus status = this.mFileSystem.getStatus(uri);
            Assert.assertEquals((long)0L, (long)status.getInAlluxioPercentage());
            is.close();
            if (readType.isCache()) {
                CommonUtils.waitFor((String)"First block to be cached.", () -> {
                    try {
                        URIStatus st = this.mFileSystem.getStatus(uri);
                        boolean achieved = true;
                        for (int i = 0; i < st.getFileBlockInfos().size(); ++i) {
                            FileBlockInfo info = (FileBlockInfo)st.getFileBlockInfos().get(i);
                            achieved = i == 0 ? achieved && !info.getBlockInfo().getLocations().isEmpty() : achieved && info.getBlockInfo().getLocations().isEmpty();
                        }
                        return achieved;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
                continue;
            }
            Thread.sleep(1000L);
            status = this.mFileSystem.getStatus(uri);
            Assert.assertEquals((long)0L, (long)status.getInAlluxioPercentage());
        }
    }

    @Test(timeout=10000L)
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.worker.block.heartbeat.interval", "2000"})
    public void asyncCacheAfterSeek() throws Exception {
        String filename = this.mTestPath + "/file_" + 0x400001 + "_" + this.mWriteUnderStore.hashCode();
        AlluxioURI uri = new AlluxioURI(filename);
        for (ReadType readType : ReadType.values()) {
            this.mFileSystem.free(uri);
            CommonUtils.waitFor((String)"No in-Alluxio data left from previous iteration.", () -> {
                try {
                    URIStatus st = this.mFileSystem.getStatus(uri);
                    return st.getInAlluxioPercentage() == 0;
                }
                catch (Exception e) {
                    return false;
                }
            });
            FileInStream is = this.mFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(readType.toProto()).build());
            URIStatus status = this.mFileSystem.getStatus(uri);
            is.seek(status.getBlockSizeBytes() + 1L);
            is.read();
            status = this.mFileSystem.getStatus(uri);
            Assert.assertEquals((long)0L, (long)status.getInAlluxioPercentage());
            is.close();
            if (readType.isCache()) {
                CommonUtils.waitFor((String)"Second block to be cached.", () -> {
                    try {
                        URIStatus st = this.mFileSystem.getStatus(uri);
                        boolean achieved = true;
                        for (int i = 0; i < st.getFileBlockInfos().size(); ++i) {
                            FileBlockInfo info = (FileBlockInfo)st.getFileBlockInfos().get(i);
                            achieved = i == 1 ? achieved && !info.getBlockInfo().getLocations().isEmpty() : achieved && info.getBlockInfo().getLocations().isEmpty();
                        }
                        return achieved;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
                continue;
            }
            Thread.sleep(1000L);
            status = this.mFileSystem.getStatus(uri);
            Assert.assertEquals((long)0L, (long)status.getInAlluxioPercentage());
        }
    }

    @Test(timeout=10000L)
    public void asyncCacheFirstBlockPRead() throws Exception {
        String filename = this.mTestPath + "/file_" + 0x400001 + "_" + this.mWriteUnderStore.hashCode();
        AlluxioURI uri = new AlluxioURI(filename);
        for (ReadType readType : ReadType.values()) {
            this.mFileSystem.free(uri);
            CommonUtils.waitFor((String)"No in-Alluxio data left from previous iteration.", () -> {
                try {
                    URIStatus st = this.mFileSystem.getStatus(uri);
                    return st.getInAlluxioPercentage() == 0;
                }
                catch (Exception e) {
                    return false;
                }
            });
            FileInStream is = this.mFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(readType.toProto()).build());
            URIStatus status = this.mFileSystem.getStatus(uri);
            Assert.assertEquals((long)0L, (long)status.getInAlluxioPercentage());
            is.positionedRead(524288L, new byte[1], 0, 1);
            if (readType.isCache()) {
                CommonUtils.waitFor((String)"First block to be cached.", () -> {
                    try {
                        URIStatus st = this.mFileSystem.getStatus(uri);
                        boolean achieved = true;
                        for (int i = 0; i < st.getFileBlockInfos().size(); ++i) {
                            FileBlockInfo info = (FileBlockInfo)st.getFileBlockInfos().get(i);
                            achieved = i == 0 ? achieved && !info.getBlockInfo().getLocations().isEmpty() : achieved && info.getBlockInfo().getLocations().isEmpty();
                        }
                        return achieved;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
            } else {
                Thread.sleep(1000L);
                status = this.mFileSystem.getStatus(uri);
                Assert.assertEquals((long)0L, (long)status.getInAlluxioPercentage());
            }
            is.close();
        }
    }

    @Test
    public void syncCacheFirstBlock() throws Exception {
        String filename = this.mTestPath + "/file_" + 0x400001 + "_" + this.mWriteUnderStore.hashCode();
        AlluxioURI uri = new AlluxioURI(filename);
        FileInStream is = this.mFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE).build());
        URIStatus status = this.mFileSystem.getStatus(uri);
        byte[] data = new byte[(int)status.getBlockSizeBytes() + 1];
        is.read(data);
        status = this.mFileSystem.getStatus(uri);
        Assert.assertFalse((boolean)((FileBlockInfo)status.getFileBlockInfos().get(0)).getBlockInfo().getLocations().isEmpty());
        is.close();
    }
}

