/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.io.AbstractFileOutStreamIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.PMode;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.master.file.meta.PersistenceState;
import alluxio.security.authorization.Mode;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.PersistenceTestUtils;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.ModeUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jianjian", comment="job service is gone but check if any test cases can be recycled")
public final class FileOutStreamAsyncWriteJobIntegrationTest
extends AbstractFileOutStreamIntegrationTest {
    private static final int LEN = 1024;
    private static final FileSystemMasterCommonPOptions COMMON_OPTIONS = FileSystemMasterCommonPOptions.newBuilder().setTtl(12345678L).setTtlAction(TtlAction.DELETE).setSyncIntervalMs(-1L).build();
    private static final WaitForOptions WAIT_OPTIONS = WaitForOptions.defaults().setTimeoutMs(2000L).setInterval(10);
    private static final SetAttributePOptions TEST_OPTIONS = SetAttributePOptions.newBuilder().setMode(new Mode(365).toProto()).setCommonOptions(COMMON_OPTIONS).build();
    private AlluxioURI mUri = new AlluxioURI(PathUtils.uniqPath());

    private URIStatus createAsyncFile() throws Exception {
        this.writeIncreasingByteArrayToFile(this.mUri, 1024, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setRecursive(true).build());
        return this.mFileSystem.getStatus(this.mUri);
    }

    @Test
    public void simpleDurableWrite() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
    }

    @Test
    public void exists() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        Assert.assertTrue((boolean)this.mFileSystem.exists(this.mUri));
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        Assert.assertTrue((boolean)this.mFileSystem.exists(this.mUri));
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        Assert.assertTrue((boolean)this.mFileSystem.exists(this.mUri));
    }

    @Test
    public void deleteBeforeJobScheduled() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        this.mFileSystem.delete(this.mUri);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobComplete(this.mLocalAlluxioClusterResource, status.getFileId());
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
    }

    @Test
    public void deleteAfterJobScheduled() throws Exception {
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        this.mFileSystem.delete(this.mUri);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobComplete(this.mLocalAlluxioClusterResource, status.getFileId());
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
    }

    @Test
    public void deleteAfterPersist() throws Exception {
        URIStatus status = this.createAsyncFile();
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.mFileSystem.delete(this.mUri);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
    }

    @Test
    public void freeBeforeJobScheduled() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        this.createAsyncFile();
        try {
            this.mFileSystem.free(this.mUri);
            Assert.fail((String)"Expect free to fail before file is persisted");
        }
        catch (AlluxioException alluxioException) {
            // empty catch block
        }
        URIStatus status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)100L, (long)status.getInMemoryPercentage());
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)100L, (long)status.getInMemoryPercentage());
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
    }

    @Test
    public void freeAfterJobScheduled() throws Exception {
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        try {
            this.mFileSystem.free(this.mUri);
            Assert.fail((String)"Expect free to fail before file is persisted");
        }
        catch (AlluxioException alluxioException) {
            // empty catch block
        }
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)100L, (long)status.getInMemoryPercentage());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)100L, (long)status.getInMemoryPercentage());
    }

    @Test
    public void freeAfterFilePersisted() throws Exception {
        URIStatus status = this.createAsyncFile();
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.mFileSystem.free(this.mUri);
        CommonUtils.waitFor((String)"file is freed", () -> {
            try {
                return 0 == this.mFileSystem.getStatus(this.mUri).getInMemoryPercentage();
            }
            catch (Exception e) {
                return false;
            }
        }, (WaitForOptions)WAIT_OPTIONS);
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)0L, (long)status.getInMemoryPercentage());
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
    }

    @Test
    public void getStatus() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)status.getPersistenceState());
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)status.getPersistenceState());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        URIStatus statusAfter = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)statusAfter.getPersistenceState());
    }

    @Test
    public void openFile() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        this.checkFileInAlluxio(this.mUri, 1024);
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        this.checkFileInAlluxio(this.mUri, 1024);
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
    }

    @Test
    public void renameBeforeJobScheduled() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        AlluxioURI newUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri.getParent());
        this.mFileSystem.rename(this.mUri, newUri);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        this.checkFileNotInUnderStorage(this.mFileSystem.getStatus(newUri).getUfsPath());
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, newUri);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileInUnderStorage(newUri, 1024);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
    }

    @Test
    public void renameAfterJobScheduled() throws Exception {
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        AlluxioURI newUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri.getParent());
        this.mFileSystem.rename(this.mUri, newUri);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        this.checkFileNotInUnderStorage(this.mFileSystem.getStatus(newUri).getUfsPath());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, newUri);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileInUnderStorage(newUri, 1024);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
    }

    @Test
    public void renameAfterFilePersisted() throws Exception {
        URIStatus status = this.createAsyncFile();
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        AlluxioURI newUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri.getParent());
        this.mFileSystem.rename(this.mUri, newUri);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileInUnderStorage(newUri, 1024);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(status.getUfsPath());
    }

    @Test
    public void setAttributeBeforeJobScheduled() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        this.mFileSystem.setAttribute(this.mUri, TEST_OPTIONS);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        Assume.assumeFalse((boolean)ufs.isObjectStorage());
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)ufs.getFileStatus(ufsPath).getMode());
    }

    @Test
    public void setAttributeAfterJobScheduled() throws Exception {
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        this.mFileSystem.setAttribute(this.mUri, TEST_OPTIONS);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileNotInUnderStorage(status.getUfsPath());
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
        status = this.mFileSystem.getStatus(this.mUri);
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        Assume.assumeFalse((boolean)ufs.isObjectStorage());
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)ufs.getFileStatus(ufsPath).getMode());
    }

    @Test
    public void setAttributeAfterFilePersisted() throws Exception {
        this.createAsyncFile();
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, this.mUri);
        this.mFileSystem.setAttribute(this.mUri, TEST_OPTIONS);
        this.checkFileInAlluxio(this.mUri, 1024);
        this.checkFileInUnderStorage(this.mUri, 1024);
        URIStatus status = this.mFileSystem.getStatus(this.mUri);
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        Assume.assumeFalse((boolean)ufs.isObjectStorage());
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)ufs.getFileStatus(ufsPath).getMode());
    }

    @Test
    public void renameScheduleRename() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        String ufsPath = status.getUfsPath();
        AlluxioURI newUri1 = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri1.getParent());
        this.mFileSystem.rename(this.mUri, newUri1);
        String ufsPath1 = this.mFileSystem.getStatus(newUri1).getUfsPath();
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri1, 1024);
        this.checkFileNotInUnderStorage(ufsPath1);
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        AlluxioURI newUri2 = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.rename(newUri1, newUri2);
        String ufsPath2 = this.mFileSystem.getStatus(newUri2).getUfsPath();
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileNotInAlluxio(newUri1);
        this.checkFileNotInUnderStorage(ufsPath1);
        this.checkFileInAlluxio(newUri2, 1024);
        this.checkFileNotInUnderStorage(ufsPath2);
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, newUri2);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileNotInAlluxio(newUri1);
        this.checkFileNotInUnderStorage(ufsPath1);
        this.checkFileInAlluxio(newUri2, 1024);
        this.checkFileInUnderStorage(newUri2, 1024);
    }

    @Test
    public void renameScheduleFree() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        String ufsPath = status.getUfsPath();
        AlluxioURI newUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri.getParent());
        this.mFileSystem.rename(this.mUri, newUri);
        String newUfsPath = this.mFileSystem.getStatus(newUri).getUfsPath();
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInUnderStorage(newUfsPath);
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        try {
            this.mFileSystem.free(newUri);
            Assert.fail((String)"Expect free to fail before file is persisted");
        }
        catch (AlluxioException alluxioException) {
            // empty catch block
        }
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInUnderStorage(newUfsPath);
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(newUri).getInMemoryPercentage());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, newUri);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileInUnderStorage(newUri, 1024);
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus(newUri).getInMemoryPercentage());
    }

    @Test
    public void renameScheduleSetAttribute() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        AlluxioURI newUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri.getParent());
        this.mFileSystem.rename(this.mUri, newUri);
        String newUfsPath = this.mFileSystem.getStatus(newUri).getUfsPath();
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInUnderStorage(newUfsPath);
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        this.mFileSystem.setAttribute(newUri, TEST_OPTIONS);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInUnderStorage(newUfsPath);
        status = this.mFileSystem.getStatus(newUri);
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, newUri);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileInUnderStorage(newUri, 1024);
        status = this.mFileSystem.getStatus(newUri);
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)status.getMode());
        Assert.assertEquals((long)COMMON_OPTIONS.getTtl(), (long)status.getTtl());
        Assert.assertEquals((Object)COMMON_OPTIONS.getTtlAction(), (Object)status.getTtlAction());
        Assume.assumeFalse((boolean)ufs.isObjectStorage());
        Assert.assertEquals((long)ModeUtils.protoToShort((PMode)TEST_OPTIONS.getMode()), (long)ufs.getFileStatus(newUfsPath).getMode());
    }

    @Test
    public void renameScheduleDelete() throws Exception {
        PersistenceTestUtils.pauseScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.pauseChecker(this.mLocalAlluxioClusterResource);
        URIStatus status = this.createAsyncFile();
        String ufsPath = status.getUfsPath();
        AlluxioURI newUri = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(newUri.getParent());
        this.mFileSystem.rename(this.mUri, newUri);
        String newUfsPath = this.mFileSystem.getStatus(newUri).getUfsPath();
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileInAlluxio(newUri, 1024);
        this.checkFileNotInUnderStorage(newUfsPath);
        PersistenceTestUtils.resumeScheduler(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobScheduled(this.mLocalAlluxioClusterResource, status.getFileId());
        this.mFileSystem.delete(newUri);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(newUfsPath);
        PersistenceTestUtils.resumeChecker(this.mLocalAlluxioClusterResource);
        PersistenceTestUtils.waitForJobComplete(this.mLocalAlluxioClusterResource, status.getFileId());
        this.checkFileNotInAlluxio(this.mUri);
        this.checkFileNotInUnderStorage(ufsPath);
        this.checkFileNotInAlluxio(newUri);
        this.checkFileNotInUnderStorage(newUfsPath);
    }

    private void checkFileNotInAlluxio(AlluxioURI filePath) throws Exception {
        Assert.assertFalse((boolean)this.mFileSystem.exists(filePath));
    }

    private void checkFileNotInUnderStorage(String ufsPath) throws Exception {
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        Assert.assertFalse((boolean)ufs.exists(ufsPath));
    }
}

