/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.io.AbstractFileOutStreamIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.file.FileSystemMaster;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.WorkerInfo;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix the tests")
public final class FileOutStreamIntegrationTest
extends AbstractFileOutStreamIntegrationTest {
    @Parameterized.Parameter
    public WriteType mWriteType;

    @Parameterized.Parameters
    public static Object[] dataFileInStreamIntegrationTest() {
        return new Object[]{WriteType.ASYNC_THROUGH, WriteType.CACHE_THROUGH, WriteType.MUST_CACHE, WriteType.THROUGH};
    }

    @Test
    public void writeBytes() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int len = 0; len <= 255; len += 32) {
            CreateFilePOptions op = CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build();
            AlluxioURI filePath = new AlluxioURI(PathUtils.concatPath((Object)uniqPath, (Object)("file_" + len + "_" + this.mWriteType)));
            this.writeIncreasingBytesToFile(filePath, len, op);
            if (this.mWriteType.getAlluxioStorageType().isStore()) {
                this.checkFileInAlluxio(filePath, len);
            }
            if (!this.mWriteType.getUnderStorageType().isSyncPersist()) continue;
            this.checkFileInUnderStorage(filePath, len);
        }
    }

    @Test
    public void writeInNonExistDirectory() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        CreateFilePOptions op = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build();
        AlluxioURI filePath = new AlluxioURI(PathUtils.concatPath((Object)uniqPath, (Object)("file_0_" + this.mWriteType)));
        AlluxioURI parentPath = new AlluxioURI(uniqPath);
        this.mFileSystem.createDirectory(parentPath, CreateDirectoryPOptions.newBuilder().setRecursive(true).setWriteType(WritePType.CACHE_THROUGH).build());
        URIStatus status = this.mFileSystem.getStatus(parentPath);
        String checkpointPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)checkpointPath, (AlluxioConfiguration)Configuration.global());
        ufs.deleteDirectory(checkpointPath);
        this.writeIncreasingBytesToFile(filePath, 0, op);
        this.checkFileInAlluxio(filePath, 0);
        this.checkFileInUnderStorage(filePath, 0);
    }

    @Test
    public void writeByteArray() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int len = 0; len <= 255; len += 32) {
            CreateFilePOptions op = CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build();
            AlluxioURI filePath = new AlluxioURI(PathUtils.concatPath((Object)uniqPath, (Object)("file_" + len + "_" + this.mWriteType)));
            this.writeIncreasingByteArrayToFile(filePath, len, op);
            if (this.mWriteType.getAlluxioStorageType().isStore()) {
                this.checkFileInAlluxio(filePath, len);
            }
            if (!this.mWriteType.getUnderStorageType().isSyncPersist()) continue;
            this.checkFileInUnderStorage(filePath, len);
        }
    }

    @Test
    public void writeTwoByteArrays() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int len = 0; len <= 255; len += 32) {
            CreateFilePOptions op = CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build();
            AlluxioURI filePath = new AlluxioURI(PathUtils.concatPath((Object)uniqPath, (Object)("file_" + len + "_" + this.mWriteType)));
            this.writeTwoIncreasingByteArraysToFile(filePath, len, op);
            if (this.mWriteType.getAlluxioStorageType().isStore()) {
                this.checkFileInAlluxio(filePath, len);
            }
            if (!this.mWriteType.getUnderStorageType().isSyncPersist()) continue;
            this.checkFileInUnderStorage(filePath, len);
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.block.write.location.policy.class", "alluxio.client.block.policy.LocalFirstPolicy"})
    public void writeSpecifyLocal() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        int length = 2;
        CreateFilePOptions op = CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build();
        try (FileOutStream os = this.mFileSystem.createFile(filePath, op);){
            os.write(0);
            os.write(1);
        }
        if (this.mWriteType.getAlluxioStorageType().isStore()) {
            this.checkFileInAlluxio(filePath, 2);
        }
        if (this.mWriteType.getUnderStorageType().isSyncPersist()) {
            this.checkFileInUnderStorage(filePath, 2);
        }
    }

    @Test
    public void longWrite() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        int length = 2;
        try (FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build());){
            os.write(0);
            Thread.sleep(2000L);
            os.write(1);
        }
        if (this.mWriteType.getAlluxioStorageType().isStore()) {
            this.checkFileInAlluxio(filePath, 2);
        }
        if (this.mWriteType.getUnderStorageType().isSyncPersist()) {
            this.checkFileInUnderStorage(filePath, 2);
        }
    }

    @Test
    public void outOfOrderWrite() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        int length = 75;
        try (FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build());){
            os.write(0);
            os.write(BufferUtils.getIncreasingByteArray((int)1, (int)length));
        }
        if (this.mWriteType.getAlluxioStorageType().isStore()) {
            this.checkFileInAlluxio(filePath, length + 1);
        }
        if (this.mWriteType.getUnderStorageType().isSyncPersist()) {
            this.checkFileInUnderStorage(filePath, length + 1);
        }
    }

    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.lost.worker.file.detection.interval", "250ms", "alluxio.worker.block.heartbeat.interval", "250ms"})
    @Test
    public void cancelWrite() throws Exception {
        AlluxioURI path = new AlluxioURI(PathUtils.uniqPath());
        try (FileOutStream os = this.mFileSystem.createFile(path, CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build());){
            os.write(BufferUtils.getIncreasingByteArray((int)0, (int)3001));
            os.cancel();
        }
        long gracePeriod = Configuration.getMs((PropertyKey)PropertyKey.WORKER_BLOCK_HEARTBEAT_INTERVAL_MS) * 2L;
        CommonUtils.sleepMs((long)gracePeriod);
        List workers = ((FileSystemMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class)).getFileSystemMasterView().getWorkerInfoList();
        for (WorkerInfo worker : workers) {
            Assert.assertEquals((long)0L, (long)worker.getUsedBytes());
        }
    }

    @Test
    public void getStatusBeforeClose() throws Exception {
        int i;
        AlluxioURI path = new AlluxioURI(PathUtils.uniqPath());
        try (FileOutStream os = this.mFileSystem.createFile(path, CreateFilePOptions.newBuilder().setWriteType(this.mWriteType.toProto()).setRecursive(true).build());){
            for (i = 0; i < 3; ++i) {
                os.write(BufferUtils.getIncreasingByteArray((int)(i * 1000), (int)1000));
                URIStatus status = this.mFileSystem.getStatus(path);
                if (this.mWriteType.isThrough()) continue;
                Assert.assertEquals((long)(i + 1), (long)status.getBlockIds().size());
            }
            os.write(BufferUtils.getIncreasingByteArray((int)3000, (int)1));
        }
        URIStatus finalStatus = this.mFileSystem.getStatus(path);
        Assert.assertEquals((long)4L, (long)finalStatus.getBlockIds().size());
        List fileBlocks = finalStatus.getFileBlockInfos();
        Assert.assertEquals((long)4L, (long)fileBlocks.size());
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)1000L, (long)((FileBlockInfo)fileBlocks.get(i)).getBlockInfo().getLength());
        }
        Assert.assertEquals((long)1L, (long)((FileBlockInfo)fileBlocks.get(3)).getBlockInfo().getLength());
    }
}

