/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora;

import alluxio.client.file.options.FileSystemOptions;
import alluxio.client.fuse.dora.AbstractFuseDoraTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.AlluxioJniFuseFileSystem;
import alluxio.fuse.options.FuseOptions;
import alluxio.jnifuse.struct.FileStat;
import alluxio.util.io.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;

public abstract class AbstractFuseFileSystemTest
extends AbstractFuseDoraTest {
    protected AlluxioJniFuseFileSystem mFuseFs;
    protected AlluxioFuseUtils.CloseableFuseFileInfo mFileInfo;
    protected FileStat mFileStat;

    @Override
    public void beforeActions() {
        FileSystemOptions fileSystemOptions = FileSystemOptions.Builder.fromConf((AlluxioConfiguration)this.mContext.getClusterConf()).setUfsFileSystemOptions(this.mUfsOptions).build();
        this.mFuseFs = new AlluxioJniFuseFileSystem(this.mContext, this.mFileSystem, FuseOptions.create((AlluxioConfiguration)Configuration.global(), (FileSystemOptions)fileSystemOptions, (boolean)false));
        this.mFileStat = FileStat.of((ByteBuffer)ByteBuffer.allocateDirect(256));
        this.mFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();
    }

    @Override
    public void afterActions() throws IOException {
        BufferUtils.cleanDirectBuffer((ByteBuffer)this.mFileStat.getBuffer());
        this.mFileInfo.close();
    }

    protected void createEmptyFile(String path) {
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
    }

    protected void createFile(String path, int size) {
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)size);
        Assert.assertEquals((long)size, (long)this.mFuseFs.write(path, buffer, (long)size, 0L, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
    }
}

