/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora;

import alluxio.client.fuse.dora.AbstractFuseFileSystemTest;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.jnifuse.ErrorCodes;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Test;

public class FuseFileSystemDataTest
extends AbstractFuseFileSystemTest {
    @Test
    public void createWithLengthLimit() {
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)(-ErrorCodes.ENAMETOOLONG()), (long)this.mFuseFs.create(EXCEED_LENGTH_PATH_NAME, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
    }

    @Test
    public void createCloseDifferentThread() throws InterruptedException, ExecutionException {
        String path = "/createCloseDifferentThread";
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
        Callable<Integer> releaseTask = () -> this.mFuseFs.release(path, this.mFileInfo.get());
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor();
        Future<Integer> releaseResult = threadExecutor.submit(releaseTask);
        Assert.assertEquals((long)0L, (long)releaseResult.get().intValue());
        this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open(path, this.mFileInfo.get()));
        releaseResult = threadExecutor.submit(releaseTask);
        Assert.assertEquals((long)0L, (long)releaseResult.get().intValue());
    }

    @Test
    public void writeEmptyNonExisting() {
        String path = "/writeEmptyNonExisting";
        this.createOpenTest(createOrOpenOperation -> {
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
            Assert.assertEquals((long)0L, (long)this.mFileStat.st_size.longValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, false, path);
    }

    @Test
    public void readWriteEmptyNonExisting() {
        String path = "/readWriteEmptyNonExisting";
        this.mFileInfo.get().flags.set(OpenFlags.O_RDWR.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open(path, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(path, this.mFileStat));
    }

    @Test
    public void overwriteEmpty() {
        String path = "/overwriteEmpty";
        this.createOpenTest(createOrOpenOperation -> {
            this.createEmptyFile(path);
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
            Assert.assertEquals((long)64L, (long)this.mFileStat.st_size.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, true, path);
    }

    @Test
    public void failedToOverwrite() {
        String path = "/failedToOverwrite";
        this.createOpenTest(createOrOpenOperation -> {
            this.createFile(path, 64);
            this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            Assert.assertEquals((long)(-ErrorCodes.EEXIST()), (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, true, path);
    }

    @Test
    public void overwriteTruncateFlag() {
        String path = "/overwriteTruncateFlag";
        this.createOpenTest(createOrOpenOperation -> {
            this.createFile(path, 64);
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(OpenFlags.O_TRUNC.intValue())).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, true, path);
    }

    @Test
    public void overwriteTruncateZero() {
        String path = "/overwriteTruncateZero";
        this.createOpenTest(createOrOpenOperation -> {
            this.createFile(path, 64);
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)0L, (long)this.mFuseFs.truncate(path, 0L));
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
            Assert.assertEquals((long)128L, (long)this.mFuseFs.write(path, buffer, 128L, 0L, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
            Assert.assertEquals((long)128L, (long)this.mFileStat.st_size.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, true, path);
    }

    @Test
    public void truncateSame() {
        String path = "/truncateSame";
        this.createOpenTest(createOrOpenOperation -> {
            this.createFile(path, 64);
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((long)0L, (long)this.mFuseFs.truncate(path, 64L));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
            Assert.assertEquals((long)64L, (long)this.mFileStat.st_size.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, true, path);
    }

    @Test
    public void truncateMiddle() {
        String path = "/truncateMiddle";
        this.createOpenTest(createOrOpenOperation -> {
            this.createFile(path, 64);
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
                Assert.assertEquals((long)(-ErrorCodes.EOPNOTSUPP()), (long)this.mFuseFs.truncate(path, 32L));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.mFuseFs.release(path, this.mFileInfo.get());
                this.mFuseFs.unlink(path);
            }
        }, true, path);
    }

    @Test
    public void overwriteTruncateFuture() {
        String path = "/overwriteTruncateFuture";
        this.createOpenTest(createOrOpenOperation -> {
            this.createFile(path, 64);
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
                Assert.assertEquals((long)(-ErrorCodes.EOPNOTSUPP()), (long)this.mFuseFs.truncate(path, 128L));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.mFuseFs.release(path, this.mFileInfo.get());
                this.mFuseFs.unlink(path);
            }
        }, true, path);
    }

    @Test
    public void writeTruncateFuture() {
        String path = "/writeTruncateFuture";
        this.createOpenTest(createOrOpenOperation -> {
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
                Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
                Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
                Assert.assertEquals((long)64L, (long)this.mFileStat.st_size.intValue());
                Assert.assertEquals((long)0L, (long)this.mFuseFs.truncate(path, 128L));
                Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
                Assert.assertEquals((long)128L, (long)this.mFileStat.st_size.intValue());
                buffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)128);
                Assert.assertEquals((long)128L, (long)this.mFuseFs.write(path, buffer, 128L, 64L, this.mFileInfo.get()));
                Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
                Assert.assertEquals((long)192L, (long)this.mFileStat.st_size.intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.mFuseFs.release(path, this.mFileInfo.get());
                this.mFuseFs.unlink(path);
            }
        }, true, path);
    }

    @Test
    public void sequentialWrite() {
        String path = "/sequentialWrite";
        this.createOpenTest(createOrOpenOperation -> {
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
                Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
                Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
                Assert.assertEquals((long)64L, (long)this.mFileStat.st_size.intValue());
                buffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)64);
                Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 64L, this.mFileInfo.get()));
                Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
                Assert.assertEquals((long)128L, (long)this.mFileStat.st_size.intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.mFuseFs.release(path, this.mFileInfo.get());
                this.mFuseFs.unlink(path);
            }
        }, true, path);
    }

    @Test
    public void randomWrite() {
        String path = "/randomWrite";
        this.createOpenTest(createOrOpenOperation -> {
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
                Assert.assertEquals((long)(-ErrorCodes.EOPNOTSUPP()), (long)this.mFuseFs.write(path, buffer, 64L, 15L, this.mFileInfo.get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.mFuseFs.release(path, this.mFileInfo.get());
                this.mFuseFs.unlink(path);
            }
        }, true, path);
    }

    @Test
    public void openReadEmpty() {
        String path = "/openReadEmpty";
        this.createEmptyFile(path);
        this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open(path, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
    }

    @Test
    public void openReadNonExisting() {
        String path = "/openReadNonExisting";
        this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.open(path, this.mFileInfo.get()));
    }

    @Test
    public void openWithLengthLimit() {
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)(-ErrorCodes.ENAMETOOLONG()), (long)this.mFuseFs.create(EXCEED_LENGTH_PATH_NAME, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
    }

    @Test
    public void readTimeoutWhenIncomplete() {
        String path = "/readTimeoutWhenIncomplete";
        this.createOpenTest(createOrOpenOperation -> {
            try {
                Assert.assertEquals((long)0L, (long)((Integer)createOrOpenOperation.apply(0)).intValue());
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
                Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
                this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
                Assert.assertEquals((long)(-ErrorCodes.ETIME()), (long)this.mFuseFs.open(path, this.mFileInfo.get()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
            }
            Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        }, true, path);
    }

    @Test
    public void writeThenRead() {
        String path = "/writeThenRead";
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
        Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
        this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open(path, this.mFileInfo.get()));
        buffer.flip();
        Assert.assertEquals((long)64L, (long)this.mFuseFs.read(path, buffer, 64L, 0L, this.mFileInfo.get()));
        BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)buffer);
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
    }

    @Test
    public void readingWhenWriting() {
        String path = "/readingWhenWriting";
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
        try {
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
            this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
            Assert.assertEquals((long)(-ErrorCodes.ETIME()), (long)this.mFuseFs.open(path, this.mFileInfo.get()));
        }
        finally {
            this.mFuseFs.release(path, this.mFileInfo.get());
        }
    }

    @Test
    public void getAttrWhenWriting() {
        String path = "/getAttrWhenWriting";
        this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get()));
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
        Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
        Assert.assertEquals((long)64L, (long)this.mFileStat.st_size.intValue());
        Assert.assertEquals((long)AlluxioFuseUtils.getSystemUid(), (long)this.mFileStat.st_uid.get());
        Assert.assertEquals((long)AlluxioFuseUtils.getSystemGid(), (long)this.mFileStat.st_gid.get());
        Assert.assertEquals((long)AlluxioFuseUtils.getSystemGid(), (long)this.mFileStat.st_gid.get());
        Assert.assertTrue(((this.mFileStat.st_mode.intValue() & 0x8000) != 0 ? 1 : 0) != 0);
        buffer.flip();
        Assert.assertEquals((long)64L, (long)this.mFuseFs.write(path, buffer, 64L, 0L, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
        Assert.assertEquals((long)128L, (long)this.mFileStat.st_size.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release(path, this.mFileInfo.get()));
        Assert.assertEquals((long)128L, (long)this.mFileStat.st_size.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
    }

    private void createOpenTest(Consumer<Function<Integer, Integer>> testCase, boolean testOpenReadWrite, String path) {
        ArrayList<Function<Integer, Integer>> operations = new ArrayList<Function<Integer, Integer>>();
        operations.add(extraFlag -> {
            this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue() | extraFlag);
            return this.mFuseFs.open(path, this.mFileInfo.get());
        });
        operations.add(extraFlag -> {
            this.mFileInfo.get().flags.set(OpenFlags.O_WRONLY.intValue() | extraFlag);
            return this.mFuseFs.create(path, (long)DEFAULT_MODE.toShort(), this.mFileInfo.get());
        });
        if (testOpenReadWrite) {
            operations.add(extraFlag -> {
                this.mFileInfo.get().flags.set(OpenFlags.O_RDWR.intValue() | extraFlag);
                return this.mFuseFs.open(path, this.mFileInfo.get());
            });
        }
        for (Function function : operations) {
            testCase.accept(function);
        }
    }
}

