/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora;

import alluxio.client.fuse.dora.AbstractFuseFileSystemTest;
import alluxio.jnifuse.ErrorCodes;
import alluxio.jnifuse.struct.FileStat;
import alluxio.jnifuse.struct.Statvfs;
import alluxio.security.authorization.Mode;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class FuseFileSystemMetadataTest
extends AbstractFuseFileSystemTest {
    @Test
    public void createDeleteFile() {
        String path = "/createDeleteFile";
        this.createEmptyFile(path);
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(path, this.mFileStat));
    }

    @Test
    public void getAttrNonExisting() {
        String path = "/getAttrNonExisting";
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(path, this.mFileStat));
    }

    @Test
    public void createDirectory() {
        String path = "/createDirectory";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
    }

    @Test
    public void createDirectoryWithLengthLimit() {
        Assert.assertEquals((long)(-ErrorCodes.ENAMETOOLONG()), (long)this.mFuseFs.mkdir(EXCEED_LENGTH_PATH_NAME, (long)DEFAULT_MODE.toShort()));
    }

    @Test
    public void createDeleteDirectory() {
        String path = "/createDeleteDirectory";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(path, this.mFileStat));
    }

    @Test
    public void createDeleteNonEmptyDirectory() {
        String path = "/createDeleteNonEmptyDirectory";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
        this.createEmptyFile(path + "/file");
        Assert.assertEquals((long)0L, (long)this.mFuseFs.unlink(path));
    }

    @Test
    public void rmdir() {
        String path = "/rmdir";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.rmdir(path));
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(path, this.mFileStat));
    }

    @Test
    public void rmdirNotEmpty() {
        String path = "/rmdirNotEmpty";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
        this.createEmptyFile(path + "/file");
        Assert.assertEquals((long)0L, (long)this.mFuseFs.rmdir(path));
    }

    @Test
    public void renameFile() {
        String src = "/src_renameFile";
        String dst = "/dst_renameFile";
        this.createEmptyFile(src);
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(src, this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.rename(src, dst, 0));
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(src, this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(dst, this.mFileStat));
    }

    @Test
    public void renameDirectory() {
        String src = "/src_renameDirectory";
        String dst = "/dst_renameDirectory";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(src, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(src, this.mFileStat));
        this.mFuseFs.rename(src, dst, 0);
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr(src, this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(dst, this.mFileStat));
    }

    @Test
    public void renameSrcNotExist() {
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.rename("/src_renameSrcNotExist", "/dst_renameSrcNotExist", 0));
    }

    @Test
    public void renameDstFileExist() {
        String src = "/src_renameDstFileExist";
        String dst = "/dst_renameDstFileExist";
        this.createEmptyFile(src);
        this.createEmptyFile(dst);
        Assert.assertEquals((long)0L, (long)this.mFuseFs.rename(src, dst, 0));
    }

    @Test
    public void renameDstDirectoryExist() {
        String src = "/src_renameDstDirectoryExist";
        String dst = "/dst_renameDstDirectoryExist";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(src, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(dst, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.rename(src, dst, 0));
    }

    @Test
    public void renameWithLengthLimit() {
        String src = "/src_renameWithLengthLimit";
        this.createEmptyFile(src);
        Assert.assertEquals((long)(-ErrorCodes.ENAMETOOLONG()), (long)this.mFuseFs.rename(src, EXCEED_LENGTH_PATH_NAME, 0));
    }

    @Test
    public void statfs() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        try {
            buffer.clear();
            Statvfs stbuf = Statvfs.of((ByteBuffer)buffer);
            Assert.assertEquals((long)0L, (long)this.mFuseFs.statfs("/", stbuf));
        }
        finally {
            BufferUtils.cleanDirectBuffer((ByteBuffer)buffer);
        }
    }

    @Test
    public void overwriteExistingDirectoryLocalS3Ufs() {
        String path = "/overwriteExistingDirectoryLocalS3Ufs";
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.mkdir(path, (long)DEFAULT_MODE.toShort()));
    }

    @Test
    public void chmod() {
        String path = "/chmod";
        this.createEmptyFile(path);
        Mode mode = new Mode(Mode.Bits.EXECUTE, Mode.Bits.WRITE, Mode.Bits.READ);
        this.mFuseFs.chmod(path, (long)mode.toShort());
        FileStat stat = FileStat.of((ByteBuffer)ByteBuffer.allocateDirect(256));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr(path, stat));
        Mode res = new Mode(stat.st_mode.shortValue());
        Assert.assertEquals((Object)mode.getOwnerBits(), (Object)res.getOwnerBits());
        Assert.assertEquals((Object)mode.getGroupBits(), (Object)res.getGroupBits());
        Assert.assertEquals((Object)mode.getOtherBits(), (Object)res.getOtherBits());
    }
}

