/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.readonly;

import alluxio.client.file.options.FileSystemOptions;
import alluxio.client.fuse.dora.readonly.AbstractFuseDoraReadOnlyTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.AlluxioJniFuseFileSystem;
import alluxio.fuse.options.FuseOptions;
import alluxio.jnifuse.struct.FileStat;
import alluxio.util.io.BufferUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractFuseFileSystemTest
extends AbstractFuseDoraReadOnlyTest {
    protected AlluxioJniFuseFileSystem mFuseFs;
    protected AlluxioFuseUtils.CloseableFuseFileInfo mFileInfo;
    protected FileStat mFileStat;

    @Override
    public void beforeActions() {
        FileSystemOptions fileSystemOptions = FileSystemOptions.Builder.fromConf((AlluxioConfiguration)this.mContext.getClusterConf()).setUfsFileSystemOptions(this.mUfsOptions).build();
        this.mFuseFs = new AlluxioJniFuseFileSystem(this.mContext, this.mFileSystem, FuseOptions.create((AlluxioConfiguration)Configuration.global(), (FileSystemOptions)fileSystemOptions, (boolean)false));
        this.mFileStat = FileStat.of((ByteBuffer)ByteBuffer.allocateDirect(256));
        this.mFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();
    }

    @Override
    public void afterActions() throws IOException {
        BufferUtils.cleanDirectBuffer((ByteBuffer)this.mFileStat.getBuffer());
        this.mFileInfo.close();
    }

    protected void createEmptyFile(String path) throws IOException {
        new FileOutputStream(path).close();
    }

    protected void createFile(String path, int size) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(path);){
            stream.write(BufferUtils.getIncreasingByteArray((int)size));
        }
    }
}

