/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.stream;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.client.fuse.dora.stream.AbstractStreamTest;
import alluxio.exception.runtime.AlreadyExistsRuntimeException;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.file.FuseFileStream;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class OutStreamTest
extends AbstractStreamTest {
    @Test
    public void createEmpty() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.createStream(alluxioURI, false).close();
        URIStatus status = this.mFileSystem.getStatus(alluxioURI);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertEquals((long)0L, (long)status.getLength());
    }

    @Test(expected=AlreadyExistsRuntimeException.class)
    public void createExisting() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)97);
            outStream.write(buffer, 1L, 0L);
        }
    }

    @Ignore(value="truncate is unsupported as delete operation isn't implemented")
    public void createTruncateFlag() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        int newLen = 30;
        int newStartValue = 15;
        try (FuseFileStream outStream = this.createStream(alluxioURI, true);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)newStartValue, (int)newLen);
            outStream.write(buffer, (long)newLen, 0L);
        }
        this.checkFile(alluxioURI, newLen, newStartValue);
    }

    @Ignore(value="truncate is unsupported as delete operation isn't implemented")
    public void createTruncateZeroWrite() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        int newLen = 30;
        int newStartValue = 15;
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            outStream.truncate(0L);
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)newStartValue, (int)newLen);
            outStream.write(buffer, (long)newLen, 0L);
        }
        this.checkFile(alluxioURI, newLen, newStartValue);
    }

    @Test(expected=FailedPreconditionRuntimeException.class)
    public void read() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            outStream.read(buffer, 64L, 0L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void randomWrite() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 15L);
        }
    }

    @Test
    public void sequentialWriteAndgetFileLength() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            buffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)64);
            outStream.write(buffer, 64L, 64L);
            Assert.assertEquals((long)128L, (long)outStream.getFileStatus().getFileLength());
        }
        this.checkFile(alluxioURI, 128, 0);
    }

    @Ignore(value="truncate is unsupported as delete operation isn't implemented")
    public void truncateZeroOrDefaultFileLen() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(0L);
            Assert.assertEquals((long)0L, (long)outStream.getFileStatus().getFileLength());
            buffer = BufferUtils.getIncreasingByteBuffer((int)128);
            outStream.write(buffer, 128L, 0L);
            Assert.assertEquals((long)128L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(128L);
            Assert.assertEquals((long)128L, (long)outStream.getFileStatus().getFileLength());
        }
        this.checkFile(alluxioURI, 128, 0);
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void truncateMiddle() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(32L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void openExistingTruncateFuture() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            outStream.truncate(128L);
        }
    }

    @Test
    public void truncateBiggerThanBytesWritten() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            Assert.assertEquals((long)0L, (long)outStream.getFileStatus().getFileLength());
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(128L);
            Assert.assertEquals((long)128L, (long)outStream.getFileStatus().getFileLength());
            buffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)128);
            outStream.write(buffer, 128L, 64L);
            Assert.assertEquals((long)192L, (long)outStream.getFileStatus().getFileLength());
        }
        this.checkFile(alluxioURI, 192, 0);
    }

    @Test
    public void truncateFileLen() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            Assert.assertEquals((long)0L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(64L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
        }
        Assert.assertEquals((long)64L, (long)this.mFileSystem.getStatus(alluxioURI).getLength());
    }

    @Test
    public void truncateBiggerThanFileLen() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            Assert.assertEquals((long)0L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(128L);
            Assert.assertEquals((long)128L, (long)outStream.getFileStatus().getFileLength());
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)128L, (long)outStream.getFileStatus().getFileLength());
        }
        Assert.assertEquals((long)128L, (long)this.mFileSystem.getStatus(alluxioURI).getLength());
    }

    @Test
    public void truncateMultiple() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileAlluxioUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            Assert.assertEquals((long)0L, (long)outStream.getFileStatus().getFileLength());
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(192L);
            Assert.assertEquals((long)192L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(64L);
            Assert.assertEquals((long)64L, (long)outStream.getFileStatus().getFileLength());
            outStream.truncate(0L);
            Assert.assertEquals((long)0L, (long)outStream.getFileStatus().getFileLength());
        }
        Assert.assertEquals((long)0L, (long)this.mFileSystem.getStatus(alluxioURI).getLength());
    }

    protected FuseFileStream createStream(AlluxioURI uri, boolean truncate) {
        int flags = OpenFlags.O_WRONLY.intValue();
        if (truncate) {
            flags |= OpenFlags.O_TRUNC.intValue();
        }
        return this.mStreamFactory.create(uri, flags, (long)DEFAULT_MODE.toShort());
    }
}

