/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopClientTestUtils;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.security.authentication.AuthType;
import alluxio.security.authorization.Mode;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="pending on perm features in dora")
public final class FileSystemAclIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.SIMPLE).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, true).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).build();
    private static String sUfsRoot;
    private static UnderFileSystem sUfs;
    private static org.apache.hadoop.fs.FileSystem sTFS;

    private static void create(org.apache.hadoop.fs.FileSystem fs, Path path) throws IOException {
        FSDataOutputStream o = fs.create(path);
        o.writeBytes("Test Bytes");
        o.close();
    }

    public static void cleanup(org.apache.hadoop.fs.FileSystem fs) throws IOException {
        FileStatus[] statuses;
        for (FileStatus f : statuses = fs.listStatus(new Path("/"))) {
            fs.delete(f.getPath(), true);
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set("fs.alluxio.impl", FileSystem.class.getName());
        conf = HadoopConfigurationUtils.mergeAlluxioConfiguration((org.apache.hadoop.conf.Configuration)conf, (AlluxioConfiguration)Configuration.global());
        URI uri = URI.create(sLocalAlluxioClusterResource.get().getMasterURI());
        sTFS = org.apache.hadoop.fs.FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)HadoopConfigurationUtils.mergeAlluxioConfiguration((org.apache.hadoop.conf.Configuration)conf, (AlluxioConfiguration)Configuration.global()));
        sUfsRoot = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        sUfs = UnderFileSystem.Factory.createForRoot((AlluxioConfiguration)Configuration.global());
    }

    @After
    public void cleanupTFS() throws Exception {
        FileSystemAclIntegrationTest.cleanup(sTFS);
    }

    @Test
    public void createFileWithPermission() throws Exception {
        ArrayList permissionValues = Lists.newArrayList((Object[])new Integer[]{73, 146, 219, 292, 365, 438, 511, 493, 475, 420, 347, 329});
        Iterator iterator = permissionValues.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            Path file = new Path("/createfile" + value);
            FsPermission permission = FsPermission.createImmutable((short)((short)value));
            FSDataOutputStream o = sTFS.create(file, permission, false, 10, (short)1, 512L, null);
            o.writeBytes("Test Bytes");
            o.close();
            FileStatus fs = sTFS.getFileStatus(file);
            Assert.assertEquals((Object)permission, (Object)fs.getPermission());
        }
    }

    @Test
    @Ignore
    public void mkdirsWithPermission() throws Exception {
        ArrayList permissionValues = Lists.newArrayList((Object[])new Integer[]{73, 146, 219, 292, 365, 438, 511, 493, 475, 420, 347, 329});
        Iterator iterator = permissionValues.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            Path dir = new Path("/createDir" + value);
            FsPermission permission = FsPermission.createImmutable((short)((short)value));
            sTFS.mkdirs(dir, permission);
            FileStatus fs = sTFS.getFileStatus(dir);
            Assert.assertEquals((Object)permission, (Object)fs.getPermission());
        }
    }

    @Test
    @Ignore
    public void chmod() throws Exception {
        Path fileA = new Path("/chmodfileA");
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        FileStatus fs = sTFS.getFileStatus(fileA);
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)));
        if (UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs) && HadoopClientTestUtils.isHadoop1x()) {
            Assert.assertEquals((long)511L, (long)fs.getPermission().toShort());
        } else {
            Assert.assertEquals((long)420L, (long)fs.getPermission().toShort());
        }
        sTFS.setPermission(fileA, FsPermission.createImmutable((short)493));
        Assert.assertEquals((long)493L, (long)sTFS.getFileStatus(fileA).getPermission().toShort());
    }

    @Test
    @Ignore
    public void changeNonexistentOwnerForLocal() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs));
        Path fileA = new Path("/chownfileA-local");
        String nonexistentOwner = "nonexistent-user1";
        String nonexistentGroup = "nonexistent-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        FileStatus fs = sTFS.getFileStatus(fileA);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        Assert.assertEquals((Object)defaultOwner, (Object)sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)).getOwner());
        Assert.assertNotEquals((Object)defaultOwner, (Object)"nonexistent-user1");
        Assert.assertNotEquals((Object)defaultGroup, (Object)"nonexistent-group1");
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage("Could not setOwner for UFS file");
        sTFS.setOwner(fileA, "nonexistent-user1", null);
    }

    @Test
    @Ignore
    public void changeNonexistentGroupForLocal() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs));
        Path fileB = new Path("/chownfileB-local");
        String nonexistentOwner = "nonexistent-user1";
        String nonexistentGroup = "nonexistent-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileB);
        FileStatus fs = sTFS.getFileStatus(fileB);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        Assert.assertEquals((Object)defaultOwner, (Object)sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileB)).getOwner());
        Assert.assertNotEquals((Object)defaultOwner, (Object)"nonexistent-user1");
        Assert.assertNotEquals((Object)defaultGroup, (Object)"nonexistent-group1");
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage("Could not setOwner for UFS file");
        sTFS.setOwner(fileB, null, "nonexistent-group1");
    }

    @Test
    @Ignore
    public void changeNonexistentOwnerAndGroupForLocal() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs));
        Path fileC = new Path("/chownfileC-local");
        String nonexistentOwner = "nonexistent-user1";
        String nonexistentGroup = "nonexistent-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileC);
        FileStatus fs = sTFS.getFileStatus(fileC);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        Assert.assertEquals((Object)defaultOwner, (Object)sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileC)).getOwner());
        Assert.assertNotEquals((Object)defaultOwner, (Object)"nonexistent-user1");
        Assert.assertNotEquals((Object)defaultGroup, (Object)"nonexistent-group1");
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage("Could not update owner");
        sTFS.setOwner(fileC, "nonexistent-user1", "nonexistent-group1");
    }

    @Test
    public void changeNonexistentOwnerForHdfs() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs));
        Path fileA = new Path("/chownfileA-hdfs");
        String testOwner = "test-user1";
        String testGroup = "test-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        FileStatus fs = sTFS.getFileStatus(fileA);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        Assert.assertEquals((Object)defaultOwner, (Object)sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)).getOwner());
        Assert.assertNotEquals((Object)defaultOwner, (Object)"test-user1");
        Assert.assertNotEquals((Object)defaultGroup, (Object)"test-group1");
        sTFS.setOwner(fileA, "test-user1", null);
        fs = sTFS.getFileStatus(fileA);
        Assert.assertEquals((Object)"test-user1", (Object)fs.getOwner());
        Assert.assertEquals((Object)defaultGroup, (Object)fs.getGroup());
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA));
        Assert.assertEquals((Object)"test-user1", (Object)ufsStatus.getOwner());
        Assert.assertEquals((Object)defaultGroup, (Object)ufsStatus.getGroup());
    }

    @Test
    public void changeNonexistentGroupForHdfs() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs));
        Path fileB = new Path("/chownfileB-hdfs");
        String testOwner = "test-user1";
        String testGroup = "test-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileB);
        FileStatus fs = sTFS.getFileStatus(fileB);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        Assert.assertEquals((Object)defaultOwner, (Object)sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileB)).getOwner());
        Assert.assertNotEquals((Object)defaultOwner, (Object)"test-user1");
        Assert.assertNotEquals((Object)defaultGroup, (Object)"test-group1");
        sTFS.setOwner(fileB, null, "test-group1");
        fs = sTFS.getFileStatus(fileB);
        Assert.assertEquals((Object)defaultOwner, (Object)fs.getOwner());
        Assert.assertEquals((Object)"test-group1", (Object)fs.getGroup());
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileB));
        Assert.assertEquals((Object)defaultOwner, (Object)ufsStatus.getOwner());
        Assert.assertEquals((Object)"test-group1", (Object)ufsStatus.getGroup());
    }

    @Test
    public void changeNonexistentOwnerAndGroupForHdfs() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs));
        Path fileC = new Path("/chownfileC-hdfs");
        String testOwner = "test-user1";
        String testGroup = "test-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileC);
        FileStatus fs = sTFS.getFileStatus(fileC);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        Assert.assertEquals((Object)defaultOwner, (Object)sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileC)).getOwner());
        Assert.assertNotEquals((Object)defaultOwner, (Object)"test-user1");
        Assert.assertNotEquals((Object)defaultGroup, (Object)"test-group1");
        sTFS.setOwner(fileC, "test-user1", "test-group1");
        fs = sTFS.getFileStatus(fileC);
        Assert.assertEquals((Object)"test-user1", (Object)fs.getOwner());
        Assert.assertEquals((Object)"test-group1", (Object)fs.getGroup());
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileC));
        Assert.assertEquals((Object)"test-user1", (Object)ufsStatus.getOwner());
        Assert.assertEquals((Object)"test-group1", (Object)ufsStatus.getGroup());
    }

    @Test
    public void checkNullOwnerAndGroup() throws Exception {
        Path fileD = new Path("/chownfileD");
        FileSystemAclIntegrationTest.create(sTFS, fileD);
        FileStatus fs = sTFS.getFileStatus(fileD);
        String defaultOwner = fs.getOwner();
        String defaultGroup = fs.getGroup();
        sTFS.setOwner(fileD, null, null);
        fs = sTFS.getFileStatus(fileD);
        Assert.assertEquals((Object)defaultOwner, (Object)fs.getOwner());
        Assert.assertEquals((Object)defaultGroup, (Object)fs.getGroup());
    }

    @Test
    @Ignore
    public void directoryPermissionForUfs() throws IOException {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs) ? 1 : 0) != 0);
        Path dir = new Path("/root/directoryPermissionForUfsDir");
        sTFS.mkdirs(dir);
        FileStatus fs = sTFS.getFileStatus(dir);
        String defaultOwner = fs.getOwner();
        Short dirMode = fs.getPermission().toShort();
        FileStatus parentFs = sTFS.getFileStatus(dir.getParent());
        Short parentMode = parentFs.getPermission().toShort();
        UfsDirectoryStatus ufsStatus = sUfs.getDirectoryStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)dir));
        Assert.assertEquals((Object)defaultOwner, (Object)ufsStatus.getOwner());
        Assert.assertEquals((long)dirMode.shortValue(), (long)ufsStatus.getMode());
        Assert.assertEquals((long)parentMode.shortValue(), (long)sUfs.getDirectoryStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)dir.getParent())).getMode());
        short newMode = 493;
        FsPermission newPermission = new FsPermission(newMode);
        sTFS.setPermission(dir, newPermission);
        Assert.assertEquals((long)newMode, (long)sUfs.getDirectoryStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)dir)).getMode());
    }

    @Test
    @Ignore
    public void parentDirectoryPermissionForUfs() throws IOException {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs) ? 1 : 0) != 0);
        String path = "/root/parentDirectoryPermissionForUfsDir/parentDirectoryPermissionForUfsFile";
        Path fileA = new Path(path);
        Path dirA = fileA.getParent();
        sTFS.mkdirs(dirA);
        short parentMode = 448;
        FsPermission newPermission = new FsPermission(parentMode);
        sTFS.setPermission(dirA, newPermission);
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        Assert.assertEquals((long)parentMode, (long)sUfs.getDirectoryStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)dirA)).getMode());
        Path fileB = new Path("/root/dirB/fileB");
        Path dirB = fileB.getParent();
        sTFS.rename(dirA, dirB);
        Assert.assertEquals((long)parentMode, (long)sUfs.getDirectoryStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileB.getParent())).getMode());
    }

    @Test
    @Ignore
    public void loadFileMetadataMode() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs) && HadoopClientTestUtils.isHadoop2x() ? 1 : 0) != 0);
        ArrayList permissionValues = Lists.newArrayList((Object[])new Integer[]{73, 146, 219, 292, 365, 438, 511, 493, 475, 420, 347, 329});
        Iterator iterator = permissionValues.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            Path file = new Path("/loadFileMetadataMode" + value);
            sTFS.delete(file, false);
            String ufsPath = PathUtils.concatPath((Object)sUfsRoot, (Object)file);
            sUfs.create(ufsPath, CreateOptions.defaults((AlluxioConfiguration)Configuration.global()).setOwner("testuser").setGroup("testgroup").setMode(new Mode((short)value))).close();
            Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)file)));
            Assert.assertEquals((Object)new Mode((short)value).toString(), (Object)new Mode(sTFS.getFileStatus(file).getPermission().toShort()).toString());
        }
    }

    @Test
    @Ignore
    public void loadDirMetadataMode() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)sUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)sUfs) ? 1 : 0) != 0);
        ArrayList permissionValues = Lists.newArrayList((Object[])new Integer[]{73, 146, 219, 292, 365, 438, 511, 493, 475, 420, 347, 329});
        Iterator iterator = permissionValues.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            Path dir = new Path("/loadDirMetadataMode" + value + "/");
            sTFS.delete(dir, true);
            String ufsPath = PathUtils.concatPath((Object)sUfsRoot, (Object)dir);
            sUfs.mkdirs(ufsPath, MkdirsOptions.defaults((AlluxioConfiguration)Configuration.global()).setCreateParent(false).setOwner("testuser").setGroup("testgroup").setMode(new Mode((short)value)));
            Assert.assertTrue((boolean)sUfs.isDirectory(PathUtils.concatPath((Object)sUfsRoot, (Object)dir)));
            Assert.assertEquals((Object)new Mode((short)value).toString(), (Object)new Mode(sTFS.getFileStatus(dir).getPermission().toShort()).toString());
        }
    }

    @Test
    public void s3GetPermission() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isS3((UnderFileSystem)sUfs));
        Configuration.unset((PropertyKey)PropertyKey.UNDERFS_S3_OWNER_ID_TO_USERNAME_MAPPING);
        Path fileA = new Path("/s3GetPermissionFile");
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)));
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA));
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getOwner());
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getGroup());
        Assert.assertEquals((long)448L, (long)ufsStatus.getMode());
    }

    @Test
    public void gcsGetPermission() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isGcs((UnderFileSystem)sUfs));
        Configuration.unset((PropertyKey)PropertyKey.UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING);
        Path fileA = new Path("/gcsGetPermissionFile");
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)));
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA));
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getOwner());
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getGroup());
        Assert.assertEquals((long)448L, (long)ufsStatus.getMode());
    }

    @Test
    public void swiftGetPermission() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isSwift((UnderFileSystem)sUfs));
        Path fileA = new Path("/swiftGetPermissionFile");
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)));
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA));
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getOwner());
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getGroup());
        Assert.assertEquals((long)448L, (long)ufsStatus.getMode());
    }

    @Test
    public void ossGetPermission() throws Exception {
        Assume.assumeTrue((boolean)UnderFileSystemUtils.isOss((UnderFileSystem)sUfs));
        Path fileA = new Path("/objectfileA");
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        Assert.assertTrue((boolean)sUfs.isFile(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA)));
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA));
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getOwner());
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getGroup());
        Assert.assertEquals((long)511L, (long)ufsStatus.getMode());
    }

    @Test
    public void objectStoreSetOwner() throws Exception {
        Assume.assumeTrue((boolean)sUfs.isObjectStorage());
        Path fileA = new Path("/objectfileA");
        String newOwner = "new-user1";
        String newGroup = "new-group1";
        FileSystemAclIntegrationTest.create(sTFS, fileA);
        sTFS.setOwner(fileA, "new-user1", "new-group1");
        UfsFileStatus ufsStatus = sUfs.getFileStatus(PathUtils.concatPath((Object)sUfsRoot, (Object)fileA));
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getOwner());
        Assert.assertNotEquals((Object)"", (Object)ufsStatus.getGroup());
    }
}

