/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FileSystemStatisticsTest
extends BaseIntegrationTest {
    private static final int BLOCK_SIZE = 128;
    private static final int FILE_LEN = 257;
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 128).build();
    private static FileSystem.Statistics sStatistics;
    private static org.apache.hadoop.fs.FileSystem sTFS;

    @BeforeClass
    public static void beforeClass() throws Exception {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
        conf.set("fs.alluxio.impl", FileSystem.class.getName());
        alluxio.client.file.FileSystem alluxioFS = sLocalAlluxioClusterResource.get().getClient();
        FileSystemTestUtils.createByteFile((alluxio.client.file.FileSystem)alluxioFS, (String)"/testFile-read", (WritePType)WritePType.CACHE_THROUGH, (int)257);
        URI uri = URI.create(sLocalAlluxioClusterResource.get().getMasterURI());
        sTFS = org.apache.hadoop.fs.FileSystem.get((URI)uri, (org.apache.hadoop.conf.Configuration)HadoopConfigurationUtils.mergeAlluxioConfiguration((org.apache.hadoop.conf.Configuration)conf, (AlluxioConfiguration)Configuration.global()));
        sStatistics = org.apache.hadoop.fs.FileSystem.getStatistics((String)uri.getScheme(), sTFS.getClass());
    }

    @Test
    public void bytesReadStatistics() throws Exception {
        long originStat = sStatistics.getBytesRead();
        FSDataInputStream is = sTFS.open(new Path("/testFile-read"));
        while (is.read() != -1) {
        }
        is.close();
        Assert.assertEquals((long)(originStat + 257L), (long)sStatistics.getBytesRead());
    }

    @Test
    public void bytesWrittenStatistics() throws Exception {
        long originStat = sStatistics.getBytesWritten();
        FSDataOutputStream os = sTFS.create(new Path("/testFile-write"));
        for (int i = 0; i < 257; ++i) {
            os.write(1);
        }
        os.close();
        Assert.assertEquals((long)(originStat + 257L), (long)sStatistics.getBytesWritten());
    }

    @Test
    public void readWriteOperationsStatistics() throws Exception {
        int exceptedReadOps = sStatistics.getReadOps();
        int exceptedWriteOps = sStatistics.getWriteOps();
        sTFS.create(new Path("/testFile-create")).close();
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)(++exceptedWriteOps), (long)sStatistics.getWriteOps());
        sTFS.delete(new Path("/testFile-create"), true);
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)(++exceptedWriteOps), (long)sStatistics.getWriteOps());
        sTFS.getDefaultBlockSize();
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.getDefaultReplication();
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        FileStatus fStatus = sTFS.getFileStatus(new Path("/testFile-read"));
        Assert.assertEquals((long)(++exceptedReadOps), (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.getFileBlockLocations(fStatus, 0L, 257L);
        Assert.assertEquals((long)(++exceptedReadOps), (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.getUri();
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.getWorkingDirectory();
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.listStatus(new Path("/"));
        Assert.assertEquals((long)(++exceptedReadOps), (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.mkdirs(new Path("/testDir"));
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)(++exceptedWriteOps), (long)sStatistics.getWriteOps());
        sTFS.open(new Path("/testFile-read")).close();
        Assert.assertEquals((long)(++exceptedReadOps), (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
        sTFS.rename(new Path("/testDir"), new Path("/testDir-rename"));
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)(++exceptedWriteOps), (long)sStatistics.getWriteOps());
        sTFS.setWorkingDirectory(new Path("/testDir-rename"));
        Assert.assertEquals((long)exceptedReadOps, (long)sStatistics.getReadOps());
        Assert.assertEquals((long)exceptedWriteOps, (long)sStatistics.getWriteOps());
    }
}

