/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.conf.PropertyKey;
import alluxio.hadoop.FileSystem;
import alluxio.master.ZkMasterInquireClient;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.testutils.BaseIntegrationTest;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Master's URI is no longer used for writing")
public class FileSystemUriIntegrationTest
extends BaseIntegrationTest {
    private static final int WAIT_TIMEOUT_MS = 60000;
    private MultiProcessCluster mCluster;

    @After
    public void after() throws Exception {
        this.mCluster.destroy();
    }

    @Test
    public void zookeeperUriTest() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.ZOOKEEPER_URI).setClusterName("ZookeeperUriFileSystemIntegrationTest").setNumMasters(3).setNumWorkers(2).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).build();
        this.mCluster.start();
        ZkMasterInquireClient.ZkMasterConnectDetails connectDetails = (ZkMasterInquireClient.ZkMasterConnectDetails)this.mCluster.getMasterInquireClient().getConnectDetails();
        String zkAddress = connectDetails.getZkAddress();
        this.testConnection("zk@" + zkAddress);
    }

    @Test
    public void multiMasterUriTest() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.MULTI_MASTER_URI).setClusterName("MultiMastersUriFileSystemIntegrationTest").setNumMasters(3).setNumWorkers(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).build();
        this.mCluster.start();
        String address = this.mCluster.getMasterAddresses().stream().map(a -> a.getHostname() + ":" + a.getRpcPort()).collect(Collectors.joining(","));
        this.testConnection(address);
    }

    private void testConnection(String authority) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.alluxio.impl", FileSystem.class.getName());
        URI uri = URI.create("alluxio://" + authority + "/tmp/path.txt");
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        this.mCluster.waitForAllNodesRegistered(60000);
        Path file = new Path("/testFile");
        FsPermission permission = FsPermission.createImmutable((short)438);
        FSDataOutputStream o = fs.create(file, permission, false, 10, (short)1, 512L, null);
        o.writeBytes("Test Bytes");
        o.close();
        fs.deleteOnExit(file);
        fs.close();
        this.mCluster.notifySuccess();
    }
}

