/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.hadoop;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.ReadType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.PreconditionMessage;
import alluxio.grpc.WritePType;
import alluxio.hadoop.HadoopClientTestUtils;
import alluxio.hadoop.HdfsFileInputStream;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.fs.Seekable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class HdfsFileInputStreamIntegrationTest
extends BaseIntegrationTest {
    private static final int FILE_LEN = 255;
    private static final int BUFFER_SIZE = 50;
    private static final String IN_MEMORY_FILE = "/inMemoryFile";
    private static final String UFS_ONLY_FILE = "/ufsOnlyFile";
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private FileSystem mFileSystem;
    private HdfsFileInputStream mInMemInputStream;
    private HdfsFileInputStream mUfsInputStream;
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();

    @After
    public void after() throws IOException, AlluxioException {
        this.mInMemInputStream.close();
        this.mFileSystem.delete(new AlluxioURI(IN_MEMORY_FILE));
        if (this.mUfsInputStream != null) {
            this.mUfsInputStream.close();
            this.mFileSystem.delete(new AlluxioURI(UFS_ONLY_FILE));
        }
        HadoopClientTestUtils.disableMetrics((InstancedConfiguration)Configuration.modifiableGlobal());
    }

    @Before
    public final void before() throws Exception {
        this.mFileSystem = sLocalAlluxioClusterResource.get().getClient();
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)IN_MEMORY_FILE, (WritePType)WritePType.CACHE_THROUGH, (int)255);
        this.mInMemInputStream = new HdfsFileInputStream(this.mFileSystem, new AlluxioURI(IN_MEMORY_FILE), null);
    }

    private void createUfsInStream(ReadType readType) throws Exception {
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.USER_FILE_READ_TYPE_DEFAULT, readType.name());
        FileSystem fs = FileSystem.Factory.create((AlluxioConfiguration)conf);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)UFS_ONLY_FILE, (WritePType)WritePType.THROUGH, (int)255);
        this.mUfsInputStream = new HdfsFileInputStream(fs, new AlluxioURI(UFS_ONLY_FILE), null);
    }

    @Test
    public void available() throws Exception {
        Assert.assertEquals((long)255L, (long)this.mInMemInputStream.available());
        this.createUfsInStream(ReadType.NO_CACHE);
        Assert.assertEquals((long)255L, (long)this.mUfsInputStream.available());
        byte[] buf = new byte[50];
        int length1 = this.mInMemInputStream.read(buf);
        Assert.assertEquals((long)(255 - length1), (long)this.mInMemInputStream.available());
        int length2 = this.mUfsInputStream.read(buf);
        Assert.assertEquals((long)(255 - length2), (long)this.mUfsInputStream.available());
    }

    @Test
    public void readTest1() throws Exception {
        this.createUfsInStream(ReadType.NO_CACHE);
        for (int i = 0; i < 255; ++i) {
            int value = this.mInMemInputStream.read();
            Assert.assertEquals((long)(i & 0xFF), (long)value);
            value = this.mUfsInputStream.read();
            Assert.assertEquals((long)(i & 0xFF), (long)value);
        }
        Assert.assertEquals((long)255L, (long)this.mInMemInputStream.getPos());
        Assert.assertEquals((long)255L, (long)this.mUfsInputStream.getPos());
        int value = this.mInMemInputStream.read();
        Assert.assertEquals((long)-1L, (long)value);
        value = this.mUfsInputStream.read();
        Assert.assertEquals((long)-1L, (long)value);
    }

    @Test
    public void readTest2() throws Exception {
        byte[] buf = new byte[255];
        int length = this.mInMemInputStream.read(buf);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        this.createUfsInStream(ReadType.NO_CACHE);
        Arrays.fill(buf, (byte)0);
        length = this.mUfsInputStream.read(buf);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Arrays.fill(buf, (byte)0);
        length = this.mInMemInputStream.read(buf);
        Assert.assertEquals((long)-1L, (long)length);
        length = this.mUfsInputStream.read(buf);
        Assert.assertEquals((long)-1L, (long)length);
    }

    @Test
    public void readTest3() throws Exception {
        byte[] buf = new byte[255];
        int length = this.mInMemInputStream.read(buf, 0, 255);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        this.createUfsInStream(ReadType.NO_CACHE);
        Arrays.fill(buf, (byte)0);
        length = this.mUfsInputStream.read(buf, 0, 255);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Arrays.fill(buf, (byte)0);
        length = this.mInMemInputStream.read(buf, 0, 1);
        Assert.assertEquals((long)-1L, (long)length);
        length = this.mUfsInputStream.read(buf, 0, 1);
        Assert.assertEquals((long)-1L, (long)length);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix the test case")
    public void readTest4() throws Exception {
        byte[] buf = new byte[255];
        int length = this.mInMemInputStream.read(0L, buf, 0, 255);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mInMemInputStream.getPos());
        this.createUfsInStream(ReadType.NO_CACHE);
        Arrays.fill(buf, (byte)0);
        length = this.mUfsInputStream.read(0L, buf, 0, 255);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mUfsInputStream.getPos());
        buf = new byte[245];
        Arrays.fill(buf, (byte)0);
        length = this.mInMemInputStream.read(10L, buf, 0, 245);
        Assert.assertEquals((long)245L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)245, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mInMemInputStream.getPos());
        Arrays.fill(buf, (byte)0);
        length = this.mUfsInputStream.read(10L, buf, 0, 245);
        Assert.assertEquals((long)245L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)245, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mUfsInputStream.getPos());
        Arrays.fill(buf, (byte)0);
        length = this.mInMemInputStream.read(-1L, buf, 0, 255);
        Assert.assertEquals((long)-1L, (long)length);
        length = this.mUfsInputStream.read(-1L, buf, 0, 255);
        Assert.assertEquals((long)-1L, (long)length);
        length = this.mInMemInputStream.read(255L, buf, 0, 255);
        Assert.assertEquals((long)-1L, (long)length);
        length = this.mUfsInputStream.read(255L, buf, 0, 255);
        Assert.assertEquals((long)-1L, (long)length);
    }

    @Test
    public void readTest5() throws Exception {
        byte[] data = new byte[255];
        ByteBuffer buf = ByteBuffer.wrap(data);
        int length = this.mInMemInputStream.read(buf);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)255, (ByteBuffer)buf));
        this.createUfsInStream(ReadType.NO_CACHE);
        buf.rewind();
        buf.clear();
        length = this.mUfsInputStream.read(buf);
        Assert.assertEquals((long)255L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)255, (ByteBuffer)buf));
        buf.rewind();
        buf.clear();
        length = this.mInMemInputStream.read(buf);
        Assert.assertEquals((long)-1L, (long)length);
        length = this.mUfsInputStream.read(buf);
        Assert.assertEquals((long)-1L, (long)length);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void readFullyTest1() throws Exception {
        byte[] buf = new byte[255];
        this.mInMemInputStream.readFully(0L, buf);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mInMemInputStream.getPos());
        this.createUfsInStream(ReadType.NO_CACHE);
        Arrays.fill(buf, (byte)0);
        this.mUfsInputStream.readFully(0L, buf);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mUfsInputStream.getPos());
        buf = new byte[245];
        Arrays.fill(buf, (byte)0);
        this.mInMemInputStream.readFully(10L, buf);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)245, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mInMemInputStream.getPos());
        Arrays.fill(buf, (byte)0);
        this.mUfsInputStream.readFully(10L, buf);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)245, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mUfsInputStream.getPos());
        Arrays.fill(buf, (byte)0);
        try {
            this.mInMemInputStream.readFully(-1L, buf);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
        try {
            this.mUfsInputStream.readFully(-1L, buf);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
        try {
            this.mInMemInputStream.readFully(255L, buf);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
        try {
            this.mUfsInputStream.readFully(255L, buf);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void readFullyTest2() throws Exception {
        byte[] buf = new byte[255];
        this.mInMemInputStream.readFully(0L, buf, 0, 255);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mInMemInputStream.getPos());
        this.createUfsInStream(ReadType.NO_CACHE);
        Arrays.fill(buf, (byte)0);
        this.mUfsInputStream.readFully(0L, buf, 0, 255);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)255, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mUfsInputStream.getPos());
        buf = new byte[245];
        Arrays.fill(buf, (byte)0);
        this.mInMemInputStream.readFully(10L, buf, 0, 245);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)245, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mInMemInputStream.getPos());
        Arrays.fill(buf, (byte)0);
        this.mUfsInputStream.readFully(10L, buf, 0, 245);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)10, (int)245, (byte[])buf));
        Assert.assertEquals((long)0L, (long)this.mUfsInputStream.getPos());
        Arrays.fill(buf, (byte)0);
        try {
            this.mInMemInputStream.readFully(-1L, buf, 0, 255);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
        try {
            this.mUfsInputStream.readFully(-1L, buf, 0, 255);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
        try {
            this.mInMemInputStream.readFully(255L, buf, 0, 255);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
        try {
            this.mUfsInputStream.readFully(255L, buf, 0, 255);
            Assert.fail((String)"readFully() is expected to fail");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        BufferUtils.equalConstantByteArray((byte)0, (int)255, (byte[])buf);
    }

    @Test
    public void inMemSeek() throws Exception {
        this.seekTest((Seekable)this.mInMemInputStream);
    }

    @Test
    public void ufsSeek() throws Exception {
        this.createUfsInStream(ReadType.NO_CACHE);
        this.seekTest((Seekable)this.mUfsInputStream);
    }

    private void seekTest(Seekable stream) throws Exception {
        stream.seek(0L);
        Assert.assertEquals((long)0L, (long)stream.getPos());
        stream.seek(127L);
        Assert.assertEquals((long)127L, (long)stream.getPos());
        stream.seek(1L);
        Assert.assertEquals((long)1L, (long)stream.getPos());
    }

    @Test
    public void seekNegative() throws Exception {
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_NEGATIVE.toString(), -1));
        this.mInMemInputStream.seek(-1L);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void seekPastEof() throws Exception {
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_PAST_END_OF_FILE.toString(), 256));
        this.mInMemInputStream.seek(256L);
    }

    @Test
    public void seekNegativeUfs() throws Exception {
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_NEGATIVE.toString(), -1));
        this.createUfsInStream(ReadType.NO_CACHE);
        this.mUfsInputStream.seek(-1L);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void seekPastEofUfs() throws Exception {
        this.mThrown.expect(IOException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_PAST_END_OF_FILE.toString(), 256));
        this.createUfsInStream(ReadType.NO_CACHE);
        this.mUfsInputStream.seek(256L);
    }

    @Test
    public void positionedReadCache() throws Exception {
        this.createUfsInStream(ReadType.CACHE);
        this.mUfsInputStream.readFully(0L, new byte[255]);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)new AlluxioURI(UFS_ONLY_FILE), (int)100);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void positionedReadNoCache() throws Exception {
        this.createUfsInStream(ReadType.NO_CACHE);
        this.mUfsInputStream.readFully(0L, new byte[255]);
        URIStatus statusUfsOnlyFile = this.mFileSystem.getStatus(new AlluxioURI(UFS_ONLY_FILE));
        Assert.assertEquals((long)0L, (long)statusUfsOnlyFile.getInAlluxioPercentage());
    }
}

