/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.ClientContext;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.MasterInfo;
import alluxio.grpc.MasterInfoField;
import alluxio.master.MasterClientContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.wire.Property;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class MetaMasterIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mResource = new LocalAlluxioClusterResource.Builder().build();
    private int mWebPort;

    @Before
    public void prepareWebPort() throws Exception {
        this.mWebPort = this.mResource.get().getLocalAlluxioMaster().getMasterProcess().getWebAddress().getPort();
    }

    @Test
    public void getInfoAllFields() throws Exception {
        try (RetryHandlingMetaMasterClient client = new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());){
            MasterInfo info = client.getMasterInfo(Collections.emptySet());
            Assert.assertEquals((long)this.mWebPort, (long)info.getWebPort());
        }
    }

    @Test
    public void getMasterInfoWebPort() throws Exception {
        try (RetryHandlingMetaMasterClient client = new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());){
            MasterInfo info = client.getMasterInfo(new HashSet<MasterInfoField>(Arrays.asList(MasterInfoField.WEB_PORT)));
            Assert.assertEquals((long)this.mWebPort, (long)info.getWebPort());
        }
    }

    @Test
    public void getConfigurationWebPort() throws Exception {
        try (RetryHandlingMetaMasterConfigClient client = new RetryHandlingMetaMasterConfigClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());){
            List configList = client.getConfiguration(GetConfigurationPOptions.newBuilder().setIgnorePathConf(true).build()).getClusterConf();
            int configWebPort = -1;
            for (Property info : configList) {
                if (!info.getName().equals("alluxio.master.web.port")) continue;
                configWebPort = Integer.valueOf((String)info.getValue());
            }
            Assert.assertEquals((long)this.mWebPort, (long)configWebPort);
        }
    }
}

