/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.client.WriteType;
import alluxio.client.rest.RestApiTest;
import alluxio.conf.PropertyKey;
import alluxio.testutils.LocalAlluxioClusterResource;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import javax.ws.rs.core.Response;
import org.gaul.s3proxy.junit.S3ProxyRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CreateBucketTest
extends RestApiTest {
    private static final String TEST_BUCKET = "test-bucket";
    private static final int UFS_PORT = 8002;
    private AmazonS3 mS3Client = null;
    @Rule
    public S3ProxyRule mS3Proxy = S3ProxyRule.builder().withBlobStoreProvider("transient").withPort(8002).withCredentials("_", "_").build();
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setIncludeProxy(true).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).setProperty(PropertyKey.WORKER_BLOCK_STORE_TYPE, "PAGE").setProperty(PropertyKey.WORKER_PAGE_STORE_PAGE_SIZE, 1024).setProperty(PropertyKey.UNDERFS_S3_ENDPOINT, "localhost:8002").setProperty(PropertyKey.UNDERFS_S3_ENDPOINT_REGION, "us-west-2").setProperty(PropertyKey.UNDERFS_S3_DISABLE_DNS_BUCKETS, true).setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "s3://test-bucket").setProperty(PropertyKey.DORA_CLIENT_UFS_ROOT, "s3://test-bucket").setProperty(PropertyKey.WORKER_HTTP_SERVER_ENABLED, false).setProperty(PropertyKey.S3A_ACCESS_KEY, this.mS3Proxy.getAccessKey()).setProperty(PropertyKey.S3A_SECRET_KEY, this.mS3Proxy.getSecretKey()).setNumWorkers(2).build();

    @Before
    public void before() throws Exception {
        this.mS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.mS3Proxy.getAccessKey(), this.mS3Proxy.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.mS3Proxy.getUri().toString(), Regions.US_WEST_2.getName()))).build();
        this.mS3Client.createBucket(TEST_BUCKET);
        this.mHostname = this.mLocalAlluxioClusterResource.get().getHostname();
        this.mPort = this.mLocalAlluxioClusterResource.get().getProxyProcess().getWebLocalPort();
        this.mBaseUri = String.format("/api/v1/s3", new Object[0]);
    }

    @After
    public void after() {
        this.mS3Client = null;
    }

    @Test
    public void createBucket() throws Exception {
        String bucketName = "bucket";
        this.headTestCase(bucketName).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.createBucketTestCase(bucketName).checkResponseCode(Response.Status.OK.getStatusCode());
        this.headTestCase(bucketName).checkResponseCode(Response.Status.OK.getStatusCode());
        this.createBucketTestCase(bucketName).checkResponseCode(Response.Status.CONFLICT.getStatusCode()).checkErrorCode("BucketAlreadyExists");
    }

    @Test
    public void deleteBucket() throws Exception {
        String bucketName = "bucket";
        this.headTestCase(bucketName).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.deleteTestCase(bucketName).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
        this.createBucketTestCase(bucketName).checkResponseCode(Response.Status.OK.getStatusCode());
        this.deleteTestCase(bucketName).checkResponseCode(Response.Status.NO_CONTENT.getStatusCode());
        this.headTestCase(bucketName).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
    }
}

