/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.rest.RestApiTest;
import alluxio.conf.PropertyKey;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import javax.ws.rs.core.Response;
import org.gaul.s3proxy.junit.S3ProxyRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class S3ObjectTest
extends RestApiTest {
    private FileSystem mFileSystem;
    private AmazonS3 mS3Client = null;
    private static final int UFS_PORT = 8003;
    @Rule
    public S3ProxyRule mS3Proxy = S3ProxyRule.builder().withBlobStoreProvider("transient").withPort(8003).withCredentials("_", "_").build();
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setIncludeProxy(true).setProperty(PropertyKey.USER_FILE_METADATA_SYNC_INTERVAL, "0s").setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).setProperty(PropertyKey.WORKER_BLOCK_STORE_TYPE, "PAGE").setProperty(PropertyKey.WORKER_PAGE_STORE_PAGE_SIZE, 1024).setProperty(PropertyKey.UNDERFS_S3_ENDPOINT, "localhost:8003").setProperty(PropertyKey.UNDERFS_S3_ENDPOINT_REGION, "us-west-2").setProperty(PropertyKey.UNDERFS_S3_DISABLE_DNS_BUCKETS, true).setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "s3://test-bucket").setProperty(PropertyKey.DORA_CLIENT_UFS_ROOT, "s3://test-bucket").setProperty(PropertyKey.WORKER_HTTP_SERVER_ENABLED, false).setProperty(PropertyKey.S3A_ACCESS_KEY, this.mS3Proxy.getAccessKey()).setProperty(PropertyKey.S3A_SECRET_KEY, this.mS3Proxy.getSecretKey()).setNumWorkers(2).build();

    @Before
    public void before() throws Exception {
        this.mS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.mS3Proxy.getAccessKey(), this.mS3Proxy.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.mS3Proxy.getUri().toString(), Regions.US_WEST_2.getName()))).build();
        this.mS3Client.createBucket("test-bucket");
        this.mHostname = this.mLocalAlluxioClusterResource.get().getHostname();
        this.mPort = this.mLocalAlluxioClusterResource.get().getProxyProcess().getWebLocalPort();
        this.mBaseUri = String.format("/api/v1/s3", new Object[0]);
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @After
    public void after() {
        this.mS3Client = null;
    }

    @Test
    public void getNonExistentObject() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchKey");
    }

    @Test
    public void getDeletedObject() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object", EMPTY_CONTENT).checkResponseCode(Response.Status.OK.getStatusCode());
        this.mS3Client.deleteObject("test-bucket", "bucket/object");
        this.getTestCase("bucket/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchKey");
    }

    @Test
    public void headNonExistentDirectory() throws Exception {
        String bucket = "bucket";
        String folderKey = "folder";
        String fullKey = "bucket/folder/";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.headTestCase("bucket/folder/").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void headDeletedDirectory() throws Exception {
        String bucket = "bucket";
        String folderKey = "folder";
        String fullKey = "bucket/folder/";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/folder/", EMPTY_CONTENT).checkResponseCode(Response.Status.OK.getStatusCode());
        this.mS3Client.deleteObject("test-bucket", "bucket/folder/");
        this.headTestCase("bucket/folder/").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void putAndGetSmallObject() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content).checkHeader("Content-Type", "application/octet-stream").checkHeader("Content-Length", String.valueOf(content.length));
    }

    @Ignore
    public void putAndGetLargeObject() throws Exception {
    }

    @Test
    public void putAndHeadDirectory() throws Exception {
        String bucket = "bucket";
        String folderKey1 = "folder1";
        String folderKey2 = "folder2";
        String fullKey1 = "bucket/folder1/";
        String fullKey2 = "bucket/folder1/folder2/";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/folder1/folder2/", EMPTY_CONTENT).checkResponseCode(Response.Status.OK.getStatusCode());
        this.headTestCase("bucket/folder1/").checkResponseCode(Response.Status.OK.getStatusCode());
        this.headTestCase("bucket/folder1/folder2/").checkResponseCode(Response.Status.OK.getStatusCode());
    }

    @Test
    public void overwriteObject() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        byte[] content = "Hello World!".getBytes();
        byte[] content2 = CommonUtils.randomAlphaNumString((int)1024).getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content);
        this.createObjectTestCase("bucket/object", content2).checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content2).checkHeader("Content-Length", String.valueOf(content2.length));
    }

    @Test
    public void putDirectoryToNonExistentBucket() throws Exception {
        String bucket = "non-existent-bucket";
        String folderKey = "folder";
        String fullKey = "non-existent-bucket/folder/";
        this.headTestCase("non-existent-bucket").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.createObjectTestCase("non-existent-bucket/folder/", EMPTY_CONTENT).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Test
    public void putObjectToNonExistentBucket() throws Exception {
        String bucket = "non-existent-bucket";
        String objectKey = "object";
        String fullKey = "non-existent-bucket/object";
        byte[] content = "Hello World!".getBytes();
        this.headTestCase("non-existent-bucket").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.createObjectTestCase("non-existent-bucket/object", content).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Test
    public void putObjectToDeletedBucket() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.mS3Client.deleteObject("test-bucket", "bucket/");
        this.createObjectTestCase("bucket/object", content).checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Test
    public void putObjectWithWrongMD5() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object", this.getDefaultOptionsWithAuth().setBody(content).setMD5("")).checkResponseCode(Response.Status.BAD_REQUEST.getStatusCode()).checkErrorCode("BadDigest");
    }

    @Test
    public void putObjectWithoutMD5() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object", this.getDefaultOptionsWithAuth().setBody(content)).checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content);
    }

    @Test
    public void copyObjectAndRename() throws Exception {
        String bucket = "bucket";
        String objectKey1 = "object1";
        String objectKey2 = "object2";
        String sourcePath = "bucket/object1";
        String targetPath = "bucket/object2";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object1", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.copyObjectTestCase("bucket/object1", "bucket/object2").checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object2").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content).checkHeader("Content-Type", "application/octet-stream").checkHeader("Content-Length", String.valueOf(content.length));
    }

    @Test
    public void copyNonExistentObject() throws Exception {
        String bucket = "bucket";
        String objectKey1 = "object1";
        String objectKey2 = "object2";
        String sourcePath = "bucket/object1";
        String targetPath = "bucket/object2";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.copyObjectTestCase("bucket/object1", "bucket/object2").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchKey");
    }

    @Test
    public void copyDeletedObject() throws Exception {
        String bucket = "bucket";
        String objectKey1 = "object1";
        String objectKey2 = "object2";
        String sourcePath = "bucket/object1";
        String targetPath = "bucket/object2";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object1", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.mS3Client.deleteObject("test-bucket", "bucket/object1");
        this.copyObjectTestCase("bucket/object1", "bucket/object2").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchKey");
    }

    @Test
    public void copyObjectAndOverwrite() throws Exception {
        String bucket = "bucket";
        String objectKey1 = "object1";
        String objectKey2 = "object2";
        String sourcePath = "bucket/object1";
        String targetPath = "bucket/object2";
        byte[] content = "Hello World!".getBytes();
        byte[] content2 = CommonUtils.randomAlphaNumString((int)1024).getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object1", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/object2", content2).checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object2").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content2);
        this.copyObjectTestCase("bucket/object1", "bucket/object2").checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/object2").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content);
    }

    @Test
    public void copyObjectToNonExistentBucket() throws Exception {
        String bucket1 = "bucket1";
        String bucket2 = "bucket2";
        String objectKey = "object";
        String sourcePath = "bucket1/object";
        String targetPath = "bucket2/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket1").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket1/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.headTestCase("bucket2").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.copyObjectTestCase("bucket1/object", "bucket2/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Test
    public void copyObjectToDeletedBucket() throws Exception {
        String bucket1 = "bucket1";
        String bucket2 = "bucket2";
        String objectKey = "object";
        String sourcePath = "bucket1/object";
        String targetPath = "bucket2/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket1").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createBucketTestCase("bucket2").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket1/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.mS3Client.deleteObject("test-bucket", "bucket2/");
        this.copyObjectTestCase("bucket1/object", "bucket2/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Ignore
    public void copyObjectToAnotherBucket() throws Exception {
        String bucket1 = "bucket1";
        String bucket2 = "bucket2";
        String objectKey = "object";
        String sourcePath = "bucket1/object";
        String targetPath = "bucket2/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket1").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createBucketTestCase("bucket2").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket1/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.copyObjectTestCase("bucket1/object", "bucket2/").checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket2/object").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content);
    }

    @Ignore
    public void copyObjectToAnotherDir() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String folderKey1 = "sourceDir";
        String folderKey2 = "targetDir";
        String sourcePath = "bucket/sourceDir/object";
        String targetPath = "bucket/targetDir/object";
        String fullFolderKey2 = "bucket/targetDir/";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/sourceDir/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.copyObjectTestCase("bucket/sourceDir/object", "bucket/targetDir/").checkResponseCode(Response.Status.OK.getStatusCode());
        this.getTestCase("bucket/targetDir/object").checkResponseCode(Response.Status.OK.getStatusCode()).checkResponse(content);
    }

    @Test
    public void deleteObjectAndDirectory() throws Exception {
        String bucket = "bucket";
        String folderKey = "folder";
        String objectKey = "object";
        String fullFolderKey = "bucket/folder";
        String fullObjectKey = "bucket/folder/object";
        byte[] content = "Hello World!".getBytes();
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.createObjectTestCase("bucket/folder/object", content).checkResponseCode(Response.Status.OK.getStatusCode());
        this.deleteTestCase("bucket/folder").checkResponseCode(Response.Status.NO_CONTENT.getStatusCode());
        this.headTestCase("bucket/folder/object").checkResponseCode(Response.Status.OK.getStatusCode());
        this.deleteTestCase("bucket/folder/object").checkResponseCode(Response.Status.NO_CONTENT.getStatusCode());
        this.headTestCase("bucket/folder/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.deleteTestCase("bucket/folder/object").checkResponseCode(Response.Status.NO_CONTENT.getStatusCode());
        this.headTestCase("bucket/folder/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
    }

    @Test
    public void deleteObjectInNonExistentBucket() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        this.headTestCase("bucket").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.deleteTestCase("bucket/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Test
    public void deleteObjectInDeletedBucket() throws Exception {
        String bucket = "bucket";
        String objectKey = "object";
        String fullKey = "bucket/object";
        this.createBucketTestCase("bucket").checkResponseCode(Response.Status.OK.getStatusCode());
        this.mS3Client.deleteObject("test-bucket", "bucket/");
        this.deleteTestCase("bucket/object").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }

    @Test
    public void deleteDirectoryInNonExistentBucket() throws Exception {
        String bucket = "bucket";
        String folderKey = "folder";
        String fullKey = "bucket/folder/";
        this.headTestCase("bucket").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode());
        this.deleteTestCase("bucket/folder/").checkResponseCode(Response.Status.NOT_FOUND.getStatusCode()).checkErrorCode("NoSuchBucket");
    }
}

