/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.rest;

import alluxio.client.rest.TestCaseOptions;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.proxy.s3.S3Error;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

@NotThreadSafe
public final class TestCase {
    private static final ObjectMapper XML_MAPPER = new XmlMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    private final String mHostname;
    private final int mPort;
    private final String mBaseUri;
    private final String mEndpoint;
    private final Map<String, String> mParameters;
    private final String mMethod;
    private final TestCaseOptions mOptions;
    private final HttpURLConnection mConnection;

    public TestCase(String hostname, int port, String baseUri, String endpoint, Map<String, String> parameters, String method, TestCaseOptions options) throws Exception {
        this.mHostname = hostname;
        this.mPort = port;
        this.mBaseUri = baseUri;
        this.mEndpoint = endpoint;
        this.mParameters = parameters;
        this.mMethod = method;
        this.mOptions = options;
        this.mConnection = this.execute();
    }

    public String getEndpoint() {
        return this.mEndpoint;
    }

    public String getMethod() {
        return this.mMethod;
    }

    public URL createURL() throws Exception {
        String url = String.format("http://%s:%s%s/%s", this.mHostname, this.mPort, this.mBaseUri, this.mEndpoint);
        if (this.mParameters.size() == 0) {
            return new URL(url);
        }
        Map<Boolean, List<Map.Entry>> streams = this.mParameters.entrySet().stream().collect(Collectors.partitioningBy(e -> ((String)e.getValue()).isEmpty()));
        Joiner j = Joiner.on((String)"&");
        String emptyValParams = j.join((Iterable)streams.get(true).stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        String argParams = j.withKeyValueSeparator("=").join(streams.get(false).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        url = String.format("%s?%s&%s", url, emptyValParams, argParams);
        return new URL(url);
    }

    public String getResponse() throws Exception {
        int len;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.mConnection.getInputStream()));
        char[] buffer = new char[1024];
        while ((len = br.read(buffer)) > 0) {
            sb.append(buffer, 0, len);
        }
        br.close();
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public HttpURLConnection execute() throws Exception {
        block57: {
            connection = (HttpURLConnection)this.createURL().openConnection();
            connection.setRequestMethod(this.mMethod);
            for (Map.Entry<String, String> entry : this.mOptions.getHeaders().entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (this.mOptions.getBody() == null) break block57;
            connection.setDoOutput(true);
            var2_2 = this.mOptions.getContentType();
            var3_4 = -1;
            switch (var2_2.hashCode()) {
                case -1248326952: {
                    if (!var2_2.equals("application/xml")) break;
                    var3_4 = 0;
                    break;
                }
                case -43840953: {
                    if (!var2_2.equals("application/json")) break;
                    var3_4 = 1;
                    break;
                }
                case 1178484637: {
                    if (!var2_2.equals("application/octet-stream")) break;
                    var3_4 = 2;
                    break;
                }
                case 817335912: {
                    if (!var2_2.equals("text/plain")) break;
                    var3_4 = 3;
                }
            }
            switch (var3_4) {
                case 0: {
                    os = connection.getOutputStream();
                    var5_9 = null;
                    os.write(TestCase.XML_MAPPER.writeValueAsBytes(this.mOptions.getBody()));
                    if (os == null) break;
                    if (var5_9 == null) ** GOTO lbl40
                    try {
                        os.close();
                    }
                    catch (Throwable var6_13) {
                        var5_9.addSuppressed(var6_13);
                    }
                    break;
lbl40:
                    // 1 sources

                    os.close();
                    break;
                    catch (Throwable var6_14) {
                        try {
                            var5_9 = var6_14;
                            throw var6_14;
                        }
                        catch (Throwable var7_21) {
                            if (os != null) {
                                if (var5_9 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var8_22) {
                                        var5_9.addSuppressed(var8_22);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var7_21;
                        }
                    }
                }
                case 1: {
                    os = connection.getOutputStream();
                    var5_10 = null;
                    os.write(TestCase.JSON_MAPPER.writeValueAsBytes(this.mOptions.getBody()));
                    if (os == null) break;
                    if (var5_10 == null) ** GOTO lbl70
                    try {
                        os.close();
                    }
                    catch (Throwable var6_15) {
                        var5_10.addSuppressed(var6_15);
                    }
                    break;
lbl70:
                    // 1 sources

                    os.close();
                    break;
                    catch (Throwable var6_16) {
                        try {
                            var5_10 = var6_16;
                            throw var6_16;
                        }
                        catch (Throwable var9_23) {
                            if (os != null) {
                                if (var5_10 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var10_24) {
                                        var5_10.addSuppressed(var10_24);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var9_23;
                        }
                    }
                }
                case 2: {
                    os = connection.getOutputStream();
                    var5_11 = null;
                    os.write((byte[])this.mOptions.getBody());
                    if (os == null) break;
                    if (var5_11 == null) ** GOTO lbl100
                    try {
                        os.close();
                    }
                    catch (Throwable var6_17) {
                        var5_11.addSuppressed(var6_17);
                    }
                    break;
lbl100:
                    // 1 sources

                    os.close();
                    break;
                    catch (Throwable var6_18) {
                        try {
                            var5_11 = var6_18;
                            throw var6_18;
                        }
                        catch (Throwable var11_25) {
                            if (os != null) {
                                if (var5_11 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var12_26) {
                                        var5_11.addSuppressed(var12_26);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var11_25;
                        }
                    }
                }
                case 3: {
                    os = connection.getOutputStream();
                    var5_12 = null;
                    os.write(((String)this.mOptions.getBody()).getBytes(this.mOptions.getCharset()));
                    if (os == null) break;
                    if (var5_12 == null) ** GOTO lbl130
                    try {
                        os.close();
                    }
                    catch (Throwable var6_19) {
                        var5_12.addSuppressed(var6_19);
                    }
                    break;
lbl130:
                    // 1 sources

                    os.close();
                    break;
                    catch (Throwable var6_20) {
                        try {
                            var5_12 = var6_20;
                            throw var6_20;
                        }
                        catch (Throwable var13_27) {
                            if (os != null) {
                                if (var5_12 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var14_28) {
                                        var5_12.addSuppressed(var14_28);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var13_27;
                        }
                    }
                }
                default: {
                    throw new InvalidArgumentException(String.format("No mapper available for content type %s in TestCaseOptions!", new Object[]{this.mOptions.getContentType()}));
                }
            }
        }
        connection.connect();
        return connection;
    }

    @Deprecated
    public HttpURLConnection executeAndAssertSuccess() throws Exception {
        HttpURLConnection connection = this.execute();
        if (Response.Status.Family.familyOf((int)connection.getResponseCode()) != Response.Status.Family.SUCCESSFUL) {
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                Assert.fail((String)("Request failed: " + IOUtils.toString((InputStream)errorStream)));
            }
            Assert.fail((String)("Request failed with status code " + connection.getResponseCode()));
        }
        return connection;
    }

    @Deprecated
    public String runAndGetResponse() throws Exception {
        this.executeAndAssertSuccess();
        return this.getResponse();
    }

    @Deprecated
    public void runAndCheckResult() throws Exception {
        this.runAndCheckResult(null);
    }

    @Deprecated
    public void runAndCheckResult(Object expectedResult) throws Exception {
        String expected = "";
        if (expectedResult != null) {
            expected = this.convertToString(expectedResult);
        }
        String result = this.runAndGetResponse();
        System.out.println(result);
        Assert.assertEquals((String)this.mEndpoint, (Object)expected, (Object)result);
    }

    public TestCase checkResponse(@NotNull Object expectedResult) throws Exception {
        String expected = this.convertToString(expectedResult);
        Assert.assertEquals((String)this.mEndpoint, (Object)expected, (Object)this.getResponse());
        return this;
    }

    public TestCase checkResponseCode(@NotNull int expected) throws Exception {
        Assert.assertEquals((String)this.mEndpoint, (long)expected, (long)this.mConnection.getResponseCode());
        return this;
    }

    public TestCase checkHeader(@NotNull String header, @NotNull String expected) throws Exception {
        Assert.assertEquals((String)this.mEndpoint, (Object)expected, (Object)this.mConnection.getHeaderField(header));
        return this;
    }

    public TestCase checkErrorCode(@NotNull String expectedErrorCode) throws Exception {
        InputStream errorStream = this.mConnection.getErrorStream();
        S3Error response = (S3Error)XML_MAPPER.readerFor(S3Error.class).readValue(errorStream);
        Assert.assertEquals((String)this.mEndpoint, (Object)expectedErrorCode, (Object)response.getCode());
        return this;
    }

    private String convertToString(@NotNull Object expectedResult) throws Exception {
        switch (this.mOptions.getContentType()) {
            case "application/json": {
                ObjectMapper mapper = new ObjectMapper();
                if (this.mOptions.isPrettyPrint()) {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(expectedResult);
                }
                return mapper.writeValueAsString(expectedResult);
            }
            case "application/xml": {
                XmlMapper mapper = new XmlMapper();
                if (this.mOptions.isPrettyPrint()) {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(expectedResult);
                }
                return mapper.writeValueAsString(expectedResult);
            }
            case "application/octet-stream": {
                return new String((byte[])expectedResult, this.mOptions.getCharset());
            }
            case "text/plain": {
                return (String)expectedResult;
            }
        }
        throw new InvalidArgumentException("Invalid content type in TestCaseOptions!");
    }
}

