/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.migrate;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.job.JobConfig;
import alluxio.job.JobIntegrationTest;
import alluxio.job.plan.migrate.MigrateConfig;
import alluxio.job.wire.JobInfo;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jianjian", comment="job service is deprecated but recycle the test cases")
public final class MigrateIntegrationTest
extends JobIntegrationTest {
    private static final byte[] TEST_BYTES = "hello".getBytes();
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();

    @Test
    public void migrateFile() throws Exception {
        File ufsMountPoint1 = this.mFolder.newFolder();
        File ufsMountPoint2 = this.mFolder.newFolder();
        this.mFileSystem.mount(new AlluxioURI("/mount1"), new AlluxioURI(ufsMountPoint1.getAbsolutePath()));
        this.mFileSystem.mount(new AlluxioURI("/mount2"), new AlluxioURI(ufsMountPoint2.getAbsolutePath()));
        String source = "/mount1/source";
        String destination = "/mount2/destination";
        this.createFileWithTestBytes(source);
        long jobId = this.mJobMaster.run((JobConfig)new MigrateConfig(source, destination, WriteType.CACHE_THROUGH, true));
        JobInfo info = this.waitForJobToFinish(jobId);
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(source)));
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(destination)));
        this.checkFileContainsTestBytes(destination);
        Assert.assertEquals((long)1L, (long)info.getChildren().size());
    }

    @Test
    public void migrateDirectory() throws Exception {
        File ufsMountPoint1 = this.mFolder.newFolder();
        File ufsMountPoint2 = this.mFolder.newFolder();
        this.mFileSystem.mount(new AlluxioURI("/mount1"), new AlluxioURI(ufsMountPoint1.getAbsolutePath()));
        this.mFileSystem.mount(new AlluxioURI("/mount2"), new AlluxioURI(ufsMountPoint2.getAbsolutePath()));
        this.mFileSystem.createDirectory(new AlluxioURI("/mount1/source"));
        this.createFileWithTestBytes("/mount1/source/foo");
        this.createFileWithTestBytes("/mount1/source/bar");
        this.mFileSystem.createDirectory(new AlluxioURI("/mount1/source/baz"));
        this.createFileWithTestBytes("/mount1/source/baz/bat");
        long jobId = this.mJobMaster.run((JobConfig)new MigrateConfig("/mount1/source", "/mount2/destination", WriteType.CACHE_THROUGH, true));
        this.waitForJobFailure(jobId);
    }

    private void createFileWithTestBytes(String filename) throws Exception {
        try (FileOutStream out = this.mFileSystem.createFile(new AlluxioURI(filename), CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build());){
            out.write(TEST_BYTES);
        }
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(filename)));
    }

    private void checkFileContainsTestBytes(String filename) throws Exception {
        try (FileInStream in = this.mFileSystem.openFile(new AlluxioURI(filename));){
            Assert.assertArrayEquals((byte[])TEST_BYTES, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }
}

