/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.plan.persist;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.job.JobConfig;
import alluxio.job.JobIntegrationTest;
import alluxio.job.plan.persist.PersistConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.master.file.meta.PersistenceState;
import alluxio.master.job.JobMaster;
import alluxio.resource.CloseableResource;
import alluxio.security.authorization.Mode;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.CommonUtils;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jianjian", comment="job service is deprecated but recycle the test cases")
public final class PersistIntegrationTest
extends JobIntegrationTest {
    private static final String TEST_URI = "/test";
    private static final Mode TEST_MODE = new Mode(511);

    @Test
    public void persistTest() throws Exception {
        AlluxioURI filePath = new AlluxioURI(TEST_URI);
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        os.write(0);
        os.write(1);
        os.close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.NOT_PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        this.waitForJobToFinish(this.mJobMaster.run((JobConfig)new PersistConfig(TEST_URI, 1L, true, status.getUfsPath())));
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        Assert.assertTrue((boolean)ufs.exists(ufsPath));
        this.waitForJobToFinish(this.mJobMaster.run((JobConfig)new PersistConfig(TEST_URI, 1L, true, status.getUfsPath())));
        Assert.assertTrue((boolean)ufs.exists(ufsPath));
        long jobId = this.mJobMaster.run((JobConfig)new PersistConfig(TEST_URI, 1L, false, status.getUfsPath()));
        this.waitForJobFailure(jobId);
    }

    @Test
    public void persistWithAccessTimeUnchangedTest() throws Exception {
        AlluxioURI filePath = new AlluxioURI(TEST_URI);
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        os.write(0);
        os.write(1);
        os.close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.NOT_PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        this.waitForJobToFinish(this.mJobMaster.run((JobConfig)new PersistConfig(TEST_URI, 1L, true, status.getUfsPath())));
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        Assert.assertTrue((boolean)ufs.exists(ufsPath));
        URIStatus newStatus = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((long)newStatus.getLastAccessTimeMs(), (long)status.getLastAccessTimeMs());
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.persistence.max.total.wait.time", "1ms", "alluxio.master.persistence.checker.interval", "50ms", "alluxio.master.persistence.scheduler.interval", "50ms"})
    public void persistTimeoutTest() throws Exception {
        AlluxioURI filePath = new AlluxioURI(TEST_URI);
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        os.write(0);
        os.write(1);
        os.close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.NOT_PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        this.mLocalAlluxioJobCluster.getWorker().stop();
        try (CloseableResource client = this.mFsContext.acquireMasterClientResource();){
            ((FileSystemMasterClient)client.get()).scheduleAsyncPersist(new AlluxioURI(TEST_URI), FileSystemOptionsUtils.scheduleAsyncPersistDefaults((AlluxioConfiguration)Configuration.global()));
        }
        CommonUtils.waitFor((String)"persist timeout", () -> {
            try {
                return PersistenceState.NOT_PERSISTED.toString().equals(this.mFileSystem.getStatus(filePath).getPersistenceState());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
        status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.NOT_PERSISTED.toString(), (Object)status.getPersistenceState());
        this.mLocalAlluxioClusterResource.get().restartMasters();
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.NOT_PERSISTED.toString(), (Object)status.getPersistenceState());
        String ufsPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)ufsPath, (AlluxioConfiguration)Configuration.global());
        Assert.assertFalse((boolean)ufs.exists(ufsPath));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.persistence.initial.interval", "10s"})
    public void disallowIncompletePersist() throws Exception {
        AlluxioURI path = new AlluxioURI("/" + CommonUtils.randomAlphaNumString((int)10));
        FileOutStream os = this.mFileSystem.createFile(path, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setMode(TEST_MODE.toProto()).build());
        try (CloseableResource client = this.mFsContext.acquireMasterClientResource();){
            ((FileSystemMasterClient)client.get()).scheduleAsyncPersist(path, FileSystemOptionsUtils.scheduleAsyncPersistDefaults((AlluxioConfiguration)Configuration.global()));
            Assert.fail((String)"Should not be able to schedule persistence for incomplete file");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Failure expected to be about incomplete files", (boolean)e.getMessage().toLowerCase().contains("incomplete"));
        }
    }

    @Test(timeout=30000L)
    public void persistOnlyCompleteFiles() throws Exception {
        AlluxioURI path = new AlluxioURI("/" + CommonUtils.randomAlphaNumString((int)10));
        FileOutStream os = this.mFileSystem.createFile(path, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setMode(TEST_MODE.toProto()).build());
        URIStatus status = this.mFileSystem.getStatus(path);
        String tempUfsPath = PathUtils.temporaryFileName((long)System.currentTimeMillis(), (String)status.getUfsPath());
        JobMaster jobMaster = this.mLocalAlluxioJobCluster.getMaster().getJobMaster();
        long failId = jobMaster.run((JobConfig)new PersistConfig(path.toString(), status.getMountId(), false, tempUfsPath));
        CommonUtils.waitFor((String)"Wait for persist job to complete", () -> {
            try {
                JobInfo jobInfo = jobMaster.getStatus(failId);
                Assert.assertNotEquals((String)"Persist should not succeed for incomplete file", (Object)Status.COMPLETED, (Object)jobInfo.getStatus());
                if (jobInfo.getStatus() == Status.FAILED) {
                    Assert.assertTrue((String)"Failure expected to be about incomplete files", (boolean)jobInfo.getErrorMessage().toLowerCase().contains("incomplete"));
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L).setInterval(100));
        os.close();
        long successId = jobMaster.run((JobConfig)new PersistConfig(path.toString(), status.getMountId(), false, tempUfsPath));
        CommonUtils.waitFor((String)"Wait for persist job to complete", () -> {
            try {
                JobInfo jobInfo = jobMaster.getStatus(successId);
                Assert.assertNotEquals((String)"Persist should not fail", (Object)Status.FAILED, (Object)jobInfo.getStatus());
                return jobInfo.getStatus() == Status.COMPLETED;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L).setInterval(100));
    }
}

