/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.util;

import alluxio.exception.JobDoesNotExistException;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.master.job.JobMaster;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class JobTestUtils {
    public static JobInfo waitForJobStatus(JobMaster jobMaster, long jobId, Status status) throws InterruptedException, TimeoutException {
        return JobTestUtils.waitForJobStatus(jobMaster, jobId, Sets.newHashSet((Object[])new Status[]{status}));
    }

    public static JobInfo waitForJobStatus(JobMaster jobMaster, long jobId, Set<Status> statuses) throws InterruptedException, TimeoutException {
        AtomicReference singleton = new AtomicReference();
        AtomicReference jobStatus = new AtomicReference();
        try {
            CommonUtils.waitFor((String)String.format("job %d to be one of status %s", jobId, Arrays.toString(statuses.toArray())), () -> {
                try {
                    JobInfo info = jobMaster.getStatus(jobId);
                    jobStatus.set(info.toString());
                    if (statuses.contains(info.getStatus())) {
                        singleton.set(info);
                    }
                    return statuses.contains(info.getStatus());
                }
                catch (JobDoesNotExistException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(30000L));
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("%s, %s", e.getMessage(), jobStatus.toString()));
        }
        return (JobInfo)singleton.get();
    }

    public static JobInfo waitForJobStatus(JobMaster jobMaster, long jobId, Set<Status> statuses, int timeout) throws InterruptedException, TimeoutException {
        AtomicReference singleton = new AtomicReference();
        CommonUtils.waitFor((String)String.format("job %d to be one of status %s", jobId, Arrays.toString(statuses.toArray())), () -> {
            try {
                JobInfo info = jobMaster.getStatus(jobId);
                if (statuses.contains(info.getStatus())) {
                    singleton.set(info);
                }
                return statuses.contains(info.getStatus());
            }
            catch (JobDoesNotExistException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)(timeout * 1000)));
        return (JobInfo)singleton.get();
    }

    private JobTestUtils() {
    }
}

