/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.workflow.composite;

import alluxio.job.JobConfig;
import alluxio.job.JobIntegrationTest;
import alluxio.job.SleepJobConfig;
import alluxio.job.plan.NoopPlanConfig;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.job.workflow.composite.CompositeConfig;
import com.google.common.collect.Lists;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CompositeIntegrationTest
extends JobIntegrationTest {
    @Test
    public void simpleTest() throws Exception {
        CompositeConfig config = new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new SleepJobConfig(1L), new SleepJobConfig(1L)}), Boolean.valueOf(false));
        this.waitForJobToFinish(this.mJobMaster.run((JobConfig)config));
    }

    @Test
    public void nestedTest() throws Exception {
        CompositeConfig config = new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new SleepJobConfig(2L), new SleepJobConfig(3L)}), Boolean.valueOf(false)), new SleepJobConfig(1L)}), Boolean.valueOf(true));
        long jobId = this.mJobMaster.run((JobConfig)config);
        this.waitForJobToFinish(jobId);
        JobInfo status = this.mJobMaster.getStatus(jobId);
        Assert.assertEquals((Object)Status.COMPLETED, (Object)status.getStatus());
        List children = status.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        JobInfo child0 = (JobInfo)children.get(0);
        Assert.assertEquals((Object)child0, (Object)this.mJobMaster.getStatus(((JobInfo)children.get(0)).getId()));
        Assert.assertEquals((Object)Status.COMPLETED, (Object)child0.getStatus());
        Assert.assertEquals((long)2L, (long)child0.getChildren().size());
        JobInfo child1 = (JobInfo)children.get(1);
        Assert.assertEquals((Object)child1, (Object)this.mJobMaster.getStatus(((JobInfo)children.get(1)).getId()));
        Assert.assertEquals((Object)Status.COMPLETED, (Object)child1.getStatus());
        Assert.assertEquals((long)1L, (long)child1.getChildren().size());
    }

    @Test
    public void waitSequential() throws Exception {
        CompositeConfig config = new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new SleepJobConfig(1000000L), new SleepJobConfig(1L)}), Boolean.valueOf(true));
        long jobId = this.mJobMaster.run((JobConfig)config);
        JobInfo status = this.mJobMaster.getStatus(jobId);
        Assert.assertEquals((Object)Status.RUNNING, (Object)status.getStatus());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
    }

    @Test
    public void waitParallel() throws Exception {
        CompositeConfig config = new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{new SleepJobConfig(1000000L), new SleepJobConfig(1L)}), Boolean.valueOf(false));
        long jobId = this.mJobMaster.run((JobConfig)config);
        JobInfo status = this.mJobMaster.getStatus(jobId);
        Assert.assertEquals((Object)Status.RUNNING, (Object)status.getStatus());
        Assert.assertEquals((long)2L, (long)status.getChildren().size());
    }

    @Test
    public void testCompositeDoNothing() throws Exception {
        NoopPlanConfig jobConfig = new NoopPlanConfig();
        long jobId = this.mJobMaster.run((JobConfig)new CompositeConfig(Lists.newArrayList((Object[])new JobConfig[]{jobConfig}), Boolean.valueOf(true)));
        this.waitForJobToFinish(jobId);
    }
}

