/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.auth;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.PermissionDeniedException;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.GetStatusContext;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.user.TestUserState;
import alluxio.security.user.UserState;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.master.FsMasterResource;
import alluxio.testutils.master.MasterTestUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="pending on the perm features in dora")
public final class ClusterInitializationIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private static final String SUPER_USER = "alluxio";
    private static final String USER = "jack";
    private static final AlluxioURI ROOT = new AlluxioURI("/");
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build().setProperty(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.SIMPLE).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_ENABLED, true);

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.login.username", "alluxio"})
    public void startCluster() throws Exception {
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient();
        URIStatus status = fs.getStatus(ROOT);
        Assert.assertEquals((Object)SUPER_USER, (Object)status.getOwner());
        Assert.assertEquals((long)493L, (long)status.getMode());
        Assert.assertEquals((long)0L, (long)fs.listStatus(new AlluxioURI("/")).size());
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.login.username", "alluxio"})
    public void recoverClusterSuccess() throws Exception {
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient();
        fs.createFile(new AlluxioURI("/testFile")).close();
        this.mLocalAlluxioClusterResource.get().stopFS();
        try (FsMasterResource masterResource = MasterTestUtils.createLeaderFileSystemMasterFromJournal();){
            FileSystemMaster fileSystemMaster = (FileSystemMaster)masterResource.getRegistry().get(FileSystemMaster.class);
            AuthenticatedClientUser.set((String)SUPER_USER);
            Assert.assertEquals((Object)SUPER_USER, (Object)fileSystemMaster.getFileInfo(new AlluxioURI("/testFile"), GetStatusContext.defaults()).getOwner());
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.login.username", "alluxio"})
    public void recoverClusterFail() throws Exception {
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient();
        fs.createFile(new AlluxioURI("/testFile")).close();
        this.mLocalAlluxioClusterResource.get().stopFS();
        this.mThrown.expect(PermissionDeniedException.class);
        this.mThrown.expectMessage(ExceptionMessage.PERMISSION_DENIED.getMessage(new Object[]{"Unauthorized user on root"}));
        MasterTestUtils.createLeaderFileSystemMasterFromJournal((UserState)new TestUserState(USER, Configuration.global())).close();
    }
}

