/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.auth;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.master.MasterClientContext;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.group.GroupMappingService;
import alluxio.security.user.TestUserState;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.FileSystemOptionsUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.sasl.AuthenticationException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class MasterClientAuthenticationIntegrationTest
extends BaseIntegrationTest {
    private static final String SUPERGROUP = "supergroup";
    private static final String NONSUPER = "nonsuper";
    private static final String SUPERUSER = "alluxio";
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.SECURITY_GROUP_MAPPING_CLASS, UserGroupsMapping.class.getName()).setProperty(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_SUPERGROUP, "supergroup").build();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.authentication.type", "NOSASL", "alluxio.security.authorization.permission.enabled", "false"})
    public void noAuthenticationOpenClose() throws Exception {
        this.authenticationOperationTest("/file-nosasl");
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.authentication.type", "SIMPLE"})
    public void simpleAuthenticationOpenClose() throws Exception {
        this.authenticationOperationTest("/file-simple");
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.authentication.type", "CUSTOM", "alluxio.security.authentication.custom.provider.class", "alluxio.server.auth.MasterClientAuthenticationIntegrationTest$NameMatchAuthenticationProvider", "alluxio.security.login.username", "alluxio"})
    public void customAuthenticationOpenClose() throws Exception {
        this.authenticationOperationTest("/file-custom");
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.authentication.type", "CUSTOM", "alluxio.security.authentication.custom.provider.class", "alluxio.server.auth.MasterClientAuthenticationIntegrationTest$NameMatchAuthenticationProvider", "alluxio.security.login.username", "alluxio"})
    public void customAuthenticationDenyConnect() throws Exception {
        TestUserState s = new TestUserState("no-alluxio", Configuration.global());
        try (FileSystemMasterClient masterClient = FileSystemMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((Subject)s.getSubject(), (AlluxioConfiguration)Configuration.global())).build());){
            Assert.assertFalse((boolean)masterClient.isConnected());
            this.mThrown.expect(UnauthenticatedException.class);
            masterClient.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.authentication.type", "SIMPLE"})
    public void simpleAuthenticationIsolatedClassLoader() throws Exception {
        FileSystemMasterClient masterClient = FileSystemMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        Assert.assertFalse((boolean)masterClient.isConnected());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader isolatedClassLoader = contextClassLoader instanceof URLClassLoader ? new URLClassLoader(((URLClassLoader)contextClassLoader).getURLs(), null) : new URLClassLoader(new URL[0], contextClassLoader);
        Thread.currentThread().setContextClassLoader(isolatedClassLoader);
        try {
            masterClient.connect();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        Assert.assertTrue((boolean)masterClient.isConnected());
        masterClient.close();
    }

    private void authenticationOperationTest(String filename) throws Exception {
        TestUserState s = new TestUserState(SUPERUSER, Configuration.global());
        FileSystemMasterClient masterClient = FileSystemMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((Subject)s.getSubject(), (AlluxioConfiguration)Configuration.global())).build());
        Assert.assertFalse((boolean)masterClient.isConnected());
        masterClient.connect();
        Assert.assertTrue((boolean)masterClient.isConnected());
        masterClient.createFile(new AlluxioURI(filename), FileSystemOptionsUtils.createFileDefaults((AlluxioConfiguration)Configuration.global()));
        Assert.assertNotNull((Object)masterClient.getStatus(new AlluxioURI(filename), FileSystemOptionsUtils.getStatusDefaults((AlluxioConfiguration)Configuration.global())));
        masterClient.disconnect();
        masterClient.close();
    }

    public static class UserGroupsMapping
    implements GroupMappingService {
        public List<String> getGroups(String user) throws IOException {
            if (user.equals(MasterClientAuthenticationIntegrationTest.SUPERUSER)) {
                return Collections.singletonList(MasterClientAuthenticationIntegrationTest.SUPERGROUP);
            }
            return Collections.singletonList(MasterClientAuthenticationIntegrationTest.NONSUPER);
        }
    }

    public static class NameMatchAuthenticationProvider
    implements AuthenticationProvider {
        public static final String FULL_CLASS_NAME = "alluxio.server.auth.MasterClientAuthenticationIntegrationTest$NameMatchAuthenticationProvider";

        public void authenticate(String user, String password) throws AuthenticationException {
            if (!user.equals(MasterClientAuthenticationIntegrationTest.SUPERUSER)) {
                throw new AuthenticationException("Only allow the user alluxio to connect");
            }
        }
    }
}

