/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.configuration;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.meta.MetaMasterClient;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ConfigStatus;
import alluxio.grpc.Scope;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.wire.ConfigCheckReport;
import alluxio.wire.InconsistentProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ConfigCheckerIntegrationTest
extends BaseIntegrationTest {
    private static final int WAIT_TIMEOUT_MS = 60000;
    private static final int TEST_NUM_MASTERS = 2;
    private static final int TEST_NUM_WORKERS = 2;
    public MultiProcessCluster mCluster;

    @After
    public void after() throws Exception {
        this.mCluster.destroy();
    }

    @Test
    public void multiMasters() throws Exception {
        PropertyKey key = PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS;
        Map<Integer, Map<PropertyKey, String>> masterProperties = this.generatePropertyWithDifferentValues(2, key);
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.CONFIG_CHECKER_MULTI_MASTERS).setClusterName("ConfigCheckerMultiMastersTest").setNumMasters(2).setNumWorkers(0).setMasterProperties(masterProperties).build();
        this.mCluster.start();
        ConfigCheckReport report = this.getReport();
        Assert.assertEquals((Object)(this.mCluster.getDeployMode().equals((Object)MultiProcessCluster.DeployMode.ZOOKEEPER_HA) ? ConfigStatus.WARN : ConfigStatus.FAILED), (Object)report.getConfigStatus());
        Assert.assertThat((Object)report.getConfigWarns().toString(), (Matcher)CoreMatchers.containsString((String)key.getName()));
        this.mCluster.notifySuccess();
    }

    @Test
    public void multiMastersEmbeddedHA() throws Exception {
        PropertyKey key = PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS;
        Map<Integer, Map<PropertyKey, String>> masterProperties = this.generatePropertyWithDifferentValues(2, key);
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.CONFIG_CHECKER_MULTI_MASTERS_EMBEDDED_HA).setClusterName("ConfigCheckerMultiMastersEmbeddedHATest").setNumMasters(2).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).setMasterProperties(masterProperties).build();
        this.mCluster.start();
        ConfigCheckReport report = this.getReport();
        Assert.assertEquals((Object)ConfigStatus.FAILED, (Object)report.getConfigStatus());
        Assert.assertThat((Object)report.getConfigWarns().toString(), (Matcher)CoreMatchers.containsString((String)key.getName()));
        this.mCluster.notifySuccess();
    }

    @Test
    public void multiWorkers() throws Exception {
        PropertyKey key = PropertyKey.WORKER_FREE_SPACE_TIMEOUT;
        Map<Integer, Map<PropertyKey, String>> workerProperties = this.generatePropertyWithDifferentValues(2, key);
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.CONFIG_CHECKER_MULTI_WORKERS).setClusterName("ConfigCheckerMultiWorkersTest").setNumMasters(1).setNumWorkers(2).setWorkerProperties(workerProperties).build();
        this.mCluster.start();
        ConfigCheckReport report = this.getReport();
        Assert.assertEquals((Object)ConfigStatus.WARN, (Object)report.getConfigStatus());
        Assert.assertThat((Object)report.getConfigWarns().toString(), (Matcher)CoreMatchers.containsString((String)key.getName()));
        this.mCluster.notifySuccess();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="revisit HA")
    public void multiNodes() throws Exception {
        PropertyKey key = PropertyKey.UNDERFS_WEB_CONNECTION_TIMEOUT;
        Map<Integer, Map<PropertyKey, String>> properties = this.generatePropertyWithDifferentValues(4, key);
        Map<Integer, Map> masterProperties = properties.entrySet().stream().filter(entry -> (Integer)entry.getKey() < 2).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Integer, Map> workerProperties = properties.entrySet().stream().filter(entry -> (Integer)entry.getKey() >= 2).collect(Collectors.toMap(entry -> (Integer)entry.getKey() - 2, Map.Entry::getValue));
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.CONFIG_CHECKER_MULTI_NODES).setClusterName("ConfigCheckerMultiNodesTest").setNumMasters(2).setNumWorkers(2).setMasterProperties(masterProperties).setWorkerProperties(workerProperties).build();
        this.mCluster.start();
        ConfigCheckReport report = this.getReport();
        Assert.assertEquals((Object)ConfigStatus.FAILED, (Object)report.getConfigStatus());
        Assert.assertThat((Object)report.getConfigErrors().toString(), (Matcher)CoreMatchers.containsString((String)key.getName()));
        this.mCluster.notifySuccess();
    }

    @Test
    public void unsetVsSet() throws Exception {
        ImmutableMap masterProperties = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_OPTION, (Object)"option"));
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.CONFIG_CHECKER_UNSET_VS_SET).setClusterName("ConfigCheckerUnsetVsSet").setNumMasters(2).setNumWorkers(0).setMasterProperties((Map)masterProperties).build();
        this.mCluster.start();
        ConfigCheckReport report = this.getReport();
        Map errors = report.getConfigErrors();
        Assert.assertTrue((boolean)errors.containsKey(Scope.MASTER));
        if (this.mCluster.getDeployMode().equals((Object)MultiProcessCluster.DeployMode.ZOOKEEPER_HA)) {
            Assert.assertEquals((long)1L, (long)((List)errors.get(Scope.MASTER)).size());
            InconsistentProperty property = (InconsistentProperty)((List)errors.get(Scope.MASTER)).get(0);
            Assert.assertEquals((Object)PropertyKey.MASTER_MOUNT_TABLE_ROOT_OPTION.getName(), (Object)property.getName());
            Assert.assertTrue((boolean)property.getValues().containsKey(Optional.of("option")));
            Assert.assertTrue((boolean)property.getValues().containsKey(Optional.empty()));
        } else {
            Assert.assertEquals((long)2L, (long)((List)errors.get(Scope.MASTER)).size());
            Assert.assertThat((Object)report.getConfigErrors().toString(), (Matcher)CoreMatchers.containsString((String)PropertyKey.MASTER_MOUNT_TABLE_ROOT_OPTION.getName()));
        }
        this.mCluster.notifySuccess();
    }

    private ConfigCheckReport getReport() throws Exception {
        this.mCluster.waitForAllNodesRegistered(60000);
        MetaMasterClient client = this.mCluster.getMetaMasterClient();
        return client.getConfigReport();
    }

    private Map<Integer, Map<PropertyKey, String>> generatePropertyWithDifferentValues(int nodeNum, PropertyKey key) {
        HashMap<Integer, Map<PropertyKey, String>> properties = new HashMap<Integer, Map<PropertyKey, String>>();
        for (int i = 0; i < nodeNum; ++i) {
            HashMap<PropertyKey, String> prop = new HashMap<PropertyKey, String>();
            prop.put(key, Configuration.getMs((PropertyKey)key) / 1000L + (long)i + "sec");
            properties.put(i, prop);
        }
        return properties;
    }
}

