/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.FileAlreadyCompletedException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.master.MultiMasterLocalAlluxioCluster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.CompleteFileContext;
import alluxio.master.file.contexts.CreateDirectoryContext;
import alluxio.master.file.contexts.CreateFileContext;
import alluxio.master.file.contexts.DeleteContext;
import alluxio.master.file.contexts.RenameContext;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileInfo;
import alluxio.wire.OperationId;
import com.google.common.collect.ImmutableMap;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="revisit HA")
public final class FileSystemMasterFaultToleranceIntegrationTest
extends BaseIntegrationTest {
    private static final int CLUSTER_WAIT_TIMEOUT_MS = 120000;
    private static final String TEST_USER = "test";
    private MultiMasterLocalAlluxioCluster mMultiMasterLocalAlluxioCluster;
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    @Rule
    public TestName mTestName = new TestName();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Parameterized.Parameter
    public ImmutableMap<PropertyKey, Object> mParameterizedConfigMap;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new ImmutableMap.Builder().put((Object)PropertyKey.MASTER_FILE_SYSTEM_MERGE_INODE_JOURNALS, (Object)false).build()}, {new ImmutableMap.Builder().put((Object)PropertyKey.MASTER_FILE_SYSTEM_MERGE_INODE_JOURNALS, (Object)true).build()});
    }

    @Before
    public final void before() throws Exception {
        this.mMultiMasterLocalAlluxioCluster = new MultiMasterLocalAlluxioCluster(2, 1);
        this.mMultiMasterLocalAlluxioCluster.initConfiguration(IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName()));
        Configuration.set((PropertyKey)PropertyKey.USER_RPC_RETRY_MAX_DURATION, (Object)"60sec");
        Configuration.set((PropertyKey)PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS, (Object)"1sec");
        Configuration.set((PropertyKey)PropertyKey.NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT, (Object)"30sec");
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, (Object)"0sec");
        Configuration.set((PropertyKey)PropertyKey.SECURITY_LOGIN_USERNAME, (Object)TEST_USER);
        Configuration.set((PropertyKey)PropertyKey.MASTER_FILE_SYSTEM_MERGE_INODE_JOURNALS, (Object)false);
        for (Map.Entry entry : this.mParameterizedConfigMap.entrySet()) {
            Configuration.set((PropertyKey)((PropertyKey)entry.getKey()), entry.getValue());
        }
        this.mMultiMasterLocalAlluxioCluster.start();
    }

    @After
    public final void after() throws Exception {
        this.mMultiMasterLocalAlluxioCluster.stop();
        Configuration.reloadProperties();
    }

    @Test
    public void syncMetadataUFSFailOver() throws Exception {
        int i;
        String ufsPath = this.mFolder.newFolder().getAbsoluteFile().toString();
        String ufsUri = "file://" + ufsPath;
        MountPOptions options = MountPOptions.newBuilder().build();
        FileSystem client = this.mMultiMasterLocalAlluxioCluster.getClient();
        AlluxioURI mountPath = new AlluxioURI("/mnt1");
        client.mount(mountPath, new AlluxioURI(ufsUri), options);
        String fileName = "someFile";
        String contents = "contents";
        for (i = 0; i < 100; ++i) {
            try (FileWriter fw = new FileWriter(Paths.get(PathUtils.concatPath((Object)ufsPath, (Object)(fileName + i)), new String[0]).toString());){
                fw.write(contents + i);
                continue;
            }
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)(contents + i), (Object)IOUtils.toString((InputStream)client.openFile(mountPath.join(fileName + i)), (Charset)Charset.defaultCharset()));
        }
        this.mMultiMasterLocalAlluxioCluster.stopLeader();
        this.mMultiMasterLocalAlluxioCluster.waitForNewMaster(120000);
        this.mMultiMasterLocalAlluxioCluster.waitForWorkersRegistered(120000);
        client = this.mMultiMasterLocalAlluxioCluster.getClient();
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)(contents + i), (Object)IOUtils.toString((InputStream)client.openFile(mountPath.join(fileName + i)), (Charset)Charset.defaultCharset()));
        }
    }

    @Test
    public void partitionTolerantCreateFile() throws Exception {
        AlluxioURI testPath1 = new AlluxioURI("/testPath1");
        CreateFileContext context = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        CreateFileContext context2 = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        FileSystemMaster leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.createFile(testPath1, context);
        FileInfo fileInfo = leadingFsMaster.createFile(testPath1, context);
        Assert.assertEquals((long)fileInfo.getFileId(), (long)leadingFsMaster.getFileId(testPath1));
        Assert.assertThrows(FileAlreadyExistsException.class, () -> leadingFsMaster.createFile(testPath1, context2));
        this.mMultiMasterLocalAlluxioCluster.stopLeader();
        this.mMultiMasterLocalAlluxioCluster.waitForNewMaster(120000);
        this.mAuthenticatedUser.resetUser();
        leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        fileInfo = leadingFsMaster.createFile(testPath1, context);
        Assert.assertEquals((long)fileInfo.getFileId(), (long)leadingFsMaster.getFileId(testPath1));
        Assert.assertThrows(FileAlreadyExistsException.class, () -> leadingFsMaster.createFile(testPath1, context2));
    }

    @Test
    public void partitionTolerantCompleteFile() throws Exception {
        AlluxioURI testPath1 = new AlluxioURI("/testPath1");
        CompleteFileContext context = CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        CompleteFileContext context2 = CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        FileSystemMaster leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.createFile(testPath1, CreateFileContext.defaults());
        leadingFsMaster.completeFile(testPath1, context);
        leadingFsMaster.completeFile(testPath1, context);
        Assert.assertThrows(FileAlreadyCompletedException.class, () -> leadingFsMaster.completeFile(testPath1, context2));
        this.mMultiMasterLocalAlluxioCluster.stopLeader();
        this.mMultiMasterLocalAlluxioCluster.waitForNewMaster(120000);
        this.mAuthenticatedUser.resetUser();
        leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.completeFile(testPath1, context);
        Assert.assertThrows(FileAlreadyCompletedException.class, () -> leadingFsMaster.completeFile(testPath1, context2));
    }

    @Test
    public void partitionTolerantDeleteFile() throws Exception {
        AlluxioURI testPath1 = new AlluxioURI("/testPath1");
        DeleteContext context = DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        DeleteContext context2 = DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        FileSystemMaster leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.createFile(testPath1, CreateFileContext.defaults());
        leadingFsMaster.completeFile(testPath1, CompleteFileContext.defaults());
        leadingFsMaster.delete(testPath1, context);
        leadingFsMaster.delete(testPath1, context);
        Assert.assertThrows(FileDoesNotExistException.class, () -> leadingFsMaster.delete(testPath1, context2));
        this.mMultiMasterLocalAlluxioCluster.stopLeader();
        this.mMultiMasterLocalAlluxioCluster.waitForNewMaster(120000);
        this.mAuthenticatedUser.resetUser();
        leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.delete(testPath1, context);
        Assert.assertThrows(FileDoesNotExistException.class, () -> leadingFsMaster.delete(testPath1, context2));
    }

    @Test
    public void partitionTolerantDeleteDirectory() throws Exception {
        AlluxioURI testPath1 = new AlluxioURI("/testPath1");
        DeleteContext context = DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        DeleteContext context2 = DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        FileSystemMaster leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.createDirectory(testPath1, CreateDirectoryContext.defaults());
        leadingFsMaster.delete(testPath1, context);
        leadingFsMaster.delete(testPath1, context);
        Assert.assertThrows(FileDoesNotExistException.class, () -> leadingFsMaster.delete(testPath1, context2));
        this.mMultiMasterLocalAlluxioCluster.stopLeader();
        this.mMultiMasterLocalAlluxioCluster.waitForNewMaster(120000);
        this.mAuthenticatedUser.resetUser();
        leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.delete(testPath1, context);
        Assert.assertThrows(FileDoesNotExistException.class, () -> leadingFsMaster.delete(testPath1, context2));
    }

    @Test
    public void partitionTolerantRename() throws Exception {
        AlluxioURI testPath1 = new AlluxioURI("/testPath1");
        AlluxioURI testPath2 = new AlluxioURI("/testPath2");
        RenameContext context = RenameContext.mergeFrom((RenamePOptions.Builder)RenamePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        RenameContext context2 = RenameContext.mergeFrom((RenamePOptions.Builder)RenamePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto())));
        FileSystemMaster leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.createDirectory(testPath1, CreateDirectoryContext.defaults());
        leadingFsMaster.rename(testPath1, testPath2, context);
        leadingFsMaster.rename(testPath1, testPath2, context);
        Assert.assertThrows(FileDoesNotExistException.class, () -> leadingFsMaster.rename(testPath1, testPath2, context2));
        this.mMultiMasterLocalAlluxioCluster.stopLeader();
        this.mMultiMasterLocalAlluxioCluster.waitForNewMaster(120000);
        this.mAuthenticatedUser.resetUser();
        leadingFsMaster = (FileSystemMaster)this.mMultiMasterLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        leadingFsMaster.rename(testPath1, testPath2, context);
        Assert.assertThrows(FileDoesNotExistException.class, () -> leadingFsMaster.rename(testPath1, testPath2, context2));
    }
}

