/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.master.file.contexts.CreateDirectoryContext;
import alluxio.master.file.contexts.CreateFileContext;
import alluxio.master.file.contexts.ListStatusContext;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.security.authorization.Mode;
import alluxio.server.ft.journal.raft.EmbeddedJournalIntegrationTestBase;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FileSystemMasterMergeJournalContextIntegrationTest
extends EmbeddedJournalIntegrationTestBase {
    private static final int GET_MASTER_TIMEOUT_MS = 60000;
    private static final int NUM_MASTERS = 3;
    private static final int NUM_WORKERS = 0;

    @Ignore(value="Dora does not support setAttribute RECURSIVELY")
    @Test
    public void testForceFlush() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_FAILOVER).setClusterName("EmbeddedJournalFaultTolerance_failover").setNumMasters(3).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        AlluxioURI testPath1 = new AlluxioURI("/testPath1");
        SetAttributePOptions setAttributeContext = SetAttributePOptions.newBuilder().setRecursive(true).setMode(new Mode(511).toProto()).build();
        int mergeJournalContextMaxEntries = Configuration.getInt((PropertyKey)PropertyKey.MASTER_RECURSIVE_OPERATION_JOURNAL_FORCE_FLUSH_MAX_ENTRIES);
        FileSystem fileSystem = this.mCluster.getFileSystemClient();
        fileSystem.createDirectory(testPath1, ((CreateDirectoryPOptions.Builder)CreateDirectoryContext.defaults().getOptions()).build());
        for (int i = 0; i < mergeJournalContextMaxEntries * 3; ++i) {
            AlluxioURI path = new AlluxioURI("/testPath1/" + i);
            fileSystem.createFile(path, ((CreateFilePOptions.Builder)CreateFileContext.defaults().getOptions()).build()).close();
        }
        fileSystem.setAttribute(testPath1, setAttributeContext);
        List fileInfo = fileSystem.listStatus(testPath1, ((ListStatusPOptions.Builder)ListStatusContext.defaults().getOptions()).build());
        Assert.assertEquals((long)(mergeJournalContextMaxEntries * 3), (long)fileInfo.size());
        fileInfo.forEach(it -> Assert.assertEquals((long)511L, (long)it.getMode()));
        this.mCluster.waitForAndKillPrimaryMaster(60000);
        this.mCluster.getPrimaryMasterIndex(60000);
        fileSystem = this.mCluster.getFileSystemClient();
        fileInfo = fileSystem.listStatus(testPath1, ((ListStatusPOptions.Builder)ListStatusContext.defaults().getOptions()).build());
        Assert.assertEquals((long)(mergeJournalContextMaxEntries * 3), (long)fileInfo.size());
        fileInfo.forEach(it -> Assert.assertEquals((long)511L, (long)it.getMode()));
        this.mCluster.notifySuccess();
    }
}

