/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft;

import alluxio.AlluxioURI;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.MultiMasterLocalAlluxioCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.underfs.delegating.DelegatingUnderFileSystem;
import alluxio.testutils.underfs.delegating.DelegatingUnderFileSystemFactory;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.CommonUtils;
import com.google.common.io.Files;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="revisit HA")
public final class MasterFailoverIntegrationTest
extends BaseIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(MasterFailoverIntegrationTest.class);
    private static final String LOCAL_UFS_PATH = Files.createTempDir().getAbsolutePath();
    private static final long DELETE_DELAY = 5000L;
    private MultiMasterLocalAlluxioCluster mMultiMasterLocalAlluxioCluster;
    private FileSystem mFileSystem;
    private static final UnderFileSystem UFS = new DelegatingUnderFileSystem(UnderFileSystem.Factory.create((String)LOCAL_UFS_PATH, (AlluxioConfiguration)Configuration.global())){

        @Override
        public boolean deleteDirectory(String path) throws IOException {
            CommonUtils.sleepMs((long)5000L);
            return this.mUfs.deleteDirectory(path);
        }

        @Override
        public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
            CommonUtils.sleepMs((long)5000L);
            return this.mUfs.deleteDirectory(path, options);
        }
    };
    @Rule
    public TestName mTestName = new TestName();
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new DelegatingUnderFileSystemFactory(UFS));

    @Before
    public final void before() throws Exception {
        this.mMultiMasterLocalAlluxioCluster = new MultiMasterLocalAlluxioCluster(2);
        this.mMultiMasterLocalAlluxioCluster.initConfiguration(IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName()));
        Configuration.set((PropertyKey)PropertyKey.USER_RPC_RETRY_MAX_DURATION, (Object)"60sec");
        Configuration.set((PropertyKey)PropertyKey.USER_RPC_RETRY_MAX_SLEEP_MS, (Object)"1sec");
        Configuration.set((PropertyKey)PropertyKey.NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT, (Object)"30sec");
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_TAILER_SHUTDOWN_QUIET_WAIT_TIME_MS, (Object)"0sec");
        Configuration.set((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, (Object)("delegating://" + LOCAL_UFS_PATH));
        this.mMultiMasterLocalAlluxioCluster.start();
        this.mFileSystem = this.mMultiMasterLocalAlluxioCluster.getClient();
    }

    @After
    public final void after() throws Exception {
        this.mMultiMasterLocalAlluxioCluster.stop();
    }

    @Test
    public void failoverJournalFencingTest() throws Exception {
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        DeleteThread deleteThread = new DeleteThread(dir);
        deleteThread.start();
        Thread.sleep(500L);
        this.mMultiMasterLocalAlluxioCluster.stopZk();
        Thread.sleep(10000L);
        this.mMultiMasterLocalAlluxioCluster.restartZk();
        deleteThread.join();
        Assert.assertFalse((boolean)this.mFileSystem.exists(dir));
        this.mMultiMasterLocalAlluxioCluster.restartMasters();
        this.mFileSystem = this.mMultiMasterLocalAlluxioCluster.getClient();
        Assert.assertEquals((long)0L, (long)this.mFileSystem.listStatus(new AlluxioURI("/")).size());
    }

    private class DeleteThread
    extends Thread {
        public final AlluxioURI mDir;

        public DeleteThread(AlluxioURI dir) {
            this.mDir = dir;
        }

        @Override
        public void run() {
            try {
                LOG.info("Starting to delete {}", (Object)this.mDir);
                MasterFailoverIntegrationTest.this.mFileSystem.delete(this.mDir);
                LOG.info("Deleted {}", (Object)this.mDir);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

