/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.exception.BlockInfoException;
import alluxio.grpc.WritePType;
import alluxio.master.AlluxioMasterProcess;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.block.BlockMaster;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerNetAddress;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="BlockMaster is deprecated")
public class BlockMasterJournalIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private LocalAlluxioCluster mCluster;

    @Before
    public void before() {
        this.mCluster = this.mClusterResource.get();
    }

    @Test
    public void journalBlockCreation() throws Exception {
        FileSystem fs = this.mCluster.getClient();
        BlockMaster blockMaster = (BlockMaster)this.mCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(BlockMaster.class);
        AlluxioURI file = new AlluxioURI("/test");
        FileSystemTestUtils.createByteFile((FileSystem)fs, (AlluxioURI)file, (WritePType)WritePType.MUST_CACHE, (int)10);
        URIStatus status = fs.getStatus(file);
        Long blockId = (Long)status.getBlockIds().get(0);
        Assert.assertNotNull((Object)blockMaster.getBlockInfo(blockId.longValue()));
        this.mCluster.stopMasters();
        this.mCluster.startMasters();
        AlluxioMasterProcess masterProcess = this.mCluster.getLocalAlluxioMaster().getMasterProcess();
        CommonUtils.waitFor((String)"Master up", () -> !masterProcess.isInSafeMode());
        Assert.assertNotNull((Object)((BlockMaster)masterProcess.getMaster(BlockMaster.class)).getBlockInfo(blockId.longValue()));
    }

    @Test
    public void journalBlockDeletion() throws Exception {
        FileSystem fs = this.mCluster.getClient();
        BlockMaster blockMaster = (BlockMaster)this.mCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(BlockMaster.class);
        AlluxioURI file = new AlluxioURI("/test");
        FileSystemTestUtils.createByteFile((FileSystem)fs, (AlluxioURI)file, (WritePType)WritePType.MUST_CACHE, (int)10);
        URIStatus status = fs.getStatus(file);
        Long blockId = (Long)status.getBlockIds().get(0);
        Assert.assertNotNull((Object)blockMaster.getBlockInfo(blockId.longValue()));
        fs.delete(file);
        WorkerNetAddress workerAddress = this.mCluster.getWorkerAddress();
        try {
            blockMaster.getBlockInfo(blockId.longValue());
            Assert.fail((String)"Expected the block to be deleted");
        }
        catch (BlockInfoException blockInfoException) {
            // empty catch block
        }
        this.mCluster.stopMasters();
        this.mCluster.startMasters();
        AlluxioMasterProcess masterProcess = this.mCluster.getLocalAlluxioMaster().getMasterProcess();
        CommonUtils.waitFor((String)"Master up", () -> !masterProcess.isInSafeMode());
        try {
            ((BlockMaster)masterProcess.getMaster(BlockMaster.class)).getBlockInfo(blockId.longValue());
            Assert.fail((String)"Expected the block to be deleted after restart");
        }
        catch (BlockInfoException blockInfoException) {
            // empty catch block
        }
    }
}

