/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.ConfigurationRule;
import alluxio.client.WriteType;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.RetryHandlingBlockMasterClient;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.client.meta.MetaMasterClient;
import alluxio.client.meta.RetryHandlingMetaMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.BackupAbortedException;
import alluxio.exception.status.FailedPreconditionException;
import alluxio.grpc.BackupPOptions;
import alluxio.grpc.BackupPRequest;
import alluxio.grpc.BackupState;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.WritePType;
import alluxio.master.Master;
import alluxio.master.MasterClientContext;
import alluxio.master.NoopMaster;
import alluxio.master.journal.JournalReader;
import alluxio.master.journal.JournalType;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalLogWriter;
import alluxio.master.journal.ufs.UfsJournalReader;
import alluxio.master.metastore.MetastoreType;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.proto.journal.File;
import alluxio.proto.journal.Journal;
import alluxio.testutils.AlluxioOperationThread;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.util.CommonUtils;
import alluxio.util.URIUtils;
import alluxio.util.WaitForOptions;
import alluxio.wire.BackupStatus;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore(value="In Dora, Client does not use Master/Journal services.")
public final class JournalBackupIntegrationTest
extends BaseIntegrationTest {
    public MultiProcessCluster mCluster;
    private static final int GET_PRIMARY_INDEX_TIMEOUT_MS = 30000;
    private static final int PRIMARY_KILL_TIMEOUT_MS = 30000;
    private static final int WAIT_NODES_REGISTERED_MS = 30000;
    @Rule
    public ConfigurationRule mConf = new ConfigurationRule((Map)new HashMap<PropertyKey, Object>(){
        {
            this.put(PropertyKey.USER_METRICS_COLLECTION_ENABLED, false);
        }
    }, Configuration.modifiableGlobal());

    @After
    public void after() throws Exception {
        if (this.mCluster != null) {
            this.mCluster.destroy();
        }
    }

    @Test
    public void backupRestoreZk() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_ZK).setClusterName("backupRestoreZk").setNumMasters(3).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"3sec").addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreTest(true);
    }

    @Test
    public void backupRestoreMetastore_Heap() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_METASSTORE_HEAP).setClusterName("backupRestoreMetastore_Heap").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_METASTORE, (Object)MetastoreType.HEAP).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreMetaStoreTest();
    }

    @Test
    public void backupRestoreMetastore_Rocks() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_METASSTORE_ROCKS).setClusterName("backupRestoreMetastore_Rocks").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_METASTORE, (Object)MetastoreType.ROCKS).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreMetaStoreTest();
    }

    @Test
    public void backupRestoreMetastore_InodeRocksBlockHeap() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_METASSTORE_ROCKS).setClusterName("backupRestoreMetastore_InodeRocksBlockHeap").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_INODE_METASTORE, (Object)MetastoreType.ROCKS).addProperty(PropertyKey.MASTER_BLOCK_METASTORE, (Object)MetastoreType.HEAP).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreMetaStoreTest();
    }

    @Test
    public void backupRestoreMetastore_InodeHeapBlockRocks() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_METASSTORE_ROCKS).setClusterName("backupRestoreMetastore_InodeHeapBlockRocks").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_INODE_METASTORE, (Object)MetastoreType.HEAP).addProperty(PropertyKey.MASTER_BLOCK_METASTORE, (Object)MetastoreType.ROCKS).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreMetaStoreTest();
    }

    @Test
    public void emergencyBackup() throws Exception {
        this.emergencyBackupCore(1);
    }

    @Test
    public void emergencyBackupHA() throws Exception {
        this.emergencyBackupCore(3);
    }

    private void emergencyBackupCore(int numMasters) throws Exception {
        TemporaryFolder backupFolder = new TemporaryFolder();
        backupFolder.create();
        List ports1 = numMasters > 1 ? PortCoordination.BACKUP_EMERGENCY_HA_1 : PortCoordination.BACKUP_EMERGENCY_1;
        String clusterName1 = numMasters > 1 ? "emergencyBackup_HA_1" : "emergencyBackup_1";
        this.mCluster = MultiProcessCluster.newBuilder((List)ports1).setClusterName(clusterName1).setNumMasters(numMasters).setNumWorkers(0).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.MASTER_METASTORE, (Object)MetastoreType.ROCKS).addProperty(PropertyKey.MASTER_BACKUP_DIRECTORY, (Object)backupFolder.getRoot()).addProperty(PropertyKey.MASTER_JOURNAL_BACKUP_WHEN_CORRUPTED, (Object)true).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.mCluster.start();
        int numFiles = 10;
        for (int i = 0; i < 10; ++i) {
            this.mCluster.getFileSystemClient().createFile(new AlluxioURI("/normal-file-" + i));
        }
        this.mCluster.stopMasters();
        URI journalLocation = new URI(this.mCluster.getJournalDir());
        UfsJournal fsMaster = new UfsJournal(URIUtils.appendPathOrDie((URI)journalLocation, (String)"FileSystemMaster"), (Master)new NoopMaster(), 0L, Collections::emptySet);
        fsMaster.start();
        fsMaster.gainPrimacy();
        long nextSN = 0L;
        try (UfsJournalReader reader = new UfsJournalReader(fsMaster, true);){
            while (reader.advance() != JournalReader.State.DONE) {
                ++nextSN;
            }
        }
        var11_11 = null;
        try (UfsJournalLogWriter writer = new UfsJournalLogWriter(fsMaster, nextSN);){
            Journal.JournalEntry entry = Journal.JournalEntry.newBuilder().setSequenceNumber(nextSN).setDeleteFile(File.DeleteFileEntry.newBuilder().setId(4563728L).setPath("/nonexistant").build()).build();
            writer.write(entry);
            writer.flush();
        }
        catch (Throwable entry) {
            var11_11 = entry;
            throw entry;
        }
        this.mCluster.startMasters();
        CommonUtils.waitFor((String)"backup file(s) to be created automatically", () -> 2 * numMasters == Objects.requireNonNull(backupFolder.getRoot().list()).length, (WaitForOptions)WaitForOptions.defaults().setInterval(500).setTimeoutMs(30000L));
        List backupFiles = Arrays.stream((Object[])Objects.requireNonNull(backupFolder.getRoot().list())).filter(s -> s.endsWith(".gz")).collect(Collectors.toList());
        Assert.assertEquals((long)numMasters, (long)backupFiles.size());
        List ports2 = numMasters > 1 ? PortCoordination.BACKUP_EMERGENCY_HA_2 : PortCoordination.BACKUP_EMERGENCY_2;
        String clusterName2 = numMasters > 1 ? "emergencyBackup_HA_2" : "emergencyBackup_2";
        for (String backupFile : backupFiles) {
            this.mCluster = MultiProcessCluster.newBuilder((List)ports2).setClusterName(String.format("%s_%s", clusterName2, backupFile)).setNumMasters(numMasters).setNumWorkers(0).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.MASTER_METASTORE, (Object)MetastoreType.HEAP).addProperty(PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, (Object)Paths.get(backupFolder.getRoot().toString(), backupFile)).build();
            this.mCluster.start();
            for (int i = 0; i < 10; ++i) {
                boolean exists = this.mCluster.getFileSystemClient().exists(new AlluxioURI("/normal-file-" + i));
                Assert.assertTrue((boolean)exists);
            }
            this.mCluster.stopMasters();
            this.mCluster.notifySuccess();
        }
        backupFolder.delete();
    }

    @Test
    public void syncRootOnBackupRestore() throws Exception {
        this.syncLsTestCore(true);
    }

    @Test
    public void doNotSyncRootOnBackupRestore() throws Exception {
        this.syncLsTestCore(false);
    }

    private void syncLsTestCore(boolean syncRootOnRestore) throws Exception {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_SYNC_ON_RESTORE).setClusterName("syncRootOnBackupRestore").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_BACKUP_DIRECTORY, (Object)temporaryFolder.getRoot()).addProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)WriteType.CACHE_THROUGH).addProperty(PropertyKey.MASTER_JOURNAL_SYNC_ROOT_AFTER_INIT_FROM_BACKUP, (Object)syncRootOnRestore).addProperty(PropertyKey.USER_FILE_METADATA_LOAD_TYPE, (Object)LoadMetadataPType.NEVER).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.mCluster.start();
        this.mCluster.getFileSystemClient().createDirectory(new AlluxioURI("/in_backup"));
        BackupStatus backup = this.mCluster.getMetaMasterClient().backup(BackupPRequest.getDefaultInstance());
        UUID id = backup.getBackupId();
        while (backup.getState() != BackupState.Completed) {
            backup = this.mCluster.getMetaMasterClient().getBackupStatus(id);
        }
        this.mCluster.getFileSystemClient().createDirectory(new AlluxioURI("/NOT_in_backup"));
        this.mCluster.stopMasters();
        this.mCluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_FOLDER, temporaryFolder.newFolder().getAbsolutePath());
        this.mCluster.updateMasterConf(PropertyKey.MASTER_METASTORE_DIR, temporaryFolder.newFolder().getAbsolutePath());
        this.mCluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, backup.getBackupUri().getPath());
        this.mCluster.startMasters();
        List statuses = this.mCluster.getFileSystemClient().listStatus(new AlluxioURI("/"));
        int expected = syncRootOnRestore ? 2 : 1;
        Assert.assertEquals((long)expected, (long)statuses.size());
        this.mCluster.notifySuccess();
        temporaryFolder.delete();
    }

    @Test
    public void syncContentsOnBackupRestore() throws Exception {
        this.syncContentsTestCore(true);
    }

    @Test
    public void doNotSyncContentsOnBackupRestore() throws Exception {
        this.syncContentsTestCore(false);
    }

    private void syncContentsTestCore(boolean syncRootOnRestore) throws Exception {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_CONTENT_ON_RESTORE).setClusterName("syncContentOnBackupRestore").setNumMasters(1).setNumWorkers(1).addProperty(PropertyKey.MASTER_BACKUP_DIRECTORY, (Object)temporaryFolder.getRoot()).addProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, (Object)WriteType.CACHE_THROUGH).addProperty(PropertyKey.MASTER_JOURNAL_SYNC_ROOT_AFTER_INIT_FROM_BACKUP, (Object)syncRootOnRestore).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.mCluster.start();
        AlluxioURI f = new AlluxioURI("/in_backup");
        String originalData = "data";
        try (FileOutStream inBackup = this.mCluster.getFileSystemClient().createFile(f);){
            inBackup.write(originalData.getBytes());
        }
        BackupStatus backup = this.mCluster.getMetaMasterClient().backup(BackupPRequest.getDefaultInstance());
        UUID id = backup.getBackupId();
        while (backup.getState() != BackupState.Completed) {
            backup = this.mCluster.getMetaMasterClient().getBackupStatus(id);
        }
        this.mCluster.getFileSystemClient().delete(f);
        String modifiedData = "modified data";
        try (FileOutStream overwriteInBackup = this.mCluster.getFileSystemClient().createFile(f);){
            overwriteInBackup.write(modifiedData.getBytes());
        }
        this.mCluster.stopMasters();
        this.mCluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_FOLDER, temporaryFolder.newFolder().getAbsolutePath());
        this.mCluster.updateMasterConf(PropertyKey.MASTER_METASTORE_DIR, temporaryFolder.newFolder().getAbsolutePath());
        this.mCluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, backup.getBackupUri().getPath());
        this.mCluster.startMasters();
        this.mCluster.waitForAllNodesRegistered(30000);
        var9_13 = null;
        try (FileInStream inStream = this.mCluster.getFileSystemClient().openFile(f);){
            byte[] bytes = new byte[modifiedData.length()];
            int read = inStream.read(bytes);
            int expectedLength = syncRootOnRestore ? modifiedData.length() : originalData.length();
            String expectedStart = syncRootOnRestore ? modifiedData : modifiedData.substring(0, originalData.length());
            Assert.assertEquals((long)expectedLength, (long)read);
            Assert.assertTrue((boolean)new String(bytes).startsWith(expectedStart));
        }
        catch (Throwable throwable) {
            var9_13 = throwable;
            throw throwable;
        }
        this.mCluster.notifySuccess();
        temporaryFolder.delete();
    }

    @Test
    public void backupRestoreEmbedded() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_EMBEDDED).setClusterName("backupRestoreEmbedded").setNumMasters(3).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreTest(true);
    }

    @Test
    public void backupRestoreSingleMaster() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_RESTORE_SINGLE).setClusterName("backupRestoreSingle").setNumMasters(1).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)false).build();
        this.backupRestoreTest(false);
    }

    @Test
    public void backupDelegationProtocol() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_DELEGATION_PROTOCOL).setClusterName("backupDelegationProtocol").setNumMasters(3).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MIN, (Object)"100ms").addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MAX, (Object)"100ms").addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)true).build();
        File backups = AlluxioTestDirectory.createTemporaryDirectory((String)"backups");
        this.mCluster.start();
        this.waitForBackup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build());
        int primaryIdx = this.mCluster.getPrimaryMasterIndex(30000);
        this.mCluster.waitForAndKillPrimaryMaster(30000);
        this.waitForBackup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build());
        int newPrimaryIdx = this.mCluster.getPrimaryMasterIndex(30000);
        int followerIdx = (newPrimaryIdx + 1) % 2;
        if (followerIdx == primaryIdx) {
            followerIdx = (followerIdx + 1) % 2;
        }
        this.mCluster.stopMaster(followerIdx);
        Thread.sleep(1000L);
        try {
            this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build());
            Assert.fail((String)"Cannot delegate backup with no followers.");
        }
        catch (FailedPreconditionException failedPreconditionException) {
            // empty catch block
        }
        this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false).setAllowLeader(true)).build());
        this.mCluster.startMaster(followerIdx);
        this.waitForBackup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build());
        UUID backupId = this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false).setRunAsync(true)).build()).getBackupId();
        CommonUtils.waitFor((String)"Backup completed.", () -> {
            try {
                return this.mCluster.getMetaMasterClient().getBackupStatus(backupId).getState().equals((Object)BackupState.Completed);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unexpected error while getting backup status: %s", e));
            }
        });
        this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false).setAllowLeader(true)).build());
        this.mCluster.getMetaMasterClient().getBackupStatus(backupId);
        this.mCluster.notifySuccess();
    }

    @Test
    public void backupDelegationFailoverProtocol() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_DELEGATION_FAILOVER_PROTOCOL).setClusterName("backupDelegationFailoverProtocol").setNumMasters(2).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MIN, (Object)"100ms").addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MAX, (Object)"100ms").addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)true).addProperty(PropertyKey.MASTER_BACKUP_ABANDON_TIMEOUT, (Object)"3sec").build();
        File backups = AlluxioTestDirectory.createTemporaryDirectory((String)"backups");
        this.mCluster.start();
        this.waitForBackup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build());
        int primaryIdx = this.mCluster.getPrimaryMasterIndex(30000);
        int followerIdx = (primaryIdx + 1) % 2;
        UUID backupId = this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false).setRunAsync(true)).build()).getBackupId();
        this.mCluster.stopMaster(followerIdx);
        CommonUtils.waitForResult((String)"Backup abandoned.", () -> {
            try {
                return this.mCluster.getMetaMasterClient().getBackupStatus(backupId);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unexpected error while getting backup status: %s", e));
            }
        }, backupStatus -> backupStatus.getError() instanceof BackupAbortedException);
        this.mCluster.startMaster(followerIdx);
        this.waitForBackup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build());
        this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false).setRunAsync(true)).build()).getBackupId();
        this.mCluster.waitForAndKillPrimaryMaster(30000);
        Assert.assertEquals((long)this.mCluster.getPrimaryMasterIndex(30000), (long)followerIdx);
        this.mCluster.getMetaMasterClient().backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false).setAllowLeader(true)).build());
        this.mCluster.notifySuccess();
    }

    @Test
    public void backupDelegationZk() throws Exception {
        MultiProcessCluster.Builder clusterBuilder = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_DELEGATION_ZK).setClusterName("backupDelegationZk").setNumMasters(2).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.ZOOKEEPER_SESSION_TIMEOUT, (Object)"1sec").addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)true).addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MIN, (Object)"100ms").addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MAX, (Object)"100ms");
        this.backupDelegationTest(clusterBuilder);
    }

    @Test
    public void backupDelegationEmbedded() throws Exception {
        MultiProcessCluster.Builder clusterBuilder = MultiProcessCluster.newBuilder((List)PortCoordination.BACKUP_DELEGATION_EMBEDDED).setClusterName("backupDelegationEmbedded").setNumMasters(2).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_BACKUP_DELEGATION_ENABLED, (Object)true).addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MIN, (Object)"100ms").addProperty(PropertyKey.MASTER_BACKUP_CONNECT_INTERVAL_MAX, (Object)"100ms");
        this.backupDelegationTest(clusterBuilder);
    }

    private AlluxioURI waitForBackup(BackupPRequest backupRequest) throws Exception {
        AtomicReference<Object> backupUriRef = new AtomicReference<Object>(null);
        CommonUtils.waitFor((String)"Backup delegation to succeed.", () -> {
            try {
                backupUriRef.set(this.mCluster.getMetaMasterClient().backup(backupRequest).getBackupUri());
                return true;
            }
            catch (FailedPreconditionException e1) {
                return false;
            }
            catch (Exception e2) {
                throw new RuntimeException(String.format("Backup failed with unexpected error: %s", e2));
            }
        }, (WaitForOptions)WaitForOptions.defaults());
        return backupUriRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupRestoreTest(boolean testFailover) throws Exception {
        File backups = AlluxioTestDirectory.createTemporaryDirectory((String)"backups");
        this.mCluster.start();
        ArrayList<AlluxioOperationThread> opThreads = new ArrayList<AlluxioOperationThread>();
        for (int i = 0; i < 10; ++i) {
            AlluxioOperationThread thread = new AlluxioOperationThread(this.mCluster.getFileSystemClient());
            thread.start();
            opThreads.add(thread);
        }
        try {
            FileSystem fs = this.mCluster.getFileSystemClient();
            MetaMasterClient metaClient = this.getMetaClient(this.mCluster);
            AlluxioURI dir1 = new AlluxioURI("/dir1");
            fs.createDirectory(dir1, CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
            AlluxioURI backup1 = metaClient.backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build()).getBackupUri();
            AlluxioURI dir2 = new AlluxioURI("/dir2");
            fs.createDirectory(dir2, CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
            AlluxioURI backup2 = metaClient.backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build()).getBackupUri();
            this.restartMastersFromBackup(backup2);
            Assert.assertTrue((boolean)fs.exists(dir1));
            Assert.assertTrue((boolean)fs.exists(dir2));
            this.restartMastersFromBackup(backup1);
            Assert.assertTrue((boolean)fs.exists(dir1));
            Assert.assertFalse((boolean)fs.exists(dir2));
            this.mCluster.stopMasters();
            this.mCluster.startMasters();
            Assert.assertTrue((boolean)fs.exists(dir1));
            Assert.assertFalse((boolean)fs.exists(dir2));
            if (testFailover) {
                this.mCluster.waitForAndKillPrimaryMaster(30000);
                Assert.assertTrue((boolean)fs.exists(dir1));
                Assert.assertFalse((boolean)fs.exists(dir2));
            }
            this.mCluster.notifySuccess();
        }
        finally {
            opThreads.forEach(Thread::interrupt);
        }
    }

    private void backupDelegationTest(MultiProcessCluster.Builder clusterBuilder) throws Exception {
        HashMap masterProps = new HashMap();
        File backupsParent0 = AlluxioTestDirectory.createTemporaryDirectory((String)"backups0");
        File backupsParent1 = AlluxioTestDirectory.createTemporaryDirectory((String)"backups1");
        HashMap<PropertyKey, String> master0Props = new HashMap<PropertyKey, String>();
        master0Props.put(PropertyKey.MASTER_BACKUP_DIRECTORY, backupsParent0.getAbsolutePath());
        HashMap<PropertyKey, String> master1Props = new HashMap<PropertyKey, String>();
        master1Props.put(PropertyKey.MASTER_BACKUP_DIRECTORY, backupsParent1.getAbsolutePath());
        masterProps.put(0, master0Props);
        masterProps.put(1, master1Props);
        clusterBuilder.setMasterProperties(masterProps);
        this.mCluster = clusterBuilder.build();
        this.mCluster.start();
        Assert.assertEquals((long)2L, (long)this.mCluster.getMasterAddresses().size());
        FileSystem fs = this.mCluster.getFileSystemClient();
        AlluxioURI dir1 = new AlluxioURI("/dir1");
        this.mCluster.getFileSystemClient().createDirectory(dir1, CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        AlluxioURI backupUri = this.waitForBackup(BackupPRequest.newBuilder().setOptions(BackupPOptions.newBuilder().setLocalFileSystem(true)).build());
        int primaryIndex = this.mCluster.getPrimaryMasterIndex(30000);
        int followerIndex = (primaryIndex + 1) % 2;
        Assert.assertTrue((boolean)backupUri.toString().contains((CharSequence)((Map)masterProps.get(followerIndex)).get(PropertyKey.MASTER_BACKUP_DIRECTORY)));
        this.restartMastersFromBackup(backupUri);
        Assert.assertTrue((boolean)fs.exists(dir1));
        this.mCluster.notifySuccess();
    }

    private void backupRestoreMetaStoreTest() throws Exception {
        File backups = AlluxioTestDirectory.createTemporaryDirectory((String)"backups");
        this.mCluster.start();
        this.mCluster.waitForAllNodesRegistered(30000);
        FileSystem fs = this.mCluster.getFileSystemClient();
        MetaMasterClient metaClient = this.getMetaClient(this.mCluster);
        BlockMasterClient blockClient = this.getBlockClient(this.mCluster);
        String testFilePath = "/file";
        AlluxioURI testFileUri = new AlluxioURI(testFilePath);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)testFilePath, (int)100, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).build());
        fs.delete(testFileUri, DeletePOptions.newBuilder().setAlluxioOnly(true).build());
        fs.listStatus(new AlluxioURI("/"), ListStatusPOptions.newBuilder().setRecursive(true).setLoadMetadataType(LoadMetadataPType.ONCE).build());
        Assert.assertNotNull((Object)fs.getStatus(testFileUri));
        AlluxioURI backup1 = metaClient.backup(BackupPRequest.newBuilder().setTargetDirectory(backups.getAbsolutePath()).setOptions(BackupPOptions.newBuilder().setLocalFileSystem(false)).build()).getBackupUri();
        this.restartMastersFromBackup(backup1);
        URIStatus fileStatus = fs.getStatus(testFileUri);
        Assert.assertNotNull((Object)fileStatus);
        Iterator iterator = fileStatus.getBlockIds().iterator();
        while (iterator.hasNext()) {
            long blockId = (Long)iterator.next();
            Assert.assertNotNull((Object)blockClient.getBlockInfo(blockId));
        }
    }

    private void restartMastersFromBackup(AlluxioURI backup) throws IOException {
        this.mCluster.stopMasters();
        this.mCluster.formatJournal();
        this.mCluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, backup.toString());
        this.mCluster.startMasters();
        this.mCluster.updateMasterConf(PropertyKey.MASTER_JOURNAL_INIT_FROM_BACKUP, null);
    }

    private MetaMasterClient getMetaClient(MultiProcessCluster cluster) {
        return new RetryHandlingMetaMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(cluster.getMasterInquireClient()).build());
    }

    private BlockMasterClient getBlockClient(MultiProcessCluster cluster) {
        return new RetryHandlingBlockMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient(cluster.getMasterInquireClient()).build());
    }
}

