/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.master.MultiMasterLocalAlluxioCluster;
import alluxio.master.file.meta.TtlIntervalRule;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class MultiMasterJournalTest
extends BaseIntegrationTest {
    private MultiMasterLocalAlluxioCluster mCluster;
    @Rule
    public TtlIntervalRule mTtlRule = new TtlIntervalRule(200L);
    @Rule
    public TestName mTestName = new TestName();

    @Before
    public void before() throws Exception {
        this.mCluster = new MultiMasterLocalAlluxioCluster(2, 0);
        this.mCluster.initConfiguration(IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName()));
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, (Object)5);
        Configuration.set((PropertyKey)PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, (Object)100);
        this.mCluster.start();
    }

    @After
    public void after() throws Exception {
        this.mCluster.stop();
    }

    @Deprecated
    public void testCheckpointReplay() throws Exception {
        this.triggerAndWaitForCheckpoint();
        this.mCluster.restartMasters();
        Assert.assertEquals((String)"The cluster should remember the 10 files", (long)10L, (long)this.mCluster.getClient().listStatus(new AlluxioURI("/")).size());
    }

    @Deprecated
    public void testTtl() throws Exception {
        AlluxioURI file = new AlluxioURI("/file");
        this.mCluster.getClient().createFile(file).close();
        int ttl = 5000;
        this.mCluster.getClient().setAttribute(file, SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl((long)ttl).setTtlAction(TtlAction.DELETE)).build());
        this.triggerAndWaitForCheckpoint();
        this.mCluster.restartMasters();
        FileSystem client = this.mCluster.getClient();
        CommonUtils.waitFor((String)"file to be deleted", () -> {
            try {
                return !client.exists(file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(30000L));
    }

    private void triggerAndWaitForCheckpoint() throws Exception {
        FileSystem client = this.mCluster.getClient();
        for (int i = 0; i < 10; ++i) {
            client.createFile(new AlluxioURI("/triggerCheckpoint" + i)).close();
        }
        IntegrationTestUtils.waitForUfsJournalCheckpoint("FileSystemMaster");
    }
}

