/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.metrics.MetricsMasterClient;
import alluxio.conf.PropertyKey;
import alluxio.grpc.MetricValue;
import alluxio.master.Master;
import alluxio.master.NoopMaster;
import alluxio.master.journal.JournalType;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalSnapshot;
import alluxio.metrics.MetricKey;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.util.URIUtils;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="In Dora, Client does not use Master/Journal services.")
public class TriggeredCheckpointTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ufsJournal() throws Exception {
        int numFiles = 100;
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.TRIGGERED_UFS_CHECKPOINT).setClusterName("TriggeredUfsCheckpointTest").addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, (Object)numFiles).setNumMasters(1).setNumWorkers(1).build();
        try {
            cluster.start();
            cluster.waitForAllNodesRegistered(20000);
            this.createFiles(cluster, numFiles);
            Assert.assertEquals((Object)((MasterNetAddress)cluster.getMasterAddresses().get(0)).getHostname(), (Object)cluster.getMetaMasterClient().checkpoint());
            String journalLocation = cluster.getJournalDir();
            UfsJournal ufsJournal = new UfsJournal(URIUtils.appendPathOrDie((URI)new URI(journalLocation), (String)"FileSystemMaster"), (Master)new NoopMaster(""), 0L, Collections::emptySet);
            Assert.assertEquals((long)1L, (long)UfsJournalSnapshot.getSnapshot((UfsJournal)ufsJournal).getCheckpoints().size());
            this.validateCheckpointInClusterRestart(cluster);
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ufsJournalWithParallelBackupRocksDb() throws Exception {
        int numFiles = 100;
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.TRIGGERED_UFS_CHECKPOINT).setClusterName("TriggeredUfsCheckpointTest").addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.UFS).addProperty(PropertyKey.MASTER_JOURNAL_CHECKPOINT_PERIOD_ENTRIES, (Object)numFiles).addProperty(PropertyKey.MASTER_METASTORE, (Object)"ROCKS").addProperty(PropertyKey.MASTER_METASTORE_ROCKS_PARALLEL_BACKUP, (Object)true).addProperty(PropertyKey.MASTER_METASTORE_ROCKS_PARALLEL_BACKUP_THREADS, (Object)5).setNumMasters(1).setNumWorkers(1).build();
        try {
            cluster.start();
            cluster.waitForAllNodesRegistered(20000);
            this.createFiles(cluster, numFiles);
            Assert.assertEquals((Object)((MasterNetAddress)cluster.getMasterAddresses().get(0)).getHostname(), (Object)cluster.getMetaMasterClient().checkpoint());
            String journalLocation = cluster.getJournalDir();
            UfsJournal ufsJournal = new UfsJournal(URIUtils.appendPathOrDie((URI)new URI(journalLocation), (String)"FileSystemMaster"), (Master)new NoopMaster(""), 0L, Collections::emptySet);
            Assert.assertEquals((long)1L, (long)UfsJournalSnapshot.getSnapshot((UfsJournal)ufsJournal).getCheckpoints().size());
            this.validateCheckpointInClusterRestart(cluster);
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }

    @Test
    public void embeddedJournal() throws Exception {
        MultiProcessCluster cluster = MultiProcessCluster.newBuilder((List)PortCoordination.TRIGGERED_EMBEDDED_CHECKPOINT).setClusterName("TriggeredEmbeddedCheckpointTest").addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, (Object)1024).setNumMasters(1).setNumWorkers(1).build();
        cluster.start();
        try {
            cluster.waitForAllNodesRegistered(20000);
            this.createFiles(cluster, 100);
            Assert.assertEquals((Object)((MasterNetAddress)cluster.getMasterAddresses().get(0)).getHostname(), (Object)cluster.getMetaMasterClient().checkpoint());
            this.validateCheckpointInClusterRestart(cluster);
            cluster.notifySuccess();
        }
        finally {
            cluster.destroy();
        }
    }

    private void createFiles(MultiProcessCluster cluster, int numFiles) throws Exception {
        FileSystem fs = cluster.getFileSystemClient();
        for (int i = 0; i < numFiles; ++i) {
            fs.createFile(new AlluxioURI("/file" + i)).close();
        }
        MetricsMasterClient metricsMasterClient = cluster.getMetricsMasterClient();
        Assert.assertEquals((long)(numFiles + 1), (long)((long)((MetricValue)metricsMasterClient.getMetrics().get(MetricKey.MASTER_TOTAL_PATHS.getName())).getDoubleValue()));
    }

    private void validateCheckpointInClusterRestart(MultiProcessCluster cluster) throws Exception {
        cluster.stopMasters();
        cluster.startMasters();
        cluster.waitForAllNodesRegistered(40000);
        Assert.assertEquals((long)100L, (long)cluster.getFileSystemClient().listStatus(new AlluxioURI("/")).size());
        Assert.assertEquals((long)101L, (long)((long)((MetricValue)cluster.getMetricsMasterClient().getMetrics().get(MetricKey.MASTER_TOTAL_PATHS.getName())).getDoubleValue()));
    }
}

