/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal.raft;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.conf.PropertyKey;
import alluxio.grpc.NetAddress;
import alluxio.grpc.QuorumServerInfo;
import alluxio.grpc.QuorumServerState;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.server.ft.journal.raft.EmbeddedJournalIntegrationTestBase;
import alluxio.util.CommonUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddedJournalIntegrationTestResizing
extends EmbeddedJournalIntegrationTestBase {
    @Test
    public void resizeCluster() throws Exception {
        int NUM_MASTERS = 5;
        boolean NUM_WORKERS = false;
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_RESIZE).setClusterName("EmbeddedJournalResizing_resizeCluster").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        Assert.assertEquals((long)5L, (long)this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().size());
        AlluxioURI testDir = new AlluxioURI("/" + CommonUtils.randomAlphaNumString((int)10));
        FileSystem fs = this.mCluster.getFileSystemClient();
        fs.createDirectory(testDir);
        Assert.assertTrue((boolean)fs.exists(testDir));
        this.mCluster.stopMaster(0);
        this.mCluster.stopMaster(1);
        Assert.assertTrue((boolean)fs.exists(testDir));
        this.waitForQuorumPropertySize(info -> info.getServerState() == QuorumServerState.UNAVAILABLE, 2);
        LinkedList<NetAddress> unavailableMasters = new LinkedList<NetAddress>();
        for (QuorumServerInfo serverState : this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList()) {
            if (!serverState.getServerState().equals((Object)QuorumServerState.UNAVAILABLE)) continue;
            unavailableMasters.add(serverState.getServerAddress());
        }
        Assert.assertEquals((long)2L, (long)unavailableMasters.size());
        for (NetAddress unavailableMasterAddress : unavailableMasters) {
            this.mCluster.getJournalMasterClientForMaster().removeQuorumServer(unavailableMasterAddress);
        }
        Assert.assertEquals((long)3L, (long)this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().size());
        this.mCluster.stopMaster(2);
        Assert.assertTrue((boolean)fs.exists(testDir));
        this.mCluster.notifySuccess();
    }

    @Test
    public void growCluster() throws Exception {
        int NUM_MASTERS = 2;
        boolean NUM_WORKERS = false;
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_GROW).setClusterName("EmbeddedJournalResizing_growCluster").setNumMasters(2).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"2s").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"4s").build();
        this.mCluster.start();
        AlluxioURI testDir = new AlluxioURI("/" + CommonUtils.randomAlphaNumString((int)10));
        FileSystem fs = this.mCluster.getFileSystemClient();
        fs.createDirectory(testDir);
        Assert.assertTrue((boolean)fs.exists(testDir));
        Assert.assertEquals((long)2L, (long)this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().size());
        this.mCluster.startNewMasters(1, false);
        this.waitForQuorumPropertySize(info -> info.getServerState() == QuorumServerState.AVAILABLE, 3);
        fs = this.mCluster.getFileSystemClient();
        Assert.assertTrue((boolean)fs.exists(testDir));
        this.mCluster.stopAndRemoveMaster(0);
        this.waitForQuorumPropertySize(info -> info.getServerState() == QuorumServerState.UNAVAILABLE, 1);
        Assert.assertTrue((boolean)fs.exists(testDir));
        this.mCluster.notifySuccess();
    }

    @Test
    public void replaceAll() throws Exception {
        int NUM_MASTERS = 3;
        boolean NUM_WORKERS = false;
        ArrayList ports = new ArrayList(PortCoordination.EMBEDDED_JOURNAL_REPLACE_ALL);
        ports.addAll(PortCoordination.EMBEDDED_JOURNAL_REPLACE_ALL);
        this.mCluster = MultiProcessCluster.newBuilder(ports).setClusterName("EmbeddedJournalResizing_replaceAll").setNumMasters(3).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        AlluxioURI testDir = new AlluxioURI("/" + CommonUtils.randomAlphaNumString((int)10));
        FileSystem fs = this.mCluster.getFileSystemClient();
        fs.createDirectory(testDir);
        Assert.assertTrue((boolean)fs.exists(testDir));
        ArrayList originalMasters = new ArrayList(this.mCluster.getMasterAddresses());
        for (MasterNetAddress masterNetAddress : originalMasters) {
            int masterIdx = this.mCluster.getMasterAddresses().indexOf(masterNetAddress);
            this.mCluster.stopAndRemoveMaster(masterIdx);
            this.waitForQuorumPropertySize(info -> info.getServerState() == QuorumServerState.UNAVAILABLE, 1);
            this.mCluster.startNewMasters(1, false);
            this.waitForQuorumPropertySize(info -> info.getServerState() == QuorumServerState.UNAVAILABLE, 0);
            fs = this.mCluster.getFileSystemClient();
            Assert.assertTrue((boolean)fs.exists(testDir));
        }
        this.mCluster.notifySuccess();
    }
}

