/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal.raft;

import alluxio.conf.PropertyKey;
import alluxio.grpc.GetTransferLeaderMessagePResponse;
import alluxio.grpc.NetAddress;
import alluxio.grpc.QuorumServerState;
import alluxio.master.journal.JournalType;
import alluxio.multi.process.MasterNetAddress;
import alluxio.multi.process.MultiProcessCluster;
import alluxio.multi.process.PortCoordination;
import alluxio.server.ft.journal.raft.EmbeddedJournalIntegrationTestBase;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddedJournalIntegrationTestTransferLeadership
extends EmbeddedJournalIntegrationTestBase {
    public static final int NUM_MASTERS = 5;
    public static final int NUM_WORKERS = 0;

    @Test
    public void transferLeadership() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_TRANSFER_LEADER).setClusterName("EmbeddedJournalTransferLeadership_transferLeadership").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        int newLeaderIdx = (this.mCluster.getPrimaryMasterIndex(5000) + 1) % 5;
        MasterNetAddress newLeaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
        this.transferAndWait(newLeaderAddr);
        this.mCluster.notifySuccess();
    }

    @Test
    public void repeatedTransferLeadership() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_REPEAT_TRANSFER_LEADER).setClusterName("EmbeddedJournalTransferLeadership_repeatedTransferLeadership").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        for (int i = 0; i < 5; ++i) {
            int newLeaderIdx = (this.mCluster.getPrimaryMasterIndex(5000) + 1) % 5;
            MasterNetAddress newLeaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
            this.transferAndWait(newLeaderAddr);
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void transferLeadershipOutsideCluster() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_OUTSIDE_CLUSTER).setClusterName("EmbeddedJournalTransferLeadership_transferLeadership").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        NetAddress netAddress = NetAddress.newBuilder().setHost("hostname").setRpcPort(0).build();
        String transferId = this.mCluster.getJournalMasterClientForMaster().transferLeadership(netAddress);
        String exceptionMessage = this.mCluster.getJournalMasterClientForMaster().getTransferLeaderMessage(transferId).getTransMsg().getMsg();
        Assert.assertTrue((boolean)exceptionMessage.startsWith(String.format("<%s:%d> is not part of the quorum", netAddress.getHost(), netAddress.getRpcPort())));
        for (MasterNetAddress address : this.mCluster.getMasterAddresses()) {
            String host = address.getHostname();
            int port = address.getEmbeddedJournalPort();
            Assert.assertTrue((boolean)exceptionMessage.contains(String.format("%s:%d", host, port)));
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void transferLeadershipToNewMember() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_NEW_MEMBER).setClusterName("EmbeddedJournalTransferLeadership_transferLeadershipToNewMember").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        this.mCluster.startNewMasters(1, false);
        this.waitForQuorumPropertySize(info -> info.getServerState() == QuorumServerState.AVAILABLE, 6);
        MasterNetAddress newLeaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(5);
        this.transferAndWait(newLeaderAddr);
        this.mCluster.notifySuccess();
    }

    @Test
    public void transferLeadershipToUnavailableMaster() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_UNAVAILABLE_MASTER).setClusterName("EmbeddedJournalTransferLeadership_transferLeadershipToUnavailableMaster").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        int newLeaderIdx = (this.mCluster.getPrimaryMasterIndex(5000) + 1) % 5;
        MasterNetAddress newLeaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
        this.mCluster.stopMaster(newLeaderIdx);
        try {
            this.transferAndWait(newLeaderAddr);
            Assert.fail((String)"Transfer should have failed");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void resetPriorities() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_UNAVAILABLE_MASTER).setClusterName("EmbeddedJournalTransferLeadership_transferLeadershipToUnavailableMaster").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        boolean match = this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().stream().allMatch(info -> info.getPriority() == 0);
        Assert.assertTrue((boolean)match);
        for (int i = 0; i < 5; ++i) {
            int newLeaderIdx = (this.mCluster.getPrimaryMasterIndex(5000) + 1) % 5;
            MasterNetAddress newLeaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
            this.transferAndWait(newLeaderAddr);
            match = this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().stream().allMatch(info -> info.getPriority() == 0);
            Assert.assertTrue((boolean)match);
            this.mCluster.getJournalMasterClientForMaster().resetPriorities();
            match = this.mCluster.getJournalMasterClientForMaster().getQuorumInfo().getServerInfoList().stream().allMatch(info -> info.getPriority() == 0);
            Assert.assertTrue((boolean)match);
        }
        this.mCluster.notifySuccess();
    }

    @Test
    public void transferToSelfThenToOther() throws Exception {
        this.mCluster = MultiProcessCluster.newBuilder((List)PortCoordination.EMBEDDED_JOURNAL_UNAVAILABLE_MASTER).setClusterName("EmbeddedJournalTransferLeadership_transferLeadershipToUnavailableMaster").setNumMasters(5).setNumWorkers(0).addProperty(PropertyKey.MASTER_JOURNAL_TYPE, (Object)JournalType.EMBEDDED).addProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, (Object)"5min").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MIN_ELECTION_TIMEOUT, (Object)"750ms").addProperty(PropertyKey.MASTER_EMBEDDED_JOURNAL_MAX_ELECTION_TIMEOUT, (Object)"1500ms").build();
        this.mCluster.start();
        int leaderIdx = this.mCluster.getPrimaryMasterIndex(5000);
        MasterNetAddress leaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(leaderIdx);
        String transferId = this.transferAndWait(leaderAddr);
        GetTransferLeaderMessagePResponse transferLeaderMessage = this.mCluster.getJournalMasterClientForMaster().getTransferLeaderMessage(transferId);
        Assert.assertTrue((boolean)transferLeaderMessage.getTransMsg().getMsg().isEmpty());
        int newLeaderIdx = (leaderIdx + 1) % 5;
        MasterNetAddress newLeaderAddr = (MasterNetAddress)this.mCluster.getMasterAddresses().get(newLeaderIdx);
        this.transferAndWait(newLeaderAddr);
        this.mCluster.notifySuccess();
    }

    private String transferAndWait(MasterNetAddress newLeaderAddr) throws Exception {
        NetAddress netAddress = NetAddress.newBuilder().setHost(newLeaderAddr.getHostname()).setRpcPort(newLeaderAddr.getEmbeddedJournalPort()).build();
        String transferId = this.mCluster.getJournalMasterClientForMaster().transferLeadership(netAddress);
        this.waitForQuorumPropertySize(info -> info.getIsLeader() && info.getServerAddress().equals((Object)netAddress), 1);
        return transferId;
    }
}

