/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.ft.journal.ufs;

import alluxio.AlluxioURI;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.delegating.DelegatingUnderFileSystem;
import alluxio.testutils.underfs.delegating.DelegatingUnderFileSystemFactory;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.util.CommonUtils;
import com.google.common.io.Files;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RenameFailureJournalTest {
    private static final String LOCAL_UFS_PATH = Files.createTempDir().getAbsolutePath();
    private FileSystem mFs;
    private static final UnderFileSystem UFS = new DelegatingUnderFileSystem(UnderFileSystem.Factory.create((String)LOCAL_UFS_PATH, (AlluxioConfiguration)Configuration.global())){

        @Override
        public boolean renameFile(String src, String dst) throws IOException {
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                return this.mUfs.renameFile(src, dst);
            }
            return false;
        }
    };
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new DelegatingUnderFileSystemFactory(UFS));
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_JOURNAL_FOLDER, "delegating://" + LOCAL_UFS_PATH).setProperty(PropertyKey.MASTER_JOURNAL_LOG_SIZE_BYTES_MAX, 128).setProperty(PropertyKey.MASTER_JOURNAL_FLUSH_BATCH_TIME_MS, 0).setProperty(PropertyKey.MASTER_JOURNAL_FLUSH_TIMEOUT_MS, "5min").setProperty(PropertyKey.MASTER_JOURNAL_FLUSH_RETRY_INTERVAL, "0").build();

    @Before
    public void before() throws Exception {
        this.mFs = FileSystem.Factory.create();
    }

    @Test
    public void testMultiRestart() throws Exception {
        int i;
        ArrayList<AlluxioURI> paths = new ArrayList<AlluxioURI>();
        for (i = 0; i < 3; ++i) {
            AlluxioURI path = new AlluxioURI("/path" + i);
            paths.add(path);
            this.mFs.createDirectory(path);
            CommonUtils.sleepMs((long)10L);
        }
        for (i = 0; i < 3; ++i) {
            this.mLocalAlluxioClusterResource.get().restartMasters();
            for (AlluxioURI path : paths) {
                Assert.assertTrue((boolean)this.mFs.exists(path));
            }
        }
    }
}

