/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.health;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.file.DefaultFileSystemMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.RpcContext;
import alluxio.master.file.contexts.DeleteContext;
import alluxio.master.file.meta.InodeTree;
import alluxio.master.file.meta.LockedInodePath;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.worker.block.BlockWorker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="BlockMaster is deprecated")
public class BlockMasterIntegrityIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private LocalAlluxioCluster mCluster;

    @Before
    public void before() {
        this.mCluster = this.mClusterResource.get();
    }

    @Test
    public void deleteOrphanedBlocks() throws Exception {
        AlluxioURI uri = new AlluxioURI("/test");
        int len = 10;
        FileSystem fs = this.mCluster.getClient();
        BlockWorker worker = (BlockWorker)this.mCluster.getWorkerProcess().getWorker(BlockWorker.class);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (AlluxioURI)uri, (WritePType)WritePType.MUST_CACHE, (int)len);
        Assert.assertEquals((long)1L, (long)worker.getStoreMetaFull().getNumberOfBlocks());
        this.mCluster.stopWorkers();
        fs.delete(uri);
        this.mCluster.restartMasters();
        this.mCluster.startWorkers();
        BlockWorker newWorker = (BlockWorker)this.mCluster.getWorkerProcess().getWorker(BlockWorker.class);
        CommonUtils.waitFor((String)"orphan blocks to be deleted", () -> newWorker.getStoreMetaFull().getNumberOfBlocks() == 0, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(2000L));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.startup.block.integrity.check.enabled", "true"})
    public void deleteInvalidBlocks() throws Exception {
        AlluxioURI uri = new AlluxioURI("/test");
        int len = 10;
        FileSystem fs = this.mCluster.getClient();
        BlockWorker worker = (BlockWorker)this.mCluster.getWorkerProcess().getWorker(BlockWorker.class);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (AlluxioURI)uri, (WritePType)WritePType.MUST_CACHE, (int)len);
        Assert.assertEquals((long)1L, (long)worker.getStoreMetaFull().getNumberOfBlocks());
        this.removeFileMetadata(uri);
        this.mCluster.stopWorkers();
        this.mCluster.restartMasters();
        this.mCluster.startWorkers();
        BlockWorker newWorker = (BlockWorker)this.mCluster.getWorkerProcess().getWorker(BlockWorker.class);
        CommonUtils.waitFor((String)"invalid blocks to be deleted", () -> newWorker.getStoreMetaFull().getNumberOfBlocks() == 0, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(2000L));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.master.periodic.block.integrity.check.interval", "1sec", "alluxio.master.periodic.block.integrity.check.repair", "true"})
    public void deleteInvalidBlocksPeriodically() throws Exception {
        AlluxioURI uri = new AlluxioURI("/test");
        int len = 10;
        FileSystem fs = this.mCluster.getClient();
        BlockWorker worker = (BlockWorker)this.mCluster.getWorkerProcess().getWorker(BlockWorker.class);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (AlluxioURI)uri, (WritePType)WritePType.MUST_CACHE, (int)len);
        Assert.assertEquals((long)1L, (long)worker.getStoreMetaFull().getNumberOfBlocks());
        this.removeFileMetadata(uri);
        CommonUtils.waitFor((String)"invalid blocks to be deleted", () -> worker.getStoreMetaFull().getNumberOfBlocks() == 0, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(2000L));
    }

    private void removeFileMetadata(AlluxioURI uri) throws Exception {
        FileSystemMaster fsm = (FileSystemMaster)this.mCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
        InodeTree tree = (InodeTree)Whitebox.getInternalState((Object)fsm, (String)"mInodeTree");
        RpcContext rpcContext = ((DefaultFileSystemMaster)fsm).createRpcContext();
        LockedInodePath path = tree.lockInodePath(uri, InodeTree.LockPattern.WRITE_EDGE, rpcContext.getJournalContext());
        ((DefaultFileSystemMaster)fsm).deleteInternal(rpcContext, path, DeleteContext.defaults(), false);
        path.close();
        rpcContext.close();
    }
}

