/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.health;

import alluxio.HealthCheckClient;
import alluxio.conf.Configuration;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.master.MasterHealthCheckClient;
import alluxio.master.job.JobMasterRpcHealthCheckClient;
import alluxio.retry.CountingRetry;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.net.InetSocketAddress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JobMasterHealthCheckClientIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private LocalAlluxioJobCluster mLocalAlluxioJobCluster = null;
    private HealthCheckClient mHealthCheckClient;

    @Before
    public final void before() throws Exception {
        this.mLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        this.mLocalAlluxioJobCluster.start();
        InetSocketAddress address = this.mLocalAlluxioJobCluster.getMaster().getRpcAddress();
        this.mHealthCheckClient = new JobMasterRpcHealthCheckClient(address, () -> new CountingRetry(1), Configuration.global());
    }

    @After
    public final void after() throws Exception {
        this.mLocalAlluxioJobCluster.stop();
    }

    @Test
    public void isServing() {
        Assert.assertTrue((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingStopJobs() throws Exception {
        this.mLocalAlluxioJobCluster.stop();
        Assert.assertFalse((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingMasterHealthCheck() {
        this.mHealthCheckClient = new MasterHealthCheckClient.Builder(Configuration.global()).withRetryPolicy(() -> new CountingRetry(1)).withProcessCheck(false).withAlluxioMasterType(MasterHealthCheckClient.MasterType.JOB_MASTER).build();
        Assert.assertTrue((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingStopJobsMasterHealthCheck() throws Exception {
        this.mLocalAlluxioJobCluster.stop();
        this.mHealthCheckClient = new MasterHealthCheckClient.Builder(Configuration.global()).withRetryPolicy(() -> new CountingRetry(1)).withProcessCheck(false).withAlluxioMasterType(MasterHealthCheckClient.MasterType.JOB_MASTER).build();
        Assert.assertFalse((boolean)this.mHealthCheckClient.isServing());
    }
}

