/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.health;

import alluxio.HealthCheckClient;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.retry.CountingRetry;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.worker.job.JobWorkerHealthCheckClient;
import java.net.InetSocketAddress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JobWorkerHealthCheckClientIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.JOB_WORKER_RPC_PORT, 0).build();
    private LocalAlluxioJobCluster mLocalAlluxioJobCluster = null;
    private HealthCheckClient mHealthCheckClient;

    @Before
    public final void before() throws Exception {
        this.mLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        this.mLocalAlluxioJobCluster.start();
        InetSocketAddress address = this.mLocalAlluxioJobCluster.getWorker().getRpcAddress();
        this.mHealthCheckClient = new JobWorkerHealthCheckClient(address, () -> new CountingRetry(1), Configuration.global());
    }

    @After
    public final void after() throws Exception {
        this.mLocalAlluxioJobCluster.stop();
    }

    @Test
    public void isServing() {
        Assert.assertTrue((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingStopJobs() throws Exception {
        this.mLocalAlluxioJobCluster.stop();
        Assert.assertFalse((boolean)this.mHealthCheckClient.isServing());
    }
}

