/*
 * Decompiled with CFR 0.152.
 */
package alluxio.server.health;

import alluxio.HealthCheckClient;
import alluxio.conf.Configuration;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.MasterHealthCheckClient;
import alluxio.retry.CountingRetry;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MasterHealthCheckClientIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private LocalAlluxioCluster mLocalAlluxioCluster = null;
    private HealthCheckClient mHealthCheckClient;

    @Before
    public final void before() {
        this.mLocalAlluxioCluster = this.mLocalAlluxioClusterResource.get();
        this.mHealthCheckClient = new MasterHealthCheckClient.Builder(Configuration.global()).withProcessCheck(false).withRetryPolicy(() -> new CountingRetry(1)).build();
    }

    @Test
    public void isServing() {
        Assert.assertTrue((boolean)this.mHealthCheckClient.isServing());
    }

    @Test
    public void isServingStopFS() throws Exception {
        this.mLocalAlluxioCluster.stopFS();
        Assert.assertFalse((boolean)this.mHealthCheckClient.isServing());
    }
}

