/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.stress.cli.report.GenerateReport;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class AbstractStressBenchIntegrationTest
extends BaseIntegrationTest {
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    @Rule
    public TestRule mResetRule = sLocalAlluxioClusterResource.getResetResource();
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();

    protected void generateAndVerifyReport(List<String> expectedGraphNames, String ... outputJson) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        for (String output : outputJson) {
            File input = this.mFolder.newFile();
            try (FileWriter writer = new FileWriter(input);){
                writer.write(output);
            }
            args.add("--input");
            args.add(input.getAbsolutePath());
        }
        File generatedReport = this.mFolder.newFile(String.format("report-%d.html", System.currentTimeMillis()));
        args.add("--output");
        args.add(generatedReport.getAbsolutePath());
        new GenerateReport().run(args.toArray(new String[0]));
        String result = new String(Files.readAllBytes(Paths.get(generatedReport.getAbsolutePath(), new String[0])));
        for (String expectedName : expectedGraphNames) {
            Assert.assertTrue((String)("report must contain graph name: " + expectedName), (boolean)result.contains(expectedName));
        }
    }

    protected List<String> getJsonResult(String output) {
        ArrayList<String> res = new ArrayList<String>();
        int bracketsNum = 0;
        int end = 0;
        for (int start = 0; start < output.length(); ++start) {
            if (output.charAt(start) != '{') continue;
            bracketsNum = 1;
            for (end = start + 1; end < output.length(); ++end) {
                char c = output.charAt(end);
                if (c == '{') {
                    ++bracketsNum;
                } else if (c == '}') {
                    --bracketsNum;
                }
                if (bracketsNum != 0) continue;
                String json = output.substring(start, end + 1);
                res.add(json);
                break;
            }
            start = end;
        }
        return res;
    }
}

