/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.stress.AbstractStressBenchIntegrationTest;
import alluxio.stress.cli.BatchTaskRunner;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.util.JsonSerializable;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="these tests should be moved to worker")
public class BatchTaskRunnerIntegrationTest
extends AbstractStressBenchIntegrationTest {
    private PrintStream mOriginalOut;
    private ByteArrayOutputStream mOut;
    private List<String> mOperation = ImmutableList.of((Object)"CreateFile", (Object)"ListDir", (Object)"ListDirLocated", (Object)"GetBlockLocations", (Object)"GetFileStatus", (Object)"OpenFile", (Object)"DeleteFile");

    @Before
    public void before() {
        this.mOut = new ByteArrayOutputStream();
        this.mOriginalOut = System.out;
        System.setOut(new PrintStream(this.mOut));
    }

    @After
    public void after() {
        System.setOut(this.mOriginalOut);
    }

    @Test
    public void MasterIntegrationFileTestAllParameters() throws Exception {
        BatchTaskRunner.main((String[])new String[]{"MasterComprehensiveFileBatchTask", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--warmup", "0s", "--threads", "1", "--stop-count", "100", "--write-type", "MUST_CACHE", "--read-type", "NO_CACHE", "--create-file-size", "0", "--client-type", "AlluxioHDFS", "--clients", "1", "--cluster-limit", "1", "--cluster-start-delay", "3s", "--bench-timeout", "10m", "--java-opt", " -Xmx4g", "--in-process"});
        String printOutResult = this.mOut.toString();
        List<String> resultList = this.getJsonResult(printOutResult);
        Assert.assertEquals((long)resultList.size(), (long)7L);
        for (int i = 0; i < resultList.size(); ++i) {
            MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)resultList.get(i));
            Assert.assertEquals((Object)summary.getParameters().mOperation.toString(), (Object)this.mOperation.get(i));
            Assert.assertEquals((Object)summary.getParameters().mWarmup, (Object)"0s");
            Assert.assertEquals((long)summary.getParameters().mThreads, (long)1L);
            Assert.assertEquals((long)summary.getParameters().mStopCount, (long)100L);
            Assert.assertEquals((Object)summary.getParameters().mWriteType, (Object)"MUST_CACHE");
            Assert.assertEquals((Object)summary.getParameters().mReadType.toString(), (Object)"NO_CACHE");
            Assert.assertEquals((Object)summary.getParameters().mCreateFileSize, (Object)"0");
            Assert.assertEquals((Object)summary.getParameters().mClientType, (Object)FileSystemClientType.ALLUXIO_HDFS);
            Assert.assertEquals((long)summary.getParameters().mClients, (long)1L);
            Map results = summary.getNodeResults();
            Assert.assertFalse((boolean)results.isEmpty());
            for (MasterBenchTaskResult res : results.values()) {
                Assert.assertEquals((long)res.getBaseParameters().mClusterLimit, (long)1L);
                Assert.assertEquals((Object)res.getBaseParameters().mClusterStartDelay, (Object)"3s");
                Assert.assertEquals((Object)res.getBaseParameters().mBenchTimeout, (Object)"10m");
                Assert.assertEquals(res.getBaseParameters().mJavaOpts.get(0), (Object)" -Xmx4g");
            }
            Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
        }
    }

    @Test
    public void MasterIntegrationFileTestWriteType() throws Exception {
        ImmutableList writeTypes = ImmutableList.of((Object)"MUST_CACHE", (Object)"CACHE_THROUGH", (Object)"ASYNC_THROUGH", (Object)"THROUGH");
        for (String type : writeTypes) {
            BatchTaskRunner.main((String[])new String[]{"MasterComprehensiveFileBatchTask", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--warmup", "0s", "--threads", "1", "--stop-count", "100", "--write-type", type, "--read-type", "NO_CACHE", "--client-type", "AlluxioHDFS", "--create-file-size", "0", "--in-process"});
            String printOutResult = this.mOut.toString();
            List<String> resultList = this.getJsonResult(printOutResult);
            Assert.assertEquals((long)resultList.size(), (long)7L);
            this.mOut.reset();
            for (int i = 0; i < resultList.size(); ++i) {
                MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)resultList.get(i));
                Assert.assertEquals((Object)summary.getParameters().mOperation.toString(), (Object)this.mOperation.get(i));
                Assert.assertEquals((Object)summary.getParameters().mWarmup, (Object)"0s");
                Assert.assertEquals((long)summary.getParameters().mThreads, (long)1L);
                Assert.assertEquals((long)summary.getParameters().mStopCount, (long)100L);
                Assert.assertEquals((Object)summary.getParameters().mWriteType, (Object)type);
                Assert.assertEquals((Object)summary.getParameters().mReadType.toString(), (Object)"NO_CACHE");
                Assert.assertEquals((Object)summary.getParameters().mCreateFileSize, (Object)"0");
                Assert.assertEquals((Object)summary.getParameters().mClientType, (Object)FileSystemClientType.ALLUXIO_HDFS);
                Map results = summary.getNodeResults();
                Assert.assertFalse((boolean)results.isEmpty());
                Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
            }
        }
    }

    @Test
    public void MasterIntegrationFileTestWriteTypeAll() throws Exception {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream originalErr = System.err;
        System.setErr(new PrintStream(err));
        BatchTaskRunner.main((String[])new String[]{"MasterComprehensiveFileBatchTask", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--warmup", "0s", "--threads", "1", "--stop-count", "100", "--write-type", "ALL", "--read-type", "NO_CACHE", "--client-type", "AlluxioHDFS", "--create-file-size", "0", "--in-process"});
        Assert.assertEquals((Object)err.toString(), (Object)"Parameter write-type ALL is not supported in batch task MasterComprehensiveFileBatchTask");
        System.setErr(originalErr);
    }

    @Test
    public void MasterIntegrationFileTestReadType() throws Exception {
        ImmutableList readTypes = ImmutableList.of((Object)"NO_CACHE", (Object)"CACHE", (Object)"CACHE_PROMOTE");
        for (String type : readTypes) {
            BatchTaskRunner.main((String[])new String[]{"MasterComprehensiveFileBatchTask", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--warmup", "0s", "--threads", "1", "--stop-count", "100", "--write-type", "MUST_CACHE", "--read-type", type, "--client-type", "AlluxioHDFS", "--create-file-size", "0", "--in-process"});
            String printOutResult = this.mOut.toString();
            List<String> resultList = this.getJsonResult(printOutResult);
            Assert.assertEquals((long)resultList.size(), (long)7L);
            this.mOut.reset();
            for (int i = 0; i < resultList.size(); ++i) {
                MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)resultList.get(i));
                Assert.assertEquals((Object)summary.getParameters().mOperation.toString(), (Object)this.mOperation.get(i));
                Assert.assertEquals((Object)summary.getParameters().mWarmup, (Object)"0s");
                Assert.assertEquals((long)summary.getParameters().mThreads, (long)1L);
                Assert.assertEquals((long)summary.getParameters().mStopCount, (long)100L);
                Assert.assertEquals((Object)summary.getParameters().mWriteType, (Object)"MUST_CACHE");
                Assert.assertEquals((Object)summary.getParameters().mReadType.toString(), (Object)type);
                Assert.assertEquals((Object)summary.getParameters().mClientType, (Object)FileSystemClientType.ALLUXIO_HDFS);
                Assert.assertEquals((Object)summary.getParameters().mCreateFileSize, (Object)"0");
                Map results = summary.getNodeResults();
                Assert.assertFalse((boolean)results.isEmpty());
                Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
            }
        }
    }

    @Test
    public void MasterIntegrationFileTestFileSize() throws Exception {
        ImmutableList fileSizes = ImmutableList.of((Object)"0", (Object)"1k", (Object)"5k", (Object)"1m");
        for (String size : fileSizes) {
            BatchTaskRunner.main((String[])new String[]{"MasterComprehensiveFileBatchTask", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--warmup", "0s", "--threads", "1", "--stop-count", "10", "--write-type", "MUST_CACHE", "--read-type", "NO_CACHE", "--client-type", "AlluxioHDFS", "--create-file-size", size, "--in-process"});
            String printOutResult = this.mOut.toString();
            List<String> resultList = this.getJsonResult(printOutResult);
            Assert.assertEquals((long)resultList.size(), (long)7L);
            this.mOut.reset();
            for (int i = 0; i < resultList.size(); ++i) {
                MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)resultList.get(i));
                Assert.assertEquals((Object)summary.getParameters().mOperation.toString(), (Object)this.mOperation.get(i));
                Assert.assertEquals((Object)summary.getParameters().mWarmup, (Object)"0s");
                Assert.assertEquals((long)summary.getParameters().mThreads, (long)1L);
                Assert.assertEquals((long)summary.getParameters().mStopCount, (long)10L);
                Assert.assertEquals((Object)summary.getParameters().mWriteType, (Object)"MUST_CACHE");
                Assert.assertEquals((Object)summary.getParameters().mReadType.toString(), (Object)"NO_CACHE");
                Assert.assertEquals((Object)summary.getParameters().mClientType, (Object)FileSystemClientType.ALLUXIO_HDFS);
                Assert.assertEquals((Object)summary.getParameters().mCreateFileSize, (Object)size);
                Map results = summary.getNodeResults();
                Assert.assertFalse((boolean)results.isEmpty());
                Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
            }
        }
    }
}

