/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.stress.AbstractStressBenchIntegrationTest;
import alluxio.stress.cli.client.StressClientIOBench;
import alluxio.stress.client.ClientIOSummary;
import alluxio.stress.client.ClientIOTaskResult;
import alluxio.util.JsonSerializable;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="need to fix the tests")
public class StressClientIOBenchIntegrationTest
extends AbstractStressBenchIntegrationTest {
    @Test
    public void readIO() throws Exception {
        String output1 = new StressClientIOBench().run(new String[]{"--in-process", "--start-ms", Long.toString(System.currentTimeMillis() + 5000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "Write", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        String output2 = new StressClientIOBench().run(new String[]{"--in-process", "--tag", "ReadArray-NOT_RANDOM", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "ReadArray", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        String output3 = new StressClientIOBench().run(new String[]{"--in-process", "--read-random", "--tag", "ReadArray-RANDOM", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "ReadArray", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        String output4 = new StressClientIOBench().run(new String[]{"--in-process", "--read-random", "--tag", "ReadByteBuffer", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "ReadByteBuffer", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        String output5 = new StressClientIOBench().run(new String[]{"--in-process", "--read-random", "--tag", "ReadFully", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "ReadFully", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        String output6 = new StressClientIOBench().run(new String[]{"--in-process", "--read-random", "--tag", "PosRead-test", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "PosRead", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        String output7 = new StressClientIOBench().run(new String[]{"--in-process", "--read-random", "--tag", "PosReadFully", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "PosReadFully", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s"});
        this.generateAndVerifyReport(Arrays.asList("Write", "ReadArray-NOT_RANDOM", "ReadArray-RANDOM", "ReadByteBuffer", "ReadFully", "PosRead-test", "PosReadFully"), output1, output2, output3, output4, output5, output6, output7);
    }

    @Test
    public void WriteTypeSingleTaskTest() throws Exception {
        String[] writeType = new String[]{"MUST_CACHE", "CACHE_THROUGH", "THROUGH", "ASYNC_THROUGH"};
        for (int i = 0; i < writeType.length; ++i) {
            this.validateTheResultWithWriteType(writeType[i]);
        }
    }

    private void validateTheResultWithWriteType(String writeType) throws Exception {
        String output = new StressClientIOBench().run(new String[]{"--in-process", "--start-ms", Long.toString(System.currentTimeMillis() + 5000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "Write", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s", "--write-type", writeType});
        ClientIOSummary summary = (ClientIOSummary)JsonSerializable.fromJson((String)output);
        Assert.assertFalse((boolean)summary.getNodeResults().isEmpty());
        for (ClientIOTaskResult taskResult : summary.getNodeResults().values()) {
            Assert.assertFalse((boolean)taskResult.getThreadCountResults().isEmpty());
            for (ClientIOTaskResult.ThreadCountResult threadResult : taskResult.getThreadCountResults().values()) {
                Assert.assertTrue((boolean)threadResult.getErrors().isEmpty());
            }
        }
    }

    @Test
    public void writeTypeALLTaskTest() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream originalOut = System.out;
        System.setOut(new PrintStream(out));
        new StressClientIOBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/client/", "--operation", "Write", "--threads", "2", "--file-size", "1m", "--buffer-size", "128k", "--warmup", "0s", "--duration", "1s", "--write-type", "ALL"});
        String printOutResult = out.toString();
        List<String> resultList = this.getJsonResult(printOutResult);
        Assert.assertEquals((long)resultList.size(), (long)4L);
        ImmutableList writeTypes = ImmutableList.of((Object)"MUST_CACHE", (Object)"CACHE_THROUGH", (Object)"ASYNC_THROUGH", (Object)"THROUGH");
        for (int i = 0; i < resultList.size(); ++i) {
            ClientIOSummary summary = (ClientIOSummary)JsonSerializable.fromJson((String)resultList.get(i));
            Assert.assertEquals((Object)summary.getParameters().mWriteType, writeTypes.get(i));
            Assert.assertFalse((boolean)summary.getNodeResults().isEmpty());
            for (ClientIOTaskResult taskResult : summary.getNodeResults().values()) {
                Assert.assertFalse((boolean)taskResult.getThreadCountResults().isEmpty());
                for (ClientIOTaskResult.ThreadCountResult threadResult : taskResult.getThreadCountResults().values()) {
                    Assert.assertTrue((boolean)threadResult.getErrors().isEmpty());
                }
            }
        }
        System.setOut(originalOut);
    }
}

