/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.stress.AbstractStressBenchIntegrationTest;
import alluxio.stress.cli.StressMasterBench;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.util.JsonSerializable;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="these tests should be moved to worker")
public class StressMasterBenchIntegrationTest
extends AbstractStressBenchIntegrationTest {
    @Test
    public void createFileAndDelete() throws Exception {
        String output = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "CreateFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        this.generateAndVerifyReport(Collections.singletonList("CreateFile"), output);
        output = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "CreateFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "2", "--warmup", "0s", "--duration", "1s"});
        String output2 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "GetBlockLocations", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        String output3 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "OpenFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        String output4 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "DeleteFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        this.generateAndVerifyReport(Arrays.asList("CreateFile", "GetBlockLocations", "OpenFile", "DeleteFile"), output, output2, output3, output4);
    }

    @Test
    public void createDir() throws Exception {
        String output = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "CreateDir", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        this.generateAndVerifyReport(Collections.singletonList("CreateDir"), output);
    }

    @Test
    public void createFileAndListAndRename() throws Exception {
        String output1 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "CreateFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        String output2 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "GetFileStatus", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        String output3 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "ListDir", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        String output4 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "ListDirLocated", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        String output5 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "RenameFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s"});
        this.generateAndVerifyReport(Arrays.asList("CreateFile", "GetFileStatus", "ListDir", "ListDirLocated", "RenameFile"), output1, output2, output3, output4, output5);
    }

    @Test
    public void writeTypeSingleTaskTest() throws Exception {
        String[] writeType = new String[]{"MUST_CACHE", "CACHE_THROUGH", "THROUGH", "ASYNC_THROUGH"};
        for (int i = 0; i < writeType.length; ++i) {
            this.validateTheResultWithWriteType(writeType[i]);
        }
    }

    private void validateTheResultWithWriteType(String writeType) throws Exception {
        String output1 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "CreateFile", "--fixed-count", "20", "--target-throughput", "300", "--threads", "5", "--warmup", "0s", "--duration", "3s", "--write-type", writeType});
        String output2 = new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "DeleteFile", "--fixed-count", "20", "--target-throughput", "100", "--threads", "5", "--warmup", "0s", "--duration", "1s", "--write-type", writeType});
        MasterBenchSummary summary1 = (MasterBenchSummary)JsonSerializable.fromJson((String)output1);
        MasterBenchSummary summary2 = (MasterBenchSummary)JsonSerializable.fromJson((String)output2);
        Assert.assertFalse((boolean)summary1.getNodeResults().isEmpty());
        Assert.assertTrue((boolean)summary1.collectErrorsFromAllNodes().isEmpty());
        Assert.assertFalse((boolean)summary2.getNodeResults().isEmpty());
        Assert.assertTrue((boolean)summary2.collectErrorsFromAllNodes().isEmpty());
    }

    @Test
    public void writeTypeALLTaskTest() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream originalOut = System.out;
        System.setOut(new PrintStream(out));
        new StressMasterBench().run(new String[]{"--in-process", "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/", "--operation", "CreateFile", "--fixed-count", "20", "--target-throughput", "300", "--threads", "5", "--warmup", "0s", "--duration", "3s", "--write-type", "ALL"});
        String printOutResult = out.toString();
        List<String> resultList = this.getJsonResult(printOutResult);
        Assert.assertEquals((long)resultList.size(), (long)4L);
        ImmutableList writeTypes = ImmutableList.of((Object)"MUST_CACHE", (Object)"CACHE_THROUGH", (Object)"ASYNC_THROUGH", (Object)"THROUGH");
        for (int i = 0; i < resultList.size(); ++i) {
            MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)resultList.get(i));
            Assert.assertEquals((Object)summary.getParameters().mWriteType, writeTypes.get(i));
            Assert.assertFalse((boolean)summary.getNodeResults().isEmpty());
            Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
        }
        System.setOut(originalOut);
    }

    @Test
    public void testForMultipleNodeResults() throws Exception {
        String[] operations;
        for (String op : operations = new String[]{"CreateFile", "GetBlockLocations", "GetFileStatus", "OpenFile", "ListDir", "ListDirLocated", "RenameFile", "CreateFile", "DeleteFile", "CreateDir"}) {
            this.validateTheOutput(op);
        }
    }

    private void validateTheOutput(String operation) throws Exception {
        long startTime = System.currentTimeMillis();
        String basePath = sLocalAlluxioClusterResource.get().getMasterURI() + "/";
        String output = new StressMasterBench().run(new String[]{"--in-process", "--base", basePath, "--operation", operation, "--stop-count", "100", "--target-throughput", "1000", "--threads", "5", "--warmup", "0s", "--duration", "10s"});
        MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)output);
        Assert.assertEquals((Object)summary.getParameters().mOperation.toString(), (Object)operation);
        Assert.assertEquals((Object)summary.getParameters().mBasePath, (Object)basePath);
        Assert.assertEquals((long)summary.getParameters().mStopCount, (long)100L);
        Assert.assertEquals((long)summary.getParameters().mTargetThroughput, (long)1000L);
        Assert.assertEquals((long)summary.getParameters().mThreads, (long)5L);
        Assert.assertEquals((Object)summary.getParameters().mWarmup, (Object)"0s");
        Assert.assertEquals((Object)summary.getParameters().mDuration, (Object)"10s");
        Assert.assertTrue((summary.getEndTimeMs() > startTime ? 1 : 0) != 0);
        Assert.assertTrue((summary.getNodeResults().size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((summary.getDurationMs() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((summary.getThroughput() > 0.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)summary.getStatistics().mNumSuccesses, (long)100L);
        Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
    }
}

