/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.stress.AbstractStressBenchIntegrationTest;
import alluxio.stress.cli.worker.StressWorkerBench;
import alluxio.stress.worker.WorkerBenchSummary;
import alluxio.util.JsonSerializable;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class StressWorkerBenchIntegrationTest
extends AbstractStressBenchIntegrationTest {
    @Test
    public void readThroughput() throws Exception {
        String output = new StressWorkerBench().run(new String[]{"--in-process", "--start-ms", Long.toString(System.currentTimeMillis() + 1000L), "--base", sLocalAlluxioClusterResource.get().getMasterURI() + "/stress-worker-base/", "--threads", "2", "--file-size", "1m", "--block-size", "128k", "--warmup", "0s", "--duration", "1s"});
        this.generateAndVerifyReport(Collections.singletonList("Worker Throughput"), output);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="multiple node results is unsupported in DORA")
    public void testForMultipleNodeResults() throws Exception {
        long startTime = System.currentTimeMillis();
        String basePath = sLocalAlluxioClusterResource.get().getMasterURI() + "/stress-worker-base/";
        String output = new StressWorkerBench().run(new String[]{"--in-process", "--base", basePath, "--threads", "2", "--file-size", "1m", "--block-size", "128k", "--warmup", "0s", "--duration", "1s"});
        WorkerBenchSummary summary = (WorkerBenchSummary)JsonSerializable.fromJson((String)output);
        Assert.assertEquals((Object)summary.getParameters().mBasePath, (Object)basePath);
        Assert.assertEquals((Object)summary.getParameters().mFileSize, (Object)"1m");
        Assert.assertEquals((long)summary.getParameters().mThreads, (long)2L);
        Assert.assertEquals((Object)summary.getParameters().mBlockSize, (Object)"128k");
        Assert.assertEquals((Object)summary.getParameters().mWarmup, (Object)"0s");
        Assert.assertEquals((Object)summary.getParameters().mDuration, (Object)"1s");
        Assert.assertTrue((summary.getEndTimeMs() > startTime ? 1 : 0) != 0);
        Assert.assertTrue((summary.getIOBytes() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((summary.getDurationMs() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((summary.getNodeResults().size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)summary.collectErrorsFromAllNodes().isEmpty());
    }
}

