/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.Master;
import alluxio.master.MasterClientContext;
import alluxio.master.NoopMaster;
import alluxio.master.PortRegistry;
import alluxio.master.journal.JournalUtils;
import alluxio.master.journal.ufs.UfsJournal;
import alluxio.master.journal.ufs.UfsJournalSnapshot;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.util.URIUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeoutException;

public final class IntegrationTestUtils {
    public static void waitForPersist(LocalAlluxioClusterResource localAlluxioClusterResource, AlluxioURI uri) throws TimeoutException, InterruptedException {
        IntegrationTestUtils.waitForPersist(localAlluxioClusterResource, uri, 15000);
    }

    public static void waitForPersist(LocalAlluxioClusterResource localAlluxioClusterResource, AlluxioURI uri, int timeoutMs) throws InterruptedException, TimeoutException {
        try (FileSystemMasterClient client = FileSystemMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());){
            CommonUtils.waitFor((String)(uri + " to be persisted"), () -> {
                try {
                    return client.getStatus(uri, FileSystemOptionsUtils.getStatusDefaults((AlluxioConfiguration)Configuration.global())).isPersisted();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)timeoutMs));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForFileCached(FileSystem fileSystem, AlluxioURI uri, int timeoutMs) throws TimeoutException, InterruptedException {
        CommonUtils.waitFor((String)(uri + " to be cached"), () -> {
            try {
                return fileSystem.getStatus(uri).getInAlluxioPercentage() == 100;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs((long)timeoutMs));
    }

    public static void waitForUfsJournalCheckpoint(String masterName) throws TimeoutException, InterruptedException {
        IntegrationTestUtils.waitForUfsJournalCheckpoint(masterName, JournalUtils.getJournalLocation());
    }

    public static void waitForUfsJournalCheckpoint(String masterName, URI journalLocation) throws TimeoutException, InterruptedException {
        UfsJournal journal = new UfsJournal(URIUtils.appendPathOrDie((URI)journalLocation, (String)masterName), (Master)new NoopMaster(""), 0L, Collections::emptySet);
        CommonUtils.waitFor((String)"checkpoint to be written", () -> {
            UfsJournalSnapshot snapshot;
            try {
                snapshot = UfsJournalSnapshot.getSnapshot((UfsJournal)journal);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return !snapshot.getCheckpoints().isEmpty();
        });
    }

    public static void reserveMasterPorts() {
        for (NetworkAddressUtils.ServiceType service : Arrays.asList(NetworkAddressUtils.ServiceType.MASTER_RPC, NetworkAddressUtils.ServiceType.MASTER_WEB, NetworkAddressUtils.ServiceType.MASTER_RAFT, NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, NetworkAddressUtils.ServiceType.JOB_MASTER_WEB, NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT)) {
            PropertyKey key = service.getPortKey();
            Configuration.set((PropertyKey)key, (Object)PortRegistry.reservePort());
        }
    }

    public static void releaseMasterPorts() {
        PortRegistry.clear();
    }

    public static String getTestName(String className, String methodName) {
        String testName = className + "-" + methodName;
        testName = testName.replace(".", "-");
        testName = testName.replace("[", "-");
        testName = testName.replace("]", "");
        return testName;
    }

    private IntegrationTestUtils() {
    }
}

