/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedClientUserResource;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.DeletePOptions;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.DeleteContext;
import alluxio.master.file.contexts.ListStatusContext;
import alluxio.metrics.MetricsSystem;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.underfs.UfsMode;
import alluxio.util.SecurityUtils;
import alluxio.wire.FileInfo;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@NotThreadSafe
public final class LocalAlluxioClusterResource
implements TestRule {
    private final int mNumWorkers;
    private final boolean mIncludeProxy;
    private final boolean mStartCluster;
    private final Map<PropertyKey, Object> mConfiguration = new HashMap<PropertyKey, Object>();
    private LocalAlluxioCluster mLocalAlluxioCluster = null;
    private String mTestName = "test";

    private LocalAlluxioClusterResource(boolean startCluster, boolean includeProxy, int numWorkers, Map<PropertyKey, Object> configuration) {
        this.mStartCluster = startCluster;
        this.mIncludeProxy = includeProxy;
        this.mNumWorkers = numWorkers;
        this.mConfiguration.putAll(configuration);
        MetricsSystem.resetCountersAndGauges();
    }

    public LocalAlluxioCluster get() {
        return this.mLocalAlluxioCluster;
    }

    public LocalAlluxioClusterResource setProperty(PropertyKey key, Object value) {
        if (value == null) {
            this.mConfiguration.remove(key);
        } else {
            this.mConfiguration.put(key, value);
        }
        return this;
    }

    public void start() throws Exception {
        AuthenticatedClientUser.remove();
        this.mLocalAlluxioCluster = new LocalAlluxioCluster(this.mNumWorkers, this.mIncludeProxy);
        this.mLocalAlluxioCluster.initConfiguration(this.mTestName);
        for (Map.Entry<PropertyKey, Object> entry : this.mConfiguration.entrySet()) {
            Configuration.set((PropertyKey)entry.getKey(), (Object)entry.getValue());
        }
        Configuration.global().validate();
        this.mLocalAlluxioCluster.start();
    }

    public void stop() throws Exception {
        this.mLocalAlluxioCluster.stop();
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                IntegrationTestUtils.reserveMasterPorts();
                LocalAlluxioClusterResource.this.mTestName = IntegrationTestUtils.getTestName(description.getTestClass().getSimpleName(), description.getMethodName());
                try {
                    try {
                        Annotation configAnnotation = description.getAnnotation(ServerConfig.class);
                        if (configAnnotation != null) {
                            LocalAlluxioClusterResource.this.overrideConfiguration(((ServerConfig)configAnnotation).confParams());
                        }
                        boolean startCluster = LocalAlluxioClusterResource.this.mStartCluster;
                        configAnnotation = description.getAnnotation(Config.class);
                        if (configAnnotation != null) {
                            Config config = (Config)configAnnotation;
                            LocalAlluxioClusterResource.this.overrideConfiguration(config.confParams());
                            startCluster = config.startCluster();
                        }
                        if (startCluster) {
                            LocalAlluxioClusterResource.this.start();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        statement.evaluate();
                    }
                    finally {
                        LocalAlluxioClusterResource.this.stop();
                    }
                }
                finally {
                    IntegrationTestUtils.releaseMasterPorts();
                }
            }
        };
    }

    private void overrideConfiguration(String[] config) {
        for (int i = 0; i < config.length; i += 2) {
            PropertyKey key = PropertyKey.fromString((String)config[i]);
            this.mConfiguration.put(key, key.parseValue(config[i + 1]));
        }
    }

    public TestRule getResetResource() {
        return new ResetRule(this);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ServerConfig {
        public String[] confParams() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Config {
        public String[] confParams() default {};

        public boolean startCluster() default true;
    }

    private final class ResetRule
    implements TestRule {
        private final LocalAlluxioClusterResource mCluster;

        ResetRule(LocalAlluxioClusterResource cluster) {
            this.mCluster = cluster;
        }

        public Statement apply(final Statement statement, Description description) {
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void evaluate() throws Throwable {
                    try {
                        statement.evaluate();
                        return;
                    }
                    finally {
                        FileSystemMaster fsm = (FileSystemMaster)ResetRule.this.mCluster.mLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
                        if (SecurityUtils.isAuthenticationEnabled((AlluxioConfiguration)Configuration.global())) {
                            try (AuthenticatedClientUserResource r = new AuthenticatedClientUserResource(fsm.getRootInodeOwner(), Configuration.global());){
                                ResetRule.this.resetCluster(fsm);
                            }
                        } else {
                            ResetRule.this.resetCluster(fsm);
                        }
                    }
                }
            };
        }

        private void resetCluster(FileSystemMaster fsm) throws Exception {
            if (!this.mCluster.get().getLocalAlluxioMaster().isServing()) {
                this.mCluster.mLocalAlluxioCluster.startMasters();
                fsm = (FileSystemMaster)this.mCluster.mLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
            }
            if (!this.mCluster.get().isStartedWorkers()) {
                this.mCluster.get().startWorkers();
            }
            fsm.updateUfsMode(new AlluxioURI(fsm.getUfsAddress()), UfsMode.READ_WRITE);
            for (FileInfo fileInfo : fsm.listStatus(new AlluxioURI("/"), ListStatusContext.defaults())) {
                fsm.delete(new AlluxioURI(fileInfo.getPath()), DeleteContext.create((DeletePOptions.Builder)DeletePOptions.newBuilder().setUnchecked(true).setRecursive(true).setDeleteMountPoint(true)));
            }
        }
    }

    public static class Builder {
        private boolean mStartCluster = true;
        private boolean mIncludeProxy = false;
        private int mNumWorkers = 1;
        private Map<PropertyKey, Object> mConfiguration = new HashMap<PropertyKey, Object>();

        public Builder setStartCluster(boolean startCluster) {
            this.mStartCluster = startCluster;
            return this;
        }

        public Builder setIncludeProxy(boolean includeProxy) {
            this.mIncludeProxy = includeProxy;
            return this;
        }

        public Builder setNumWorkers(int numWorkers) {
            this.mNumWorkers = numWorkers;
            return this;
        }

        public Builder setProperty(PropertyKey key, Object value) {
            this.mConfiguration.put(key, value);
            return this;
        }

        public LocalAlluxioClusterResource build() {
            return new LocalAlluxioClusterResource(this.mStartCluster, this.mIncludeProxy, this.mNumWorkers, this.mConfiguration);
        }
    }
}

