/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils;

import alluxio.master.file.FileSystemMaster;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.powermock.reflect.Whitebox;

@NotThreadSafe
public final class PersistenceTestUtils {
    public static void pauseScheduler(LocalAlluxioClusterResource resource) {
        FileSystemMaster nestedMaster = PersistenceTestUtils.getFileSystemMaster(resource);
        Map persistRequests = (Map)Whitebox.getInternalState((Object)nestedMaster, (String)"mPersistRequests");
        Whitebox.setInternalState((Object)nestedMaster, (String)"mPersistRequests", new BlackHoleMap(persistRequests));
    }

    public static void resumeScheduler(LocalAlluxioClusterResource resource) {
        FileSystemMaster nestedMaster = PersistenceTestUtils.getFileSystemMaster(resource);
        BlackHoleMap persistRequests = (BlackHoleMap)Whitebox.getInternalState((Object)nestedMaster, (String)"mPersistRequests");
        Whitebox.setInternalState((Object)nestedMaster, (String)"mPersistRequests", persistRequests.getInnerMap());
    }

    public static void pauseChecker(LocalAlluxioClusterResource resource) {
        FileSystemMaster nestedMaster = PersistenceTestUtils.getFileSystemMaster(resource);
        Map persistJobs = (Map)Whitebox.getInternalState((Object)nestedMaster, (String)"mPersistJobs");
        Whitebox.setInternalState((Object)nestedMaster, (String)"mPersistJobs", new BlackHoleMap(persistJobs));
    }

    public static void resumeChecker(LocalAlluxioClusterResource resource) {
        FileSystemMaster nestedMaster = PersistenceTestUtils.getFileSystemMaster(resource);
        BlackHoleMap persistJobs = (BlackHoleMap)Whitebox.getInternalState((Object)nestedMaster, (String)"mPersistJobs");
        Whitebox.setInternalState((Object)nestedMaster, (String)"mPersistJobs", persistJobs.getInnerMap());
    }

    public static void waitForJobScheduled(LocalAlluxioClusterResource resource, long fileId) throws Exception {
        FileSystemMaster master = PersistenceTestUtils.getFileSystemMaster(resource);
        CommonUtils.waitFor((String)String.format("Persisted job scheduled for fileId %d", fileId), () -> {
            FileSystemMaster nestedMaster = master;
            Map requests = (Map)Whitebox.getInternalState((Object)nestedMaster, (String)"mPersistRequests");
            return !requests.containsKey(fileId);
        });
    }

    public static void waitForJobComplete(LocalAlluxioClusterResource resource, long fileId) throws Exception {
        FileSystemMaster master = PersistenceTestUtils.getFileSystemMaster(resource);
        CommonUtils.waitFor((String)String.format("Persisted job complete for fileId %d", fileId), () -> {
            FileSystemMaster nestedMaster = master;
            Map jobs = (Map)Whitebox.getInternalState((Object)nestedMaster, (String)"mPersistJobs");
            return !jobs.containsKey(fileId);
        });
    }

    private static FileSystemMaster getFileSystemMaster(LocalAlluxioClusterResource resource) {
        return (FileSystemMaster)resource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
    }

    @NotThreadSafe
    private static class BlackHoleMap<T, V>
    extends HashMap<T, V> {
        private Map<T, V> mInnerMap;

        BlackHoleMap(Map<T, V> innerMap) {
            this.mInnerMap = innerMap;
        }

        @Override
        public Set<T> keySet() {
            return new HashSet();
        }

        @Override
        public V put(T key, V value) {
            return this.mInnerMap.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.mInnerMap.remove(key);
        }

        public Map<T, V> getInnerMap() {
            return this.mInnerMap;
        }
    }
}

