/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils.underfs;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.local.LocalUnderFileSystem;
import com.google.common.base.Preconditions;
import java.util.Map;

public final class ConfExpectingUnderFileSystemFactory
implements UnderFileSystemFactory {
    public final String mScheme;
    private final Map<String, String> mExpectedConf;

    public ConfExpectingUnderFileSystemFactory(String scheme, Map<String, String> expectedConf) {
        this.mScheme = scheme;
        this.mExpectedConf = expectedConf;
    }

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkArgument((boolean)this.mExpectedConf.equals(conf.getMountSpecificConf()), (String)"ufs conf {} does not match expected {}", (Object)conf, this.mExpectedConf);
        return new LocalUnderFileSystem(new AlluxioURI(new AlluxioURI(path).getPath()), conf);
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith(this.mScheme + ":///");
    }
}

