/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils.underfs.sleeping;

import alluxio.AlluxioURI;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.local.LocalUnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetStatusOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class SleepingUnderFileSystem
extends LocalUnderFileSystem {
    private static final String SLEEP_SCHEME = "sleep";
    private final SleepingUnderFileSystemOptions mOptions;

    public SleepingUnderFileSystem(AlluxioURI uri, SleepingUnderFileSystemOptions options, UnderFileSystemConfiguration ufsConf) {
        super(uri, ufsConf);
        this.mOptions = options;
    }

    public void cleanup() throws IOException {
        this.sleepIfNecessary(this.mOptions.getCleanupMs());
        super.cleanup();
    }

    public void close() throws IOException {
        this.sleepIfNecessary(this.mOptions.getCloseMs());
        super.close();
    }

    public void connectFromMaster(String hostname) throws IOException {
        this.sleepIfNecessary(this.mOptions.getConnectFromMasterMs());
        super.connectFromMaster(hostname);
    }

    public void connectFromWorker(String hostname) throws IOException {
        this.sleepIfNecessary(this.mOptions.getConnectFromWorkerMs());
        super.connectFromWorker(hostname);
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getCreateMs());
        return super.create(this.cleanPath(path), options);
    }

    public OutputStream createDirect(String path, CreateOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getCreateMs());
        return super.createDirect(this.cleanPath(path), options);
    }

    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getDeleteDirectoryMs());
        return super.deleteDirectory(this.cleanPath(path), options);
    }

    public boolean deleteFile(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getDeleteFileMs());
        return super.deleteFile(this.cleanPath(path));
    }

    public boolean exists(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getExistsMs());
        return super.exists(this.cleanPath(path));
    }

    public long getBlockSizeByte(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetBlockSizeByteMs());
        return super.getBlockSizeByte(this.cleanPath(path));
    }

    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetDirectoryStatusMs());
        return super.getDirectoryStatus(this.cleanPath(path));
    }

    public List<String> getFileLocations(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetFileLocationsMs());
        return super.getFileLocations(this.cleanPath(path));
    }

    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetFileLocationsMs());
        return super.getFileLocations(this.cleanPath(path), options);
    }

    public UfsStatus getStatus(String path, GetStatusOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetStatusMs());
        return super.getStatus(this.cleanPath(path), options);
    }

    public UfsFileStatus getFileStatus(String path, GetStatusOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetFileStatusMs());
        return super.getFileStatus(this.cleanPath(path), options);
    }

    public String getFingerprint(String path) {
        this.sleepIfNecessary(this.mOptions.getGetFingerprintMs());
        return super.getFingerprint(this.cleanPath(path));
    }

    public Fingerprint getParsedFingerprint(String path) {
        this.sleepIfNecessary(this.mOptions.getGetFingerprintMs());
        return super.getParsedFingerprint(this.cleanPath(path));
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        this.sleepIfNecessary(this.mOptions.getGetSpaceMs());
        return super.getSpace(this.cleanPath(path), type);
    }

    public String getUnderFSType() {
        this.sleepIfNecessary(this.mOptions.getGetUnderFSTypeMs());
        return super.getUnderFSType();
    }

    public boolean isDirectory(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getIsDirectoryMs());
        return super.isDirectory(this.cleanPath(path));
    }

    public boolean isFile(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getIsFileMs());
        return super.isFile(this.cleanPath(path));
    }

    public UfsStatus[] listStatus(String path) throws IOException {
        this.sleepIfNecessary(this.mOptions.getListStatusMs());
        return super.listStatus(this.cleanPath(path));
    }

    public UfsStatus[] listStatus(String path, ListOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getListStatusWithOptionsMs());
        return super.listStatus(this.cleanPath(path), options);
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getMkdirsMs());
        return super.mkdirs(this.cleanPath(path), options);
    }

    public InputStream open(String path, OpenOptions options) throws IOException {
        this.sleepIfNecessary(this.mOptions.getOpenMs());
        return super.open(this.cleanPath(path), options);
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        this.sleepIfNecessary(this.mOptions.getRenameDirectoryMs());
        return super.renameDirectory(this.cleanPath(src), this.cleanPath(dst));
    }

    public boolean renameFile(String src, String dst) throws IOException {
        if (!PathUtils.isTemporaryFileName((String)src)) {
            this.sleepIfNecessary(this.mOptions.getRenameFileMs());
        } else {
            this.sleepIfNecessary(this.mOptions.getRenameTemporaryFileMs());
        }
        return super.renameFile(this.cleanPath(src), this.cleanPath(dst));
    }

    public void setOwner(String path, String owner, String group) throws IOException {
        this.sleepIfNecessary(this.mOptions.getSetOwnerMs());
        super.setOwner(this.cleanPath(path), owner, group);
    }

    public void setMode(String path, short mode) throws IOException {
        this.sleepIfNecessary(this.mOptions.getSetModeMs());
        super.setMode(this.cleanPath(path), mode);
    }

    public boolean supportsFlush() throws IOException {
        this.sleepIfNecessary(this.mOptions.getSupportsFlushMs());
        return super.supportsFlush();
    }

    private String cleanPath(String path) {
        AlluxioURI uri = new AlluxioURI(path);
        if (SLEEP_SCHEME.equals(uri.getScheme())) {
            return uri.getPath();
        }
        return path;
    }

    private void sleepIfNecessary(long duration) {
        if (duration >= 0L) {
            CommonUtils.sleepMs((long)duration);
        }
    }
}

