/*
 * Decompiled with CFR 0.152.
 */
package alluxio.testutils.underfs.sleeping;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystem;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import com.google.common.base.Preconditions;

public class SleepingUnderFileSystemFactory
implements UnderFileSystemFactory {
    private SleepingUnderFileSystemOptions mOptions;
    private SleepingUnderFileSystem mUfs;

    public SleepingUnderFileSystemFactory(SleepingUnderFileSystemOptions options) {
        this.mOptions = options;
    }

    public SleepingUnderFileSystemFactory(SleepingUnderFileSystem ufs) {
        this.mUfs = ufs;
    }

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        InstancedConfiguration confCopy = new InstancedConfiguration(conf.copyProperties());
        confCopy.set(PropertyKey.MASTER_UFS_MANAGED_BLOCKING_ENABLED, (Object)true);
        if (this.mUfs == null) {
            Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
            return new SleepingUnderFileSystem(new AlluxioURI(path), this.mOptions, new UnderFileSystemConfiguration((AlluxioConfiguration)confCopy, conf.isReadOnly()));
        }
        return this.mUfs;
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("sleep:///");
    }
}

