/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.block.BlockMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.status.UnavailableException;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.MasterClientContext;
import alluxio.master.MasterInquireClient;
import alluxio.master.SingleMasterInquireClient;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.channels.SocketChannel;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class ServiceSocketBindIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setStartCluster(false).build();
    private LocalAlluxioCluster mLocalAlluxioCluster = null;
    private BlockMasterClient mBlockMasterClient;
    private HttpURLConnection mMasterWebService;
    private SocketChannel mWorkerDataService;
    private HttpURLConnection mWorkerWebService;

    private void startCluster(String bindHost) throws Exception {
        for (NetworkAddressUtils.ServiceType service : NetworkAddressUtils.ServiceType.values()) {
            this.mLocalAlluxioClusterResource.setProperty(service.getBindHostKey(), bindHost);
        }
        this.mLocalAlluxioClusterResource.start();
        this.mLocalAlluxioCluster = this.mLocalAlluxioClusterResource.get();
    }

    private void connectServices() throws IOException, ConnectionFailedException {
        this.mBlockMasterClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        this.mBlockMasterClient.connect();
        WorkerNetAddress workerAddress = this.mLocalAlluxioCluster.getWorkerAddress();
        this.mWorkerDataService = SocketChannel.open(new InetSocketAddress(workerAddress.getHost(), workerAddress.getDataPort()));
        InetSocketAddress masterWebAddr = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_WEB, (AlluxioConfiguration)Configuration.global());
        this.mMasterWebService = (HttpURLConnection)new URL("http://" + (masterWebAddr.isUnresolved() ? masterWebAddr.toString() : masterWebAddr.getAddress().getHostAddress() + ":" + masterWebAddr.getPort()) + "/index.html").openConnection();
        this.mMasterWebService.connect();
        InetSocketAddress workerWebAddr = new InetSocketAddress(workerAddress.getHost(), workerAddress.getWebPort());
        this.mWorkerWebService = (HttpURLConnection)new URL("http://" + workerWebAddr.getAddress().getHostAddress() + ":" + workerWebAddr.getPort() + "/index.html").openConnection();
        this.mWorkerWebService.connect();
    }

    private void closeServices() throws Exception {
        this.mWorkerWebService.disconnect();
        this.mWorkerDataService.close();
        this.mMasterWebService.disconnect();
        this.mBlockMasterClient.close();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="Web UI services needs to be fixed")
    public void listenEmpty() throws Exception {
        this.startCluster(null);
        boolean allConnected = true;
        try {
            this.connectServices();
        }
        catch (Exception e) {
            allConnected = false;
        }
        Assert.assertTrue((boolean)allConnected);
        Assert.assertTrue((boolean)this.mBlockMasterClient.isConnected());
        Assert.assertTrue((boolean)this.mWorkerDataService.isConnected());
        Assert.assertEquals((long)200L, (long)this.mMasterWebService.getResponseCode());
        Assert.assertEquals((long)200L, (long)this.mWorkerWebService.getResponseCode());
        this.closeServices();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="Web UI services needs to be fixed")
    public void listenSameAddress() throws Exception {
        this.startCluster(NetworkAddressUtils.getLocalHostName((int)100));
        boolean allConnected = true;
        try {
            this.connectServices();
        }
        catch (Exception e) {
            allConnected = false;
        }
        Assert.assertTrue((boolean)allConnected);
        Assert.assertTrue((boolean)this.mBlockMasterClient.isConnected());
        Assert.assertTrue((boolean)this.mWorkerDataService.isConnected());
        Assert.assertEquals((long)200L, (long)this.mMasterWebService.getResponseCode());
        Assert.assertEquals((long)200L, (long)this.mWorkerWebService.getResponseCode());
        this.closeServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectDifferentAddress() throws Exception {
        this.startCluster(NetworkAddressUtils.getLocalHostName((int)100));
        InetSocketAddress masterRpcAddr = new InetSocketAddress("127.0.0.1", this.mLocalAlluxioCluster.getLocalAlluxioMaster().getRpcLocalPort());
        this.mBlockMasterClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).setMasterInquireClient((MasterInquireClient)new SingleMasterInquireClient(masterRpcAddr)).build());
        try {
            this.mBlockMasterClient.connect();
            Assert.fail((String)"Client should not have successfully connected to master RPC service.");
        }
        catch (UnavailableException unavailableException) {
            // empty catch block
        }
        try {
            this.mBlockMasterClient.connect();
            Assert.fail((String)"Client should not have successfully connected to Worker RPC service.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        InetSocketAddress workerDataAddr = new InetSocketAddress("127.0.0.1", this.mLocalAlluxioCluster.getWorkerProcess().getDataLocalPort());
        try {
            this.mWorkerDataService = SocketChannel.open(workerDataAddr);
            Assert.assertTrue((boolean)this.mWorkerDataService.isConnected());
            Assert.fail((String)"Client should not have successfully connected to Worker RPC service.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mMasterWebService = (HttpURLConnection)new URL("http://127.0.0.1:" + this.mLocalAlluxioCluster.getLocalAlluxioMaster().getMasterProcess().getWebAddress().getPort() + "/home").openConnection();
            Assert.assertEquals((long)200L, (long)this.mMasterWebService.getResponseCode());
            Assert.fail((String)"Client should not have successfully connected to Master Web service.");
        }
        catch (IOException iOException) {
        }
        finally {
            Assert.assertNotNull((Object)this.mMasterWebService);
            this.mMasterWebService.disconnect();
        }
        try {
            this.mWorkerWebService = (HttpURLConnection)new URL("http://127.0.0.1:" + this.mLocalAlluxioCluster.getWorkerProcess().getWebLocalPort() + "/home").openConnection();
            Assert.assertEquals((long)200L, (long)this.mWorkerWebService.getResponseCode());
            Assert.fail((String)"Client should not have successfully connected to Worker Web service.");
        }
        catch (IOException iOException) {
        }
        finally {
            this.mWorkerWebService.disconnect();
        }
    }
}

